/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.reboot;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Date;
import java.util.Properties;
import org.apache.commons.cli.BasicParser;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.mule.runtime.module.reboot.api.MuleContainerBootstrapUtils;
import org.mule.runtime.module.reboot.internal.MuleContainerWrapper;
import org.tanukisoftware.wrapper.WrapperListener;
import org.tanukisoftware.wrapper.WrapperManager;

public class MuleContainerBootstrap {
    private static final String MULE_MODULE_REBOOT_POM_FILE_PATH = "META-INF/maven/org.mule.module/mule-module-reboot/pom.properties";
    public static final String[][] CLI_OPTIONS = new String[][]{{"main", "true", "Main Class"}, {"production", "false", "Modify the system class loader for production use (as in Mule 2.x)"}, {"version", "false", "Show product and version information"}};

    public static void main(String[] args) throws Exception {
        CommandLine commandLine = MuleContainerBootstrap.parseCommandLine(args);
        String[] remainingArgs = commandLine.getArgs();
        MuleContainerBootstrap.prepareBootstrapPhase(commandLine);
        System.out.println("Starting the Mule Container...");
        WrapperManager.start((WrapperListener)new MuleContainerWrapper(), (String[])remainingArgs);
    }

    private static void prepareBootstrapPhase(CommandLine commandLine) throws Exception {
        boolean production = commandLine.hasOption("production");
        MuleContainerBootstrap.prepareBootstrapPhase();
    }

    private static void prepareBootstrapPhase() throws Exception {
        File muleHome = MuleContainerBootstrap.lookupMuleHome();
        File muleBase = MuleContainerBootstrap.lookupMuleBase();
        if (muleBase == null) {
            muleBase = muleHome;
        }
        MuleContainerBootstrap.setSystemMuleVersion();
    }

    public static File lookupMuleHome() throws Exception {
        File muleHome = null;
        String muleHomeVar = System.getProperty("mule.home");
        if (muleHomeVar != null && !muleHomeVar.trim().equals("") && !muleHomeVar.equals("%MULE_HOME%")) {
            muleHome = new File(muleHomeVar).getCanonicalFile();
        }
        if (muleHome == null || !muleHome.exists() || !muleHome.isDirectory()) {
            throw new IllegalArgumentException("Either the system property mule.home is not set or does not contain a valid directory.");
        }
        return muleHome;
    }

    public static File lookupMuleBase() throws Exception {
        File muleBase = null;
        String muleBaseVar = System.getProperty("mule.base");
        if (muleBaseVar != null && !muleBaseVar.trim().equals("") && !muleBaseVar.equals("%MULE_BASE%")) {
            muleBase = new File(muleBaseVar).getCanonicalFile();
        }
        return muleBase;
    }

    private static void setSystemMuleVersion() {
        InputStream propertiesStream = null;
        try {
            URL mavenPropertiesUrl = MuleContainerBootstrapUtils.getResource(MULE_MODULE_REBOOT_POM_FILE_PATH, MuleContainerWrapper.class);
            propertiesStream = mavenPropertiesUrl.openStream();
            Properties mavenProperties = new Properties();
            mavenProperties.load(propertiesStream);
            System.setProperty("mule.version", mavenProperties.getProperty("version"));
            System.setProperty("mule.reference.version", mavenProperties.getProperty("version") + '-' + new Date().getTime());
        }
        catch (Exception exception) {
        }
        finally {
            if (propertiesStream != null) {
                try {
                    propertiesStream.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    private static CommandLine parseCommandLine(String[] args) throws ParseException {
        Options options = new Options();
        for (String[] element : CLI_OPTIONS) {
            options.addOption(element[0], "true".equalsIgnoreCase(element[1]), element[2]);
        }
        return new BasicParser().parse(options, args, true);
    }

    public static void dispose() {
    }
}

