/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.config.api.properties;

import java.lang.reflect.InvocationTargetException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Supplier;
import java.util.function.UnaryOperator;
import java.util.stream.Collectors;
import javax.xml.namespace.QName;
import org.mule.runtime.api.component.AbstractComponent;
import org.mule.runtime.api.component.Component;
import org.mule.runtime.api.component.ComponentIdentifier;
import org.mule.runtime.api.exception.MuleRuntimeException;
import org.mule.runtime.api.i18n.I18nMessageFactory;
import org.mule.runtime.api.util.LazyValue;
import org.mule.runtime.ast.api.ArtifactAst;
import org.mule.runtime.config.api.properties.ConfigurationPropertiesResolver;
import org.mule.runtime.config.internal.model.dsl.ClassLoaderResourceProvider;
import org.mule.runtime.config.internal.model.dsl.config.DefaultConfigurationProperty;
import org.mule.runtime.core.internal.execution.LocationExecutionContextProvider;
import org.mule.runtime.properties.api.ConfigurationPropertiesProvider;
import org.mule.runtime.properties.api.ConfigurationPropertiesProviderFactory;
import org.mule.runtime.properties.api.ConfigurationProperty;
import org.mule.runtime.properties.api.ResourceProvider;
import org.mule.runtime.properties.internal.loader.ConfigurationPropertiesProviderFactoryLoader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PropertiesResolverUtils {
    private static final String DUPLICATE_PROVIDERS_LAX = PropertiesResolverUtils.class.getName() + ".duplicateProvidersLax";
    public static final String GLOBAL_PROPERTY = "global-property";
    private static final Logger LOGGER = LoggerFactory.getLogger(PropertiesResolverUtils.class);
    private static final Class<?> PROVIDER_FACTORY_IFACE_OLD;

    private PropertiesResolverUtils() {
    }

    public static Supplier<Map<String, ConfigurationProperty>> createGlobalPropertiesSupplier(ArtifactAst artifactAst) {
        return new LazyValue(() -> {
            HashMap globalProperties = new HashMap();
            artifactAst.topLevelComponentsStream().filter(comp -> GLOBAL_PROPERTY.equals(comp.getIdentifier().getName())).forEach(comp -> {
                String key = comp.getParameter("General", "name").getResolvedRawValue();
                String rawValue = comp.getParameter("General", "value").getRawValue();
                globalProperties.put(key, new DefaultConfigurationProperty(String.format("global-property - file: %s - lineNumber %s", comp.getMetadata().getFileName().orElse("(n/a)"), comp.getMetadata().getStartLine().orElse(-1)), key, rawValue));
            });
            return globalProperties;
        });
    }

    public static List<ConfigurationPropertiesProvider> getConfigurationPropertiesProvidersFromComponents(ArtifactAst artifactAst, ClassLoader externalResourceClassLoader, ConfigurationPropertiesResolver localResolver) {
        return PropertiesResolverUtils.getConfigurationPropertiesProvidersFromComponents(artifactAst, new ClassLoaderResourceProvider(externalResourceClassLoader), localResolver);
    }

    public static List<ConfigurationPropertiesProvider> getConfigurationPropertiesProvidersFromComponents(ArtifactAst artifactAst, ClassLoader externalResourceClassLoader, ConfigurationPropertiesResolver localResolver, boolean ignoreCreateProviderExceptions) {
        return PropertiesResolverUtils.getConfigurationPropertiesProvidersFromComponents(artifactAst, new ClassLoaderResourceProvider(externalResourceClassLoader), localResolver, ignoreCreateProviderExceptions);
    }

    public static List<ConfigurationPropertiesProvider> getConfigurationPropertiesProvidersFromComponents(ArtifactAst artifactAst, ResourceProvider externalResourceProvider, ConfigurationPropertiesResolver localResolver) {
        return PropertiesResolverUtils.getConfigurationPropertiesProvidersFromComponents(artifactAst, externalResourceProvider, localResolver, false);
    }

    public static List<ConfigurationPropertiesProvider> getConfigurationPropertiesProvidersFromComponents(ArtifactAst artifactAst, ResourceProvider externalResourceProvider, ConfigurationPropertiesResolver localResolver, boolean ignoreCreateProviderExceptions) {
        Map<ComponentIdentifier, ConfigurationPropertiesProviderFactory> providerFactoriesMap = PropertiesResolverUtils.loadProviderFactories();
        return artifactAst.topLevelComponentsStream().filter(comp -> providerFactoriesMap.containsKey(comp.getIdentifier())).map(comp -> {
            try {
                ConfigurationPropertiesProvider provider = ((ConfigurationPropertiesProviderFactory)providerFactoriesMap.get(comp.getIdentifier())).createProvider(comp, (UnaryOperator)localResolver, externalResourceProvider);
                if (provider instanceof Component) {
                    HashMap<QName, Object> annotations = new HashMap<QName, Object>();
                    annotations.put(AbstractComponent.LOCATION_KEY, comp.getLocation());
                    annotations.put(AbstractComponent.ANNOTATION_NAME, comp.getIdentifier());
                    annotations.put(Component.Annotations.SOURCE_ELEMENT_ANNOTATION_KEY, comp.getMetadata().getSourceCode().map(LocationExecutionContextProvider::maskPasswords).orElse(null));
                    ((Component)provider).setAnnotations(annotations);
                }
                return Optional.of(provider);
            }
            catch (Exception e) {
                if (ignoreCreateProviderExceptions) {
                    if (LOGGER.isDebugEnabled()) {
                        LOGGER.warn("Exception creating property provider for component `" + comp.toString() + "`", (Throwable)e);
                    } else {
                        LOGGER.warn("Exception creating property provider for component `{}`: {}", comp, (Object)e);
                    }
                    return Optional.empty();
                }
                throw e;
            }
        }).filter(Optional::isPresent).map(Optional::get).collect(Collectors.toList());
    }

    public static Map<ComponentIdentifier, ConfigurationPropertiesProviderFactory> loadProviderFactories() {
        HashMap<ComponentIdentifier, ConfigurationPropertiesProviderFactory> providerFactoriesMap = new HashMap<ComponentIdentifier, ConfigurationPropertiesProviderFactory>();
        ConfigurationPropertiesProviderFactoryLoader.loadConfigurationPropertiesProviderFactories((ClassLoader)Thread.currentThread().getContextClassLoader()).filter(service -> PROVIDER_FACTORY_IFACE_OLD == null || !PROVIDER_FACTORY_IFACE_OLD.isAssignableFrom(service.getClass())).forEach(service -> {
            ComponentIdentifier componentIdentifier = service.getSupportedComponentIdentifier();
            if (providerFactoriesMap.containsKey(componentIdentifier)) {
                ConfigurationPropertiesProviderFactory previous = (ConfigurationPropertiesProviderFactory)providerFactoriesMap.get(componentIdentifier);
                if (!Boolean.getBoolean(DUPLICATE_PROVIDERS_LAX)) {
                    throw new MuleRuntimeException(I18nMessageFactory.createStaticMessage((String)("Multiple configuration providers for component `" + componentIdentifier + "`: `" + previous.toString() + "` loaded by `" + previous.getClass().getClassLoader() + "` and `" + service.toString() + "` loaded by `" + service.getClass().getClassLoader() + "`.")));
                }
            } else {
                providerFactoriesMap.put(componentIdentifier, (ConfigurationPropertiesProviderFactory)service);
            }
        });
        if (PROVIDER_FACTORY_IFACE_OLD != null) {
            try {
                PROVIDER_FACTORY_IFACE_OLD.getMethod("loadDeprecatedProviderFactories", Map.class).invoke(null, providerFactoriesMap);
            }
            catch (IllegalAccessException | IllegalArgumentException | NoSuchMethodException | SecurityException | InvocationTargetException e) {
                throw new MuleRuntimeException((Throwable)e);
            }
        }
        return providerFactoriesMap;
    }

    static {
        String oldInterfaceName = "org.mule.runtime.config.api.dsl.model.properties.ConfigurationPropertiesProviderFactory";
        Class<?> providerFactoryIfaceOld = null;
        try {
            providerFactoryIfaceOld = Class.forName("org.mule.runtime.config.api.dsl.model.properties.ConfigurationPropertiesProviderFactory");
        }
        catch (ClassNotFoundException e) {
            LOGGER.debug("Interface 'org.mule.runtime.config.api.dsl.model.properties.ConfigurationPropertiesProviderFactory' not available in classpath, skipping its processing.");
        }
        PROVIDER_FACTORY_IFACE_OLD = providerFactoryIfaceOld;
    }
}

