/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.config.internal.model.properties;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.ServiceLoader;
import java.util.function.Supplier;
import java.util.function.UnaryOperator;
import java.util.stream.Collectors;
import javax.xml.namespace.QName;
import org.mule.runtime.api.component.AbstractComponent;
import org.mule.runtime.api.component.Component;
import org.mule.runtime.api.component.ComponentIdentifier;
import org.mule.runtime.api.component.ConfigurationProperties;
import org.mule.runtime.api.config.Feature;
import org.mule.runtime.api.config.FeatureFlaggingService;
import org.mule.runtime.api.config.MuleRuntimeFeature;
import org.mule.runtime.api.exception.MuleRuntimeException;
import org.mule.runtime.api.i18n.I18nMessageFactory;
import org.mule.runtime.api.util.LazyValue;
import org.mule.runtime.ast.api.ArtifactAst;
import org.mule.runtime.config.internal.dsl.model.config.CompositeConfigurationPropertiesProvider;
import org.mule.runtime.config.internal.dsl.model.config.ConfigurationPropertiesResolver;
import org.mule.runtime.config.internal.dsl.model.config.DefaultConfigurationPropertiesResolver;
import org.mule.runtime.config.internal.dsl.model.config.DefaultConfigurationProperty;
import org.mule.runtime.config.internal.dsl.model.config.EnvironmentPropertiesConfigurationProvider;
import org.mule.runtime.config.internal.dsl.model.config.FileConfigurationPropertiesProvider;
import org.mule.runtime.config.internal.dsl.model.config.GlobalPropertyConfigurationPropertiesProvider;
import org.mule.runtime.config.internal.dsl.model.config.MapConfigurationPropertiesProvider;
import org.mule.runtime.config.internal.dsl.model.config.PropertiesResolverConfigurationProperties;
import org.mule.runtime.config.internal.dsl.model.config.SystemPropertiesConfigurationProvider;
import org.mule.runtime.core.privileged.execution.LocationExecutionContextProvider;
import org.mule.runtime.properties.api.ConfigurationPropertiesProvider;
import org.mule.runtime.properties.api.ConfigurationPropertiesProviderFactory;
import org.mule.runtime.properties.api.ConfigurationProperty;
import org.mule.runtime.properties.api.ResourceProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PropertiesResolverUtils {
    private static final Logger LOGGER = LoggerFactory.getLogger(PropertiesResolverUtils.class);
    public static final String GLOBAL_PROPERTY = "global-property";

    private PropertiesResolverUtils() {
    }

    public static PropertiesResolverConfigurationProperties createConfigurationAttributeResolver(ArtifactAst artifactAst, final Optional<ConfigurationProperties> parentConfigurationProperties, Map<String, String> deploymentProperties, ResourceProvider externalResourceProvider, Optional<FeatureFlaggingService> featureFlaggingService) {
        DefaultConfigurationPropertiesResolver systemPropertiesResolver;
        MapConfigurationPropertiesProvider deploymentPropertiesConfigurationProperties = null;
        if (!deploymentProperties.isEmpty()) {
            deploymentPropertiesConfigurationProperties = new MapConfigurationPropertiesProvider(deploymentProperties, "Deployment properties");
        }
        EnvironmentPropertiesConfigurationProvider environmentPropertiesConfigurationProvider = new EnvironmentPropertiesConfigurationProvider();
        DefaultConfigurationPropertiesResolver environmentPropertiesConfigurationPropertiesResolver = new DefaultConfigurationPropertiesResolver(Optional.empty(), environmentPropertiesConfigurationProvider);
        SystemPropertiesConfigurationProvider systemPropertiesConfigurationProvider = new SystemPropertiesConfigurationProvider();
        DefaultConfigurationPropertiesResolver systemPropertiesConfigurationPropertiesResolver = new DefaultConfigurationPropertiesResolver(Optional.of(environmentPropertiesConfigurationPropertiesResolver), systemPropertiesConfigurationProvider);
        DefaultConfigurationPropertiesResolver parentLocalResolver = deploymentPropertiesConfigurationProperties != null ? new DefaultConfigurationPropertiesResolver(Optional.of(systemPropertiesConfigurationPropertiesResolver), deploymentPropertiesConfigurationProperties) : systemPropertiesConfigurationPropertiesResolver;
        ConfigurationPropertiesProvider globalPropertiesConfigurationAttributeProvider = PropertiesResolverUtils.createProviderFromGlobalProperties(artifactAst);
        DefaultConfigurationPropertiesResolver localResolver = new DefaultConfigurationPropertiesResolver(Optional.of(new DefaultConfigurationPropertiesResolver(Optional.of(new DefaultConfigurationPropertiesResolver(Optional.of(parentLocalResolver), globalPropertiesConfigurationAttributeProvider)), environmentPropertiesConfigurationProvider)), systemPropertiesConfigurationProvider);
        if (featureFlaggingService.orElse(f -> true).isEnabled((Feature)MuleRuntimeFeature.HONOUR_RESERVED_PROPERTIES)) {
            localResolver.setRootResolver(parentLocalResolver);
        }
        artifactAst.updatePropertiesResolver((UnaryOperator)localResolver);
        List<ConfigurationPropertiesProvider> configConfigurationPropertiesProviders = PropertiesResolverUtils.getConfigurationPropertiesProvidersFromComponents(artifactAst, externalResourceProvider, localResolver);
        FileConfigurationPropertiesProvider externalPropertiesConfigurationProvider = new FileConfigurationPropertiesProvider(externalResourceProvider, "External files");
        Optional<ConfigurationPropertiesResolver> parentConfigurationPropertiesResolver = Optional.of(localResolver);
        if (parentConfigurationProperties.isPresent()) {
            parentConfigurationPropertiesResolver = Optional.of(new DefaultConfigurationPropertiesResolver(Optional.empty(), new ConfigurationPropertiesProvider(){

                public Optional<ConfigurationProperty> provide(String configurationAttributeKey) {
                    return ((ConfigurationProperties)parentConfigurationProperties.get()).resolveProperty(configurationAttributeKey).map(value -> new DefaultConfigurationProperty(parentConfigurationProperties, configurationAttributeKey, value));
                }

                public String getDescription() {
                    return "Domain properties";
                }
            }));
        }
        Optional<Object> configurationAttributesProvider = Optional.empty();
        if (!configConfigurationPropertiesProviders.isEmpty()) {
            configurationAttributesProvider = Optional.of(new CompositeConfigurationPropertiesProvider(configConfigurationPropertiesProviders));
            parentConfigurationPropertiesResolver = Optional.of(new DefaultConfigurationPropertiesResolver(deploymentPropertiesConfigurationProperties != null ? Optional.of(new DefaultConfigurationPropertiesResolver(parentConfigurationPropertiesResolver, deploymentPropertiesConfigurationProperties)) : parentConfigurationPropertiesResolver, (ConfigurationPropertiesProvider)configurationAttributesProvider.get()));
        } else if (deploymentPropertiesConfigurationProperties != null) {
            parentConfigurationPropertiesResolver = Optional.of(new DefaultConfigurationPropertiesResolver(parentConfigurationPropertiesResolver, deploymentPropertiesConfigurationProperties));
        }
        DefaultConfigurationPropertiesResolver globalPropertiesConfigurationPropertiesResolver = new DefaultConfigurationPropertiesResolver(parentConfigurationPropertiesResolver, globalPropertiesConfigurationAttributeProvider);
        if (configurationAttributesProvider.isPresent()) {
            DefaultConfigurationPropertiesResolver configurationPropertiesResolver = new DefaultConfigurationPropertiesResolver(Optional.of(globalPropertiesConfigurationPropertiesResolver), (ConfigurationPropertiesProvider)configurationAttributesProvider.get());
            systemPropertiesResolver = new DefaultConfigurationPropertiesResolver(Optional.of(new DefaultConfigurationPropertiesResolver(Optional.of(configurationPropertiesResolver), environmentPropertiesConfigurationProvider)), systemPropertiesConfigurationProvider);
        } else {
            systemPropertiesResolver = new DefaultConfigurationPropertiesResolver(Optional.of(new DefaultConfigurationPropertiesResolver(Optional.of(globalPropertiesConfigurationPropertiesResolver), environmentPropertiesConfigurationProvider)), systemPropertiesConfigurationProvider);
        }
        DefaultConfigurationPropertiesResolver externalPropertiesResolver = new DefaultConfigurationPropertiesResolver(deploymentPropertiesConfigurationProperties != null ? Optional.of(new DefaultConfigurationPropertiesResolver(Optional.of(systemPropertiesResolver), deploymentPropertiesConfigurationProperties)) : Optional.of(systemPropertiesResolver), externalPropertiesConfigurationProvider);
        if (deploymentPropertiesConfigurationProperties == null) {
            externalPropertiesResolver.setAsRootResolver();
            return new PropertiesResolverConfigurationProperties(externalPropertiesResolver);
        }
        DefaultConfigurationPropertiesResolver deploymentPropertiesResolver = new DefaultConfigurationPropertiesResolver(Optional.of(externalPropertiesResolver), deploymentPropertiesConfigurationProperties);
        deploymentPropertiesResolver.setAsRootResolver();
        return new PropertiesResolverConfigurationProperties(deploymentPropertiesResolver);
    }

    public static PropertiesResolverConfigurationProperties createConfigurationAttributeResolver(final Optional<ConfigurationProperties> parentConfigurationProperties, Map<String, String> deploymentProperties, ResourceProvider externalResourceProvider) {
        MapConfigurationPropertiesProvider deploymentPropertiesConfigurationProperties = null;
        if (!deploymentProperties.isEmpty()) {
            deploymentPropertiesConfigurationProperties = new MapConfigurationPropertiesProvider(deploymentProperties, "Deployment properties");
        }
        EnvironmentPropertiesConfigurationProvider environmentPropertiesConfigurationProvider = new EnvironmentPropertiesConfigurationProvider();
        DefaultConfigurationPropertiesResolver environmentPropertiesConfigurationPropertiesResolver = new DefaultConfigurationPropertiesResolver(Optional.empty(), environmentPropertiesConfigurationProvider);
        SystemPropertiesConfigurationProvider systemPropertiesConfigurationProvider = new SystemPropertiesConfigurationProvider();
        DefaultConfigurationPropertiesResolver systemPropertiesConfigurationPropertiesResolver = new DefaultConfigurationPropertiesResolver(Optional.of(environmentPropertiesConfigurationPropertiesResolver), systemPropertiesConfigurationProvider);
        DefaultConfigurationPropertiesResolver parentLocalResolver = deploymentPropertiesConfigurationProperties != null ? new DefaultConfigurationPropertiesResolver(Optional.of(systemPropertiesConfigurationPropertiesResolver), deploymentPropertiesConfigurationProperties) : systemPropertiesConfigurationPropertiesResolver;
        DefaultConfigurationPropertiesResolver localResolver = new DefaultConfigurationPropertiesResolver(Optional.of(new DefaultConfigurationPropertiesResolver(Optional.of(parentLocalResolver), environmentPropertiesConfigurationProvider)), systemPropertiesConfigurationProvider);
        localResolver.setRootResolver(parentLocalResolver);
        FileConfigurationPropertiesProvider externalPropertiesConfigurationProvider = new FileConfigurationPropertiesProvider(externalResourceProvider, "External files");
        Optional<ConfigurationPropertiesResolver> parentConfigurationPropertiesResolver = Optional.of(localResolver);
        if (parentConfigurationProperties.isPresent()) {
            parentConfigurationPropertiesResolver = Optional.of(new DefaultConfigurationPropertiesResolver(Optional.empty(), new ConfigurationPropertiesProvider(){

                public Optional<ConfigurationProperty> provide(String configurationAttributeKey) {
                    return ((ConfigurationProperties)parentConfigurationProperties.get()).resolveProperty(configurationAttributeKey).map(value -> new DefaultConfigurationProperty(parentConfigurationProperties, configurationAttributeKey, value));
                }

                public String getDescription() {
                    return "Domain properties";
                }
            }));
        }
        DefaultConfigurationPropertiesResolver systemPropertiesResolver = new DefaultConfigurationPropertiesResolver(Optional.of(new DefaultConfigurationPropertiesResolver(parentConfigurationPropertiesResolver, environmentPropertiesConfigurationProvider)), systemPropertiesConfigurationProvider);
        DefaultConfigurationPropertiesResolver externalPropertiesResolver = new DefaultConfigurationPropertiesResolver(deploymentPropertiesConfigurationProperties != null ? Optional.of(new DefaultConfigurationPropertiesResolver(Optional.of(systemPropertiesResolver), deploymentPropertiesConfigurationProperties)) : Optional.of(systemPropertiesResolver), externalPropertiesConfigurationProvider);
        if (deploymentPropertiesConfigurationProperties == null) {
            externalPropertiesResolver.setAsRootResolver();
            return new PropertiesResolverConfigurationProperties(externalPropertiesResolver);
        }
        DefaultConfigurationPropertiesResolver deploymentPropertiesResolver = new DefaultConfigurationPropertiesResolver(Optional.of(externalPropertiesResolver), deploymentPropertiesConfigurationProperties);
        deploymentPropertiesResolver.setAsRootResolver();
        return new PropertiesResolverConfigurationProperties(deploymentPropertiesResolver);
    }

    public static ConfigurationPropertiesProvider createProviderFromGlobalProperties(ArtifactAst artifactAst) {
        return new GlobalPropertyConfigurationPropertiesProvider((Supplier<Map<String, ConfigurationProperty>>)new LazyValue(() -> {
            HashMap globalProperties = new HashMap();
            artifactAst.topLevelComponentsStream().filter(comp -> GLOBAL_PROPERTY.equals(comp.getIdentifier().getName())).forEach(comp -> {
                String key = comp.getParameter("General", "name").getResolvedRawValue();
                String rawValue = comp.getParameter("General", "value").getRawValue();
                globalProperties.put(key, new DefaultConfigurationProperty(String.format("global-property - file: %s - lineNumber %s", comp.getMetadata().getFileName().orElse("(n/a)"), comp.getMetadata().getStartLine().orElse(-1)), key, rawValue));
            });
            return globalProperties;
        }));
    }

    private static List<ConfigurationPropertiesProvider> getConfigurationPropertiesProvidersFromComponents(ArtifactAst artifactAst, ResourceProvider externalResourceProvider, ConfigurationPropertiesResolver localResolver) {
        Map<ComponentIdentifier, ConfigurationPropertiesProviderFactory> providerFactoriesMap = PropertiesResolverUtils.loadProviderFactories();
        return artifactAst.topLevelComponentsStream().filter(comp -> providerFactoriesMap.containsKey(comp.getIdentifier())).map(comp -> {
            ConfigurationPropertiesProvider provider = ((ConfigurationPropertiesProviderFactory)providerFactoriesMap.get(comp.getIdentifier())).createProvider(comp, (UnaryOperator)localResolver, externalResourceProvider);
            if (provider instanceof Component) {
                HashMap<QName, Object> annotations = new HashMap<QName, Object>();
                annotations.put(AbstractComponent.LOCATION_KEY, comp.getLocation());
                annotations.put(AbstractComponent.ANNOTATION_NAME, comp.getIdentifier());
                annotations.put(Component.Annotations.SOURCE_ELEMENT_ANNOTATION_KEY, comp.getMetadata().getSourceCode().map(LocationExecutionContextProvider::maskPasswords).orElse(null));
                ((Component)provider).setAnnotations(annotations);
            }
            return provider;
        }).collect(Collectors.toList());
    }

    public static Map<ComponentIdentifier, ConfigurationPropertiesProviderFactory> loadProviderFactories() {
        HashMap<ComponentIdentifier, ConfigurationPropertiesProviderFactory> providerFactoriesMap = new HashMap<ComponentIdentifier, ConfigurationPropertiesProviderFactory>();
        ServiceLoader<ConfigurationPropertiesProviderFactory> providerFactories = ServiceLoader.load(ConfigurationPropertiesProviderFactory.class);
        providerFactories.forEach(service -> {
            ComponentIdentifier componentIdentifier = service.getSupportedComponentIdentifier();
            if (providerFactoriesMap.containsKey(componentIdentifier)) {
                throw new MuleRuntimeException(I18nMessageFactory.createStaticMessage((String)("Multiple configuration providers for component: " + componentIdentifier)));
            }
            providerFactoriesMap.put(componentIdentifier, (ConfigurationPropertiesProviderFactory)service);
        });
        try {
            Class<?> providerFactoryIfaceOld = Class.forName("org.mule.runtime.config.api.dsl.model.properties.ConfigurationPropertiesProviderFactory");
            ServiceLoader<?> providerFactoriesOld = ServiceLoader.load(providerFactoryIfaceOld);
            providerFactoriesOld.forEach(service -> {
                ComponentIdentifier componentIdentifier = service.getSupportedComponentIdentifier();
                if (providerFactoriesMap.containsKey(componentIdentifier)) {
                    throw new MuleRuntimeException(I18nMessageFactory.createStaticMessage((String)("Multiple configuration providers for component: " + componentIdentifier)));
                }
                providerFactoriesMap.put(componentIdentifier, (ConfigurationPropertiesProviderFactory)service);
            });
        }
        catch (ClassNotFoundException e) {
            LOGGER.debug("Interface 'org.mule.runtime.config.api.dsl.model.properties.ConfigurationPropertiesProviderFactory' not available in classpath, skipping its processing.");
        }
        return providerFactoriesMap;
    }
}

