/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.config.internal.model.dsl.config;

import java.util.Map;
import java.util.Optional;
import org.mule.runtime.config.internal.model.dsl.config.EnvironmentPropertiesConfigurationProvider;
import org.mule.runtime.config.internal.model.dsl.config.SystemPropertiesConfigurationProvider;
import org.mule.runtime.properties.api.ConfigurationPropertiesProvider;
import org.mule.runtime.properties.api.ConfigurationProperty;
import org.mule.runtime.properties.internal.DefaultConfigurationProperty;

public final class StaticConfigurationPropertiesProvider
implements ConfigurationPropertiesProvider {
    private final ConfigurationPropertiesProvider sysPropsProvider = new SystemPropertiesConfigurationProvider();
    private final ConfigurationPropertiesProvider environmentProvider = new EnvironmentPropertiesConfigurationProvider();
    private final Map<String, String> artifactProperties;

    public StaticConfigurationPropertiesProvider(Map<String, String> artifactProperties) {
        this.artifactProperties = artifactProperties;
    }

    public Optional<? extends ConfigurationProperty> provide(String configurationAttributeKey) {
        String propertyValue = this.artifactProperties.get(configurationAttributeKey);
        if (propertyValue != null) {
            return Optional.of(new DefaultConfigurationProperty((Object)this, configurationAttributeKey, propertyValue));
        }
        Optional sysPropValue = this.sysPropsProvider.provide(configurationAttributeKey);
        if (sysPropValue.isPresent()) {
            return sysPropValue;
        }
        return this.environmentProvider.provide(configurationAttributeKey);
    }

    public String getDescription() {
        return "Deployment properties";
    }
}

