/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.observability.configuration;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.util.Base64;
import java.util.Map;
import org.mule.runtime.api.exception.MuleRuntimeException;
import org.mule.runtime.api.i18n.I18nMessageFactory;
import org.mule.runtime.module.observability.configuration.ObservabilitySignalConfiguration;
import org.mule.runtime.module.observability.configuration.anypoint.AnypointMetadataConfigurationResolver;

public class ObservabilitySignalExporterConfigurator {
    public static final String CERTIFICATES_FILE_PATHS_TLS_STRATEGY = "CERTIFICATES_PATH";
    public static final String CERTIFICATES_BASE64_TLS_STRATEGY = "CERTIFICATES_BASE64";
    public static final Base64.Decoder BASE64_DECODER = Base64.getDecoder();
    private final ObservabilitySignalConfiguration configuration;

    private ObservabilitySignalExporterConfigurator(ObservabilitySignalConfiguration configuration) {
        this.configuration = configuration;
    }

    public static ObservabilitySignalExporterConfigurator forConfiguration(ObservabilitySignalConfiguration configuration) {
        return new ObservabilitySignalExporterConfigurator(configuration);
    }

    public ObservabilitySignalExporterConfigurator configureTlsCertificates(TlsConfigurationMapper tlsConfigurationMapper, TlsCertificatesConfigurer tlsCertificatesConfigurer) throws IOException {
        String configurationStrategy = this.configuration.getStringValue(tlsConfigurationMapper.getTlsStrategyConfigPropertyName());
        if (CERTIFICATES_FILE_PATHS_TLS_STRATEGY.equals(configurationStrategy)) {
            return this.configureTlsCertsByFiles(tlsConfigurationMapper, tlsCertificatesConfigurer);
        }
        if (CERTIFICATES_BASE64_TLS_STRATEGY.equals(configurationStrategy)) {
            return this.configureTlsCertsByBase64(tlsConfigurationMapper, tlsCertificatesConfigurer);
        }
        throw new MuleRuntimeException(I18nMessageFactory.createStaticMessage((String)String.format("Unrecognized TLS configuration strategy: %s", configurationStrategy)));
    }

    public ObservabilitySignalExporterConfigurator configureAnypointMetadata(AnypointMetadataConfigurationMapper anypointMetadataConfigurationMapper, AnypointMetadataConfigurer anypointMetadataConfigurer) {
        if (this.configuration.getBooleanValue(anypointMetadataConfigurationMapper.getIsIncludeAnypointMetadataConfigPropertyName())) {
            anypointMetadataConfigurer.apply(new AnypointMetadataConfigurationResolver().resolveAnypointMetadata());
        }
        return this;
    }

    private ObservabilitySignalExporterConfigurator configureTlsCertsByBase64(TlsConfigurationMapper tlsConfigurationMapper, TlsCertificatesConfigurer tlsCertificatesConfigurer) {
        String tlsCertBase64 = this.configuration.getStringValue(tlsConfigurationMapper.getCertBase64ConfigPropertyName());
        String tlsCertKeyBase64 = this.configuration.getStringValue(tlsConfigurationMapper.getCertKeyBase64ConfigPropertyName());
        String tlsCaBase64 = this.configuration.getStringValue(tlsConfigurationMapper.getCaBase64ConfigPropertyName());
        byte[] tlsCertBytes = null;
        byte[] tlsCertKeyBytes = null;
        byte[] tlsCaBytes = null;
        if (tlsCaBase64 != null) {
            tlsCaBytes = BASE64_DECODER.decode(tlsCaBase64);
        }
        if (tlsCertBase64 != null && tlsCertKeyBase64 != null) {
            tlsCertBytes = BASE64_DECODER.decode(tlsCertBase64);
            tlsCertKeyBytes = BASE64_DECODER.decode(tlsCertKeyBase64);
        }
        tlsCertificatesConfigurer.apply(tlsCaBytes, tlsCertBytes, tlsCertKeyBytes);
        return this;
    }

    private ObservabilitySignalExporterConfigurator configureTlsCertsByFiles(TlsConfigurationMapper tlsConfigurationMapper, TlsCertificatesConfigurer tlsCertificatesConfigurer) throws IOException {
        String tlsCertPath = this.configuration.getStringValue(tlsConfigurationMapper.getCertFileConfigPropertyName());
        String tlsCertKeyPath = this.configuration.getStringValue(tlsConfigurationMapper.getCertKeyFilePathConfigPropertyName());
        String tlsCaPath = this.configuration.getStringValue(tlsConfigurationMapper.getCaFilePathConfigPropertyName());
        byte[] tlsCertBytes = null;
        byte[] tlsCertKeyBytes = null;
        byte[] tlsCaBytes = null;
        if (tlsCaPath != null) {
            tlsCaBytes = Files.readAllBytes(Paths.get(tlsCaPath, new String[0]));
        }
        if (tlsCertPath != null && tlsCertKeyPath != null) {
            tlsCertBytes = Files.readAllBytes(Paths.get(tlsCertPath, new String[0]));
            tlsCertKeyBytes = Files.readAllBytes(Paths.get(tlsCertKeyPath, new String[0]));
        }
        tlsCertificatesConfigurer.apply(tlsCaBytes, tlsCertBytes, tlsCertKeyBytes);
        return this;
    }

    public static interface TlsConfigurationMapper {
        public String getTlsStrategyConfigPropertyName();

        public String getCaFilePathConfigPropertyName();

        public String getCertFileConfigPropertyName();

        public String getCertKeyFilePathConfigPropertyName();

        public String getCaBase64ConfigPropertyName();

        public String getCertBase64ConfigPropertyName();

        public String getCertKeyBase64ConfigPropertyName();
    }

    @FunctionalInterface
    public static interface TlsCertificatesConfigurer {
        public void apply(byte[] var1, byte[] var2, byte[] var3);
    }

    public static interface AnypointMetadataConfigurationMapper {
        public String getIsIncludeAnypointMetadataConfigPropertyName();
    }

    @FunctionalInterface
    public static interface AnypointMetadataConfigurer {
        public void apply(Map<String, String> var1);
    }
}

