/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.observability.configuration;

import java.nio.file.Path;
import java.time.Duration;
import java.util.Base64;
import java.util.List;
import java.util.Optional;
import org.mule.runtime.module.artifact.api.classloader.MuleDeployableArtifactClassLoader;
import org.mule.runtime.module.artifact.api.descriptor.ArtifactDescriptor;
import org.mule.runtime.module.artifact.api.descriptor.DeployableArtifactDescriptor;

public interface ObservabilitySignalConfiguration {
    public String getStringValue(String var1);

    default public String getStringValue(String key, String defaultValue) {
        String value = this.getStringValue(key);
        if (value != null) {
            return value;
        }
        return defaultValue;
    }

    default public List<String> getStringListValue(String key) {
        throw new UnsupportedOperationException("List values are not supported by this implementation");
    }

    default public List<String> getStringListValue(String key, List<String> defaultValue) {
        List<String> value = this.getStringListValue(key);
        if (value != null) {
            return value;
        }
        return defaultValue;
    }

    default public Path getPathValue(String key) {
        return this.getPathValue(key, null);
    }

    default public Path getPathValue(String key, Path defaultValue) {
        String value = this.getStringValue(key);
        if (value != null) {
            return Path.of(value, new String[0]);
        }
        return defaultValue;
    }

    default public boolean getBooleanValue(String key) {
        return this.getBooleanValue(key, false);
    }

    default public boolean getBooleanValue(String key, boolean defaultValue) {
        String value = this.getStringValue(key);
        if (value != null) {
            return Boolean.parseBoolean(value);
        }
        return defaultValue;
    }

    default public Integer getIntValue(String key) {
        return this.getIntValue(key, null);
    }

    default public Integer getIntValue(String key, Integer defaultValue) {
        String value = this.getStringValue(key);
        if (value != null) {
            return Integer.parseInt(value);
        }
        return defaultValue;
    }

    default public Long getLongValue(String key) {
        return this.getLongValue(key, null);
    }

    default public Long getLongValue(String key, Long defaultValue) {
        String value = this.getStringValue(key);
        if (value != null) {
            return Long.parseLong(value);
        }
        return defaultValue;
    }

    default public Double getDoubleValue(String key) {
        return this.getDoubleValue(key, null);
    }

    default public Double getDoubleValue(String key, Double defaultValue) {
        String value = this.getStringValue(key);
        if (value != null) {
            return Double.parseDouble(value);
        }
        return defaultValue;
    }

    default public Duration getSecondsDurationValue(String key) {
        return this.getSecondsDurationValue(key, null);
    }

    default public Duration getSecondsDurationValue(String key, Duration defaultValue) {
        Long value = this.getLongValue(key);
        if (value != null) {
            return Duration.ofSeconds(value);
        }
        return defaultValue;
    }

    default public byte[] getBytesFromBase64Value(String key) {
        return this.getBytesFromBase64Value(key, null);
    }

    default public byte[] getBytesFromBase64Value(String key, byte[] defaultValue) {
        String base64String = this.getStringValue(key);
        if (base64String != null) {
            return Base64.getDecoder().decode(base64String);
        }
        return defaultValue;
    }

    default public void doOnConfigurationChanged(Runnable doOnConfigurationChanged) {
    }

    default public Optional<DeployableArtifactDescriptor> getDeployableArtifactDescriptor(ClassLoader classLoader) {
        MuleDeployableArtifactClassLoader artifactClassLoader;
        ArtifactDescriptor artifactDescriptor;
        if (classLoader instanceof MuleDeployableArtifactClassLoader && (artifactDescriptor = (artifactClassLoader = (MuleDeployableArtifactClassLoader)classLoader).getArtifactDescriptor()) instanceof DeployableArtifactDescriptor) {
            DeployableArtifactDescriptor artifactDescriptor2 = (DeployableArtifactDescriptor)artifactDescriptor;
            return Optional.of(artifactDescriptor2);
        }
        return Optional.empty();
    }
}

