/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.observability.configuration;

import java.util.HashMap;
import java.util.Map;

public final class KeyValueParser {
    private KeyValueParser() {
    }

    public static Map<String, String> parse(String keyValueString, KeyValueType type) {
        String[] entries;
        if (keyValueString == null) {
            throw new IllegalArgumentException(String.format("%s configuration string cannot be null", type.getCapitalizedName()));
        }
        if (keyValueString.trim().isEmpty()) {
            throw new IllegalArgumentException(String.format("%s configuration has an empty value", type.getCapitalizedName()));
        }
        HashMap<String, String> result = new HashMap<String, String>();
        for (String entry : entries = keyValueString.split(",")) {
            String trimmedEntry = entry.trim();
            if (trimmedEntry.isEmpty()) {
                throw new IllegalArgumentException(String.format("%s configuration contains empty entries", type.getCapitalizedName()));
            }
            int separatorIndex = trimmedEntry.indexOf("=");
            if (separatorIndex == -1) {
                result.put(trimmedEntry, "");
                continue;
            }
            String key = trimmedEntry.substring(0, separatorIndex).trim();
            if (key.isEmpty()) {
                throw new IllegalArgumentException(String.format("%s configuration contains empty %s names", type.getCapitalizedName(), type.getName()));
            }
            String value = trimmedEntry.substring(separatorIndex + 1).trim();
            if (value.isEmpty()) {
                throw new IllegalArgumentException(String.format("%s configuration contains empty %s values", type.getCapitalizedName(), type.getName()));
            }
            result.put(key, value);
        }
        return result;
    }

    public static enum KeyValueType {
        HEADERS("headers"),
        ATTRIBUTES("attributes");

        private final String name;

        private KeyValueType(String name) {
            this.name = name;
        }

        public String getName() {
            return this.name;
        }

        public String getCapitalizedName() {
            return this.name.substring(0, 1).toUpperCase() + this.name.substring(1);
        }
    }
}

