/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.metadata.api.cache;

import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;

public class MetadataCacheId {
    private final String value;
    private final String sourceElementName;
    private final List<MetadataCacheId> parts;

    public MetadataCacheId(List<MetadataCacheId> parts, String sourceElementName) {
        this.parts = parts;
        this.sourceElementName = sourceElementName;
        this.value = parts.stream().map(MetadataCacheId::getValue).reduce((a, b) -> a + b).orElseThrow(() -> new IllegalArgumentException(String.format("At least one part is required for a Metadata Cache ID, but none was found for element '%s'", sourceElementName)));
    }

    public MetadataCacheId(String value, String sourceElementName) {
        this.value = value;
        this.sourceElementName = sourceElementName;
        this.parts = Collections.emptyList();
    }

    public MetadataCacheId(int value, String sourceElementName) {
        this(String.valueOf(value), sourceElementName);
    }

    public String getValue() {
        return this.value;
    }

    public List<MetadataCacheId> getParts() {
        return this.parts;
    }

    public Optional<String> getSourceElementName() {
        return Optional.ofNullable(this.sourceElementName);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MetadataCacheId that = (MetadataCacheId)o;
        return Objects.equals(this.value, that.value);
    }

    public int hashCode() {
        return Objects.hash(this.value);
    }

    public String toString() {
        return '(' + this.value + ',' + this.sourceElementName + ')';
    }
}

