/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.internal.memory.management;

import java.nio.ByteBuffer;
import java.util.HashMap;
import java.util.Map;
import org.mule.runtime.api.lifecycle.InitialisationException;
import org.mule.runtime.api.memory.provider.ByteBufferPoolConfiguration;
import org.mule.runtime.api.memory.provider.ByteBufferProvider;
import org.mule.runtime.api.memory.provider.type.ByteBufferType;
import org.mule.runtime.api.profiling.ProfilingService;
import org.mule.runtime.internal.memory.bytebuffer.ByteBufferProviderBuilder;
import org.mule.runtime.internal.memory.management.ProfiledMemoryManagementService;
import org.mule.runtime.internal.memory.profiling.NoOpMemoryProfilingService;

public class DefaultMemoryManagementService
implements ProfiledMemoryManagementService {
    public static final String DUPLICATE_BYTE_BUFFER_PROVIDER_NAME = "A ByteBuffer Provider is already registered with name '%s'.";
    private static final DefaultMemoryManagementService INSTANCE = new DefaultMemoryManagementService();
    private final Map<String, ByteBufferProvider<ByteBuffer>> byteBufferProviders = new HashMap<String, ByteBufferProvider<ByteBuffer>>();
    private ProfilingService profilingService = new NoOpMemoryProfilingService();

    public static DefaultMemoryManagementService getInstance() {
        return INSTANCE;
    }

    private DefaultMemoryManagementService() {
    }

    public void dispose() {
        this.byteBufferProviders.values().forEach(ByteBufferProvider::dispose);
        this.byteBufferProviders.clear();
    }

    public void initialise() throws InitialisationException {
    }

    public synchronized ByteBufferProvider<ByteBuffer> getByteBufferProvider(String name, ByteBufferType byteBufferType, ByteBufferPoolConfiguration poolConfiguration) {
        if (this.byteBufferProviders.containsKey(name)) {
            throw new IllegalArgumentException(String.format(DUPLICATE_BYTE_BUFFER_PROVIDER_NAME, name));
        }
        return this.byteBufferProviders.computeIfAbsent(name, n -> ByteBufferProviderBuilder.buildByteBufferProviderFrom(byteBufferType).withPoolConfiguration(poolConfiguration).withProfilingService(this.profilingService).build());
    }

    public synchronized ByteBufferProvider<ByteBuffer> getByteBufferProvider(String name, ByteBufferType byteBufferType) {
        if (this.byteBufferProviders.containsKey(name)) {
            throw new IllegalArgumentException(String.format(DUPLICATE_BYTE_BUFFER_PROVIDER_NAME, name));
        }
        return this.byteBufferProviders.computeIfAbsent(name, n -> ByteBufferProviderBuilder.buildByteBufferProviderFrom(byteBufferType).withName(name).withProfilingService(this.profilingService).build());
    }

    public synchronized void disposeByteBufferProvider(String name) {
        this.byteBufferProviders.remove(name).dispose();
    }

    @Override
    public void setProfilingService(ProfilingService profilingService) {
        this.profilingService = profilingService;
    }
}

