/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.internal.memory.bytebuffer;

import java.nio.ByteBuffer;
import org.mule.runtime.api.memory.provider.ByteBufferPoolConfiguration;
import org.mule.runtime.api.memory.provider.ByteBufferProvider;
import org.mule.runtime.api.memory.provider.type.ByteBufferType;
import org.mule.runtime.internal.memory.bytebuffer.DirectByteBufferProvider;
import org.mule.runtime.internal.memory.bytebuffer.HeapByteBufferProvider;

public final class ByteBufferProviderBuilder {
    private final boolean isDirect;
    private ByteBufferPoolConfiguration poolConfiguration;

    private ByteBufferProviderBuilder(boolean isDirect) {
        this.isDirect = isDirect;
    }

    public static ByteBufferProviderBuilder buildByteBufferProviderFrom(ByteBufferType byteBufferType) {
        return new ByteBufferProviderBuilder(ByteBufferType.DIRECT.equals((Object)byteBufferType));
    }

    public ByteBufferProvider<ByteBuffer> build() {
        if (this.isDirect) {
            if (this.poolConfiguration != null) {
                return new DirectByteBufferProvider(this.poolConfiguration.getMaxBufferSize(), this.poolConfiguration.getBaseByteBufferSize(), this.poolConfiguration.getGrowthFactor(), this.poolConfiguration.getNumberOfPools());
            }
            return new DirectByteBufferProvider();
        }
        if (this.poolConfiguration != null) {
            return new HeapByteBufferProvider(this.poolConfiguration.getMaxBufferSize(), this.poolConfiguration.getBaseByteBufferSize(), this.poolConfiguration.getGrowthFactor(), this.poolConfiguration.getNumberOfPools());
        }
        return new HeapByteBufferProvider();
    }

    public ByteBufferProviderBuilder withPoolConfiguration(ByteBufferPoolConfiguration poolConfiguration) {
        this.poolConfiguration = poolConfiguration;
        return this;
    }
}

