/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.logging.otel.impl.configuration;

import io.opentelemetry.api.metrics.MeterProvider;
import io.opentelemetry.exporter.otlp.http.logs.OtlpHttpLogRecordExporter;
import io.opentelemetry.exporter.otlp.http.logs.OtlpHttpLogRecordExporterBuilder;
import io.opentelemetry.sdk.common.InternalTelemetryVersion;
import io.opentelemetry.sdk.logs.export.LogRecordExporter;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang3.StringUtils;
import org.mule.runtime.logging.otel.impl.configuration.LogRecordExporterConfiguratorException;
import org.mule.runtime.logging.otel.impl.configuration.LoggingExporterConfigurationUtils;
import org.mule.runtime.logging.otel.impl.configuration.LoggingExporterConfigurator;
import org.mule.runtime.module.observability.configuration.KeyValueParser;
import org.mule.runtime.module.observability.configuration.ObservabilitySignalConfiguration;
import org.mule.runtime.module.observability.configuration.ObservabilitySignalExporterConfigurator;

public class HttpLoggingExporterConfigurator
implements LoggingExporterConfigurator {
    private static final ObservabilitySignalExporterConfigurator.TlsConfigurationMapper tlsConfigurationMapper = HttpLoggingExporterConfigurator.getTlsConfigurationMapper();

    @Override
    public LogRecordExporter configureExporter(ObservabilitySignalConfiguration configuration, MeterProvider exportMetricsMeterProvider) throws LogRecordExporterConfiguratorException {
        try {
            String timeout;
            String headers;
            String compressionType;
            OtlpHttpLogRecordExporterBuilder httpLogRecordExporterBuilder = OtlpHttpLogRecordExporter.builder();
            ObservabilitySignalExporterConfigurator exporterConfigurator = ObservabilitySignalExporterConfigurator.forConfiguration((ObservabilitySignalConfiguration)configuration);
            String endpoint = configuration.getStringValue("mule.openTelemetry.logging.exporter.endpoint");
            if (!StringUtils.isEmpty((CharSequence)endpoint)) {
                httpLogRecordExporterBuilder.setEndpoint(endpoint);
            }
            if ((compressionType = configuration.getStringValue("mule.openTelemetry.logging.exporter.compression")) != null) {
                httpLogRecordExporterBuilder.setCompression(compressionType);
            }
            if (configuration.getBooleanValue("mule.openTelemetry.logging.exporter.tls.enabled")) {
                exporterConfigurator.configureTlsCertificates(tlsConfigurationMapper, (tlsCaBytes, tlsCertBytes, tlsCertKeyBytes) -> this.configureTls(tlsCaBytes, tlsCertBytes, tlsCertKeyBytes, httpLogRecordExporterBuilder));
            }
            if ((headers = configuration.getStringValue("mule.openTelemetry.logging.exporter.headers")) != null) {
                this.configureHeaders(httpLogRecordExporterBuilder, headers);
            }
            if ((timeout = configuration.getStringValue("mule.openTelemetry.logging.exporter.timeout")) != null) {
                this.configureTimeout(httpLogRecordExporterBuilder, timeout);
            }
            LoggingExporterConfigurationUtils.enableBackoffStrategy(httpLogRecordExporterBuilder, configuration);
            if (LoggingExporterConfigurationUtils.isHealthMetricsEnabled()) {
                httpLogRecordExporterBuilder.setInternalTelemetryVersion(InternalTelemetryVersion.LATEST);
            }
            httpLogRecordExporterBuilder.setMeterProvider(exportMetricsMeterProvider);
            return httpLogRecordExporterBuilder.build();
        }
        catch (Exception e) {
            throw new LogRecordExporterConfiguratorException(e);
        }
    }

    private void configureTimeout(OtlpHttpLogRecordExporterBuilder builder, String timeout) {
        builder.setTimeout(Long.parseLong(timeout), TimeUnit.MILLISECONDS);
    }

    private void configureHeaders(OtlpHttpLogRecordExporterBuilder builder, String headers) {
        KeyValueParser.parse((String)headers, (KeyValueParser.KeyValueType)KeyValueParser.KeyValueType.HEADERS).forEach((arg_0, arg_1) -> ((OtlpHttpLogRecordExporterBuilder)builder).addHeader(arg_0, arg_1));
    }

    static ObservabilitySignalExporterConfigurator.TlsConfigurationMapper getTlsConfigurationMapper() {
        return new ObservabilitySignalExporterConfigurator.TlsConfigurationMapper(){

            public String getTlsStrategyConfigPropertyName() {
                return "mule.openTelemetry.logging.exporter.tls.certificatesStrategy";
            }

            public String getCaFilePathConfigPropertyName() {
                return "mule.openTelemetry.logging.exporter.tls.caFileLocation";
            }

            public String getCertFileConfigPropertyName() {
                return "mule.openTelemetry.logging.exporter.tls.certFileLocation";
            }

            public String getCertKeyFilePathConfigPropertyName() {
                return "mule.openTelemetry.logging.exporter.tls.keyFileLocation";
            }

            public String getCaBase64ConfigPropertyName() {
                return "mule.openTelemetry.logging.exporter.tls.caBase64";
            }

            public String getCertBase64ConfigPropertyName() {
                return "mule.openTelemetry.logging.exporter.tls.certBase64";
            }

            public String getCertKeyBase64ConfigPropertyName() {
                return "mule.openTelemetry.logging.exporter.tls.keyBase64";
            }
        };
    }

    private void configureTls(byte[] tlsCaBytes, byte[] tlsCertBytes, byte[] tlsCertKeyBytes, OtlpHttpLogRecordExporterBuilder otlpHttpLogRecordExporterBuilder) {
        if (tlsCertBytes != null && tlsCertKeyBytes != null) {
            otlpHttpLogRecordExporterBuilder.setClientTls(tlsCertKeyBytes, tlsCertBytes);
        }
        if (tlsCaBytes != null) {
            otlpHttpLogRecordExporterBuilder.setTrustedCertificates(tlsCaBytes);
        }
    }
}

