/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.logging.otel.impl.export.log4j;

import io.opentelemetry.instrumentation.log4j.appender.v2_17.OpenTelemetryAppender;
import java.io.File;
import java.net.URISyntaxException;
import java.net.URL;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.core.Appender;
import org.apache.logging.log4j.core.LoggerContext;
import org.mule.runtime.api.exception.MuleRuntimeException;
import org.mule.runtime.api.i18n.I18nMessageFactory;
import org.mule.runtime.logging.otel.impl.OpenTelemetryLoggingSDKFactory;
import org.mule.runtime.logging.otel.impl.configuration.LogRecordExporterConfiguratorException;
import org.mule.runtime.logging.otel.impl.configuration.OpenTelemetryLoggingConfigurationFactory;
import org.mule.runtime.logging.otel.impl.export.log4j.DedicatedSdkOpenTelemetryAppender;
import org.mule.runtime.module.artifact.api.classloader.DirectoryResourceLocator;
import org.mule.runtime.module.artifact.api.descriptor.ClassLoaderConfiguration;
import org.mule.runtime.module.artifact.api.descriptor.DeployableArtifactDescriptor;
import org.mule.runtime.module.observability.configuration.ObservabilitySignalConfiguration;
import org.mule.runtime.module.observability.configuration.ObservabilitySignalConfigurationFileFinder;

public class OpenTelemetryLog4JBridge {
    public static final String OPEN_TELEMETRY_APPENDER_NAME_SUFFIX = " OpenTelemetry logs";
    public static final String MULE_CONTAINER_APPENDER_NAME = "mule-container";

    private OpenTelemetryLog4JBridge() {
    }

    public static void addOpenTelemetryLogging(LoggerContext deployableArtifactLoggerContext, DeployableArtifactDescriptor deployableArtifactDescriptor) {
        ClassloaderConfigurationObservabilitySignalConfigurationFileFinder loggingConfigurationFinder = new ClassloaderConfigurationObservabilitySignalConfigurationFileFinder(deployableArtifactDescriptor);
        OpenTelemetryLog4JBridge.addOpenTelemetryLogging(deployableArtifactLoggerContext, deployableArtifactDescriptor, loggingConfigurationFinder);
    }

    public static void addOpenTelemetryLogging(LoggerContext muleContainerLoggerContext, ObservabilitySignalConfigurationFileFinder muleContainerLoggingConfigurationFinder) {
        OpenTelemetryLog4JBridge.addOpenTelemetryLogging(muleContainerLoggerContext, null, muleContainerLoggingConfigurationFinder);
    }

    private static void addOpenTelemetryLogging(LoggerContext loggerContext, DeployableArtifactDescriptor artifactDescriptor, ObservabilitySignalConfigurationFileFinder loggingConfigurationFinder) {
        ObservabilitySignalConfiguration loggingExportConfiguration = OpenTelemetryLoggingConfigurationFactory.getLoggingExportConfiguration(artifactDescriptor, loggingConfigurationFinder);
        if (loggingExportConfiguration.getBooleanValue("mule.openTelemetry.logging.exporter.enabled")) {
            try {
                OpenTelemetryLog4JBridge.doAddOpenTelemetryLogging(loggerContext, artifactDescriptor, loggingExportConfiguration);
            }
            catch (LogRecordExporterConfiguratorException e) {
                throw new MuleRuntimeException(I18nMessageFactory.createStaticMessage((String)"Error configuring OpenTelemetry logging bridge"), (Throwable)((Object)e));
            }
        }
    }

    private static void doAddOpenTelemetryLogging(LoggerContext muleLoggerContext, DeployableArtifactDescriptor artifactDescriptor, ObservabilitySignalConfiguration loggingExportConfiguration) throws LogRecordExporterConfiguratorException {
        Appender openTelemetryAppender = OpenTelemetryLog4JBridge.getOpenTelemetryLog4jAppender(muleLoggerContext, artifactDescriptor, loggingExportConfiguration);
        muleLoggerContext.getConfiguration().addAppender(openTelemetryAppender);
        openTelemetryAppender.start();
        String levelString = loggingExportConfiguration.getStringValue("mule.openTelemetry.logging.exporter.level");
        String normalizedLevel = OpenTelemetryLog4JBridge.normalizeSeverityLevel(levelString);
        Level loggingLevel = Level.toLevel((String)normalizedLevel, (Level)Level.INFO);
        muleLoggerContext.getConfiguration().getRootLogger().addAppender(openTelemetryAppender, loggingLevel, null);
        muleLoggerContext.getConfiguration().getLoggers().forEach((logger, loggerConfig) -> {
            if (!loggerConfig.isAdditive()) {
                loggerConfig.addAppender(openTelemetryAppender, loggingLevel, null);
            }
        });
    }

    private static String normalizeSeverityLevel(String levelString) {
        if (levelString == null || levelString.isEmpty()) {
            return levelString;
        }
        String upperLevel = levelString.toUpperCase();
        if (upperLevel.startsWith("TRACE")) {
            return "TRACE";
        }
        if (upperLevel.startsWith("DEBUG")) {
            return "DEBUG";
        }
        if (upperLevel.startsWith("INFO")) {
            return "INFO";
        }
        if (upperLevel.startsWith("WARN")) {
            return "WARN";
        }
        if (upperLevel.startsWith("ERROR")) {
            return "ERROR";
        }
        if (upperLevel.startsWith("FATAL")) {
            return "FATAL";
        }
        return levelString;
    }

    private static Appender getOpenTelemetryLog4jAppender(LoggerContext loggerContext, DeployableArtifactDescriptor artifactDescriptor, ObservabilitySignalConfiguration loggingExportConfiguration) {
        OpenTelemetryAppender openTelemetryAppender = ((OpenTelemetryAppender.Builder)((OpenTelemetryAppender.Builder)OpenTelemetryAppender.builder().setConfiguration(loggerContext.getConfiguration())).setName(OpenTelemetryLog4JBridge.resolveAppenderName(artifactDescriptor))).setCaptureContextDataAttributes("*").setCaptureExperimentalAttributes(true).build();
        return DedicatedSdkOpenTelemetryAppender.builder(openTelemetryAppender).withOpenTelemetryLoggingSdkProvider(() -> OpenTelemetryLoggingSDKFactory.getOpenTelemetryLoggingSDK(artifactDescriptor, loggingExportConfiguration)).build();
    }

    private static String resolveAppenderName(DeployableArtifactDescriptor artifactDescriptor) {
        return (artifactDescriptor != null ? artifactDescriptor.getName() : MULE_CONTAINER_APPENDER_NAME).concat(OPEN_TELEMETRY_APPENDER_NAME_SUFFIX);
    }

    private static class ClassloaderConfigurationObservabilitySignalConfigurationFileFinder
    implements ObservabilitySignalConfigurationFileFinder {
        private final DirectoryResourceLocator artifactResourcesDirectoryLocator;

        public ClassloaderConfigurationObservabilitySignalConfigurationFileFinder(DeployableArtifactDescriptor deployableArtifactDescriptor) {
            ClassLoaderConfiguration classLoaderConfiguration = deployableArtifactDescriptor.getClassLoaderConfiguration();
            this.artifactResourcesDirectoryLocator = classLoaderConfiguration != null && classLoaderConfiguration.getUrls() != null && classLoaderConfiguration.getUrls().length > 0 ? new DirectoryResourceLocator(new String[]{classLoaderConfiguration.getUrls()[0].getPath()}) : new DirectoryResourceLocator(new String[0]);
        }

        public File getResource(String path) {
            try {
                URL resource = this.artifactResourcesDirectoryLocator.findLocalResource(path);
                return resource != null ? new File(resource.toURI()) : null;
            }
            catch (URISyntaxException e) {
                return null;
            }
        }
    }
}

