/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.logging.otel.impl.configuration;

import io.opentelemetry.api.metrics.MeterProvider;
import io.opentelemetry.exporter.otlp.logs.OtlpGrpcLogRecordExporter;
import io.opentelemetry.exporter.otlp.logs.OtlpGrpcLogRecordExporterBuilder;
import io.opentelemetry.sdk.common.InternalTelemetryVersion;
import io.opentelemetry.sdk.logs.export.LogRecordExporter;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang3.StringUtils;
import org.mule.runtime.logging.otel.impl.configuration.HttpLoggingExporterConfigurator;
import org.mule.runtime.logging.otel.impl.configuration.LogRecordExporterConfiguratorException;
import org.mule.runtime.logging.otel.impl.configuration.LoggingExporterConfigurationUtils;
import org.mule.runtime.logging.otel.impl.configuration.LoggingExporterConfigurator;
import org.mule.runtime.module.observability.configuration.KeyValueParser;
import org.mule.runtime.module.observability.configuration.ObservabilitySignalConfiguration;
import org.mule.runtime.module.observability.configuration.ObservabilitySignalExporterConfigurator;

public class GrpcLoggingExporterConfigurator
implements LoggingExporterConfigurator {
    private static final ObservabilitySignalExporterConfigurator.TlsConfigurationMapper tlsConfigurationMapper = HttpLoggingExporterConfigurator.getTlsConfigurationMapper();

    @Override
    public LogRecordExporter configureExporter(ObservabilitySignalConfiguration configuration, MeterProvider exportMetricsMeterProvider) {
        try {
            String timeout;
            String headers;
            String compressionType;
            OtlpGrpcLogRecordExporterBuilder otlpGrpcLogRecordExporterBuilder = OtlpGrpcLogRecordExporter.builder();
            ObservabilitySignalExporterConfigurator exporterConfigurator = ObservabilitySignalExporterConfigurator.forConfiguration((ObservabilitySignalConfiguration)configuration);
            String endpoint = configuration.getStringValue("mule.openTelemetry.logging.exporter.endpoint");
            if (!StringUtils.isEmpty((CharSequence)endpoint)) {
                otlpGrpcLogRecordExporterBuilder.setEndpoint(endpoint);
            }
            if ((compressionType = configuration.getStringValue("mule.openTelemetry.logging.exporter.compression")) != null) {
                otlpGrpcLogRecordExporterBuilder.setCompression(compressionType);
            }
            if (configuration.getBooleanValue("mule.openTelemetry.logging.exporter.tls.enabled")) {
                exporterConfigurator.configureTlsCertificates(tlsConfigurationMapper, (tlsCaBytes, tlsCertBytes, tlsCertKeyBytes) -> this.configureTls(tlsCaBytes, tlsCertBytes, tlsCertKeyBytes, otlpGrpcLogRecordExporterBuilder));
            }
            if ((headers = configuration.getStringValue("mule.openTelemetry.logging.exporter.headers")) != null) {
                this.configureHeaders(otlpGrpcLogRecordExporterBuilder, headers);
            }
            if ((timeout = configuration.getStringValue("mule.openTelemetry.logging.exporter.timeout")) != null) {
                this.configureTimeout(otlpGrpcLogRecordExporterBuilder, timeout);
            }
            LoggingExporterConfigurationUtils.enableBackoffStrategy(otlpGrpcLogRecordExporterBuilder, configuration);
            if (LoggingExporterConfigurationUtils.isHealthMetricsEnabled()) {
                otlpGrpcLogRecordExporterBuilder.setInternalTelemetryVersion(InternalTelemetryVersion.LATEST);
            }
            otlpGrpcLogRecordExporterBuilder.setMeterProvider(exportMetricsMeterProvider);
            return otlpGrpcLogRecordExporterBuilder.build();
        }
        catch (Exception e) {
            throw new LogRecordExporterConfiguratorException(e);
        }
    }

    private void configureTls(byte[] tlsCaBytes, byte[] tlsCertBytes, byte[] tlsCertKeyBytes, OtlpGrpcLogRecordExporterBuilder otlpGrpcLogRecordExporterBuilder) {
        if (tlsCertBytes != null && tlsCertKeyBytes != null) {
            otlpGrpcLogRecordExporterBuilder.setClientTls(tlsCertKeyBytes, tlsCertBytes);
        }
        if (tlsCaBytes != null) {
            otlpGrpcLogRecordExporterBuilder.setTrustedCertificates(tlsCaBytes);
        }
    }

    private void configureTimeout(OtlpGrpcLogRecordExporterBuilder builder, String timeout) {
        builder.setTimeout(Long.parseLong(timeout), TimeUnit.MILLISECONDS);
    }

    private void configureHeaders(OtlpGrpcLogRecordExporterBuilder builder, String headers) {
        KeyValueParser.parse((String)headers, (KeyValueParser.KeyValueType)KeyValueParser.KeyValueType.HEADERS).forEach((arg_0, arg_1) -> ((OtlpGrpcLogRecordExporterBuilder)builder).addHeader(arg_0, arg_1));
    }
}

