/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.logging.otel.impl;

import io.opentelemetry.api.common.AttributeKey;
import io.opentelemetry.api.common.Attributes;
import io.opentelemetry.api.common.AttributesBuilder;
import io.opentelemetry.api.metrics.MeterProvider;
import io.opentelemetry.sdk.OpenTelemetrySdk;
import io.opentelemetry.sdk.logs.LogRecordProcessor;
import io.opentelemetry.sdk.logs.SdkLoggerProvider;
import io.opentelemetry.sdk.logs.export.LogRecordExporter;
import io.opentelemetry.sdk.logs.export.SimpleLogRecordProcessor;
import io.opentelemetry.sdk.metrics.SdkMeterProvider;
import io.opentelemetry.sdk.metrics.export.MetricExporter;
import io.opentelemetry.sdk.metrics.export.MetricReader;
import io.opentelemetry.sdk.metrics.export.PeriodicMetricReader;
import io.opentelemetry.sdk.resources.Resource;
import java.time.Duration;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import org.mule.runtime.logging.otel.impl.configuration.LogRecordExporterConfiguratorException;
import org.mule.runtime.logging.otel.impl.configuration.OpenTelemetryAutoConfigurableLoggingConfiguration;
import org.mule.runtime.logging.otel.impl.configuration.OpenTelemetryLoggingExporterBackpressureStrategy;
import org.mule.runtime.logging.otel.impl.configuration.OpenTelemetryLoggingExporterTransport;
import org.mule.runtime.logging.otel.impl.export.batch.BlockingBatchLogRecordProcessor;
import org.mule.runtime.logging.otel.impl.export.batch.BlockingBatchLogRecordProcessorBuilder;
import org.mule.runtime.logging.otel.impl.export.sniffer.ExportedLogRecordSniffer;
import org.mule.runtime.logging.otel.impl.export.sniffer.SniffedLogRecordExporter;
import org.mule.runtime.metrics.exporter.impl.optel.resources.inmemory.OpenTelemetryExportersMetrics;
import org.mule.runtime.module.artifact.api.descriptor.DeployableArtifactDescriptor;
import org.mule.runtime.module.observability.configuration.KeyValueParser;
import org.mule.runtime.module.observability.configuration.ObservabilitySignalConfiguration;
import org.mule.runtime.module.observability.configuration.ObservabilitySignalExporterConfigurator;

public class OpenTelemetryLoggingSDKFactory {
    private static final String SERVICE_NAMESPACE = "service.namespace";
    private static final String SERVICE_NAME = "service.name";
    private static final String SERVICE_INSTANCE_ID = "service.instance.id";
    private static final String DEFAULT_CONTAINER_SERVICE_NAME = "mule-container";
    private static final String USE_EXPORTER_SNIFFER = "mule.openTelemetry.logging.exporter.use.sniffer";
    private static final String MULE_OPEN_TELEMETRY_LOGGING_EXPORTER_BATCH_SCHEDULED_DELAY = "mule.openTelemetry.logging.exporter.batch.scheduledDelay";
    private static final SniffedLogRecordExporter sniffedLogRecordExporter = new SniffedLogRecordExporter(LogRecordExporter.composite((LogRecordExporter[])new LogRecordExporter[0]));

    private OpenTelemetryLoggingSDKFactory() {
    }

    public static OpenTelemetrySdk getOpenTelemetryLoggingSDK(DeployableArtifactDescriptor deployableArtifactDescriptor, ObservabilitySignalConfiguration loggingExportConfiguration) throws LogRecordExporterConfiguratorException {
        Resource resource = OpenTelemetryLoggingSDKFactory.configureLoggingResource(deployableArtifactDescriptor, loggingExportConfiguration);
        SdkLoggerProvider sdkLoggerProvider = SdkLoggerProvider.builder().addResource(resource).addLogRecordProcessor(OpenTelemetryLoggingSDKFactory.getLogRecordProcessor(loggingExportConfiguration, OpenTelemetryLoggingSDKFactory.resolveExportMetricsMeterProvider(loggingExportConfiguration))).build();
        return OpenTelemetrySdk.builder().setLoggerProvider(sdkLoggerProvider).build();
    }

    private static LogRecordProcessor getLogRecordProcessor(ObservabilitySignalConfiguration loggingExportConfiguration, SdkMeterProvider exportMetricsMeterProvider) throws LogRecordExporterConfiguratorException {
        if (Boolean.getBoolean(USE_EXPORTER_SNIFFER)) {
            return SimpleLogRecordProcessor.create((LogRecordExporter)sniffedLogRecordExporter);
        }
        return OpenTelemetryLoggingSDKFactory.createBatchLogRecordProcessor(OpenTelemetryLoggingSDKFactory.getLogRecordExporter(loggingExportConfiguration, exportMetricsMeterProvider), loggingExportConfiguration);
    }

    private static BlockingBatchLogRecordProcessor createBatchLogRecordProcessor(LogRecordExporter logRecordExporter, ObservabilitySignalConfiguration loggingExportConfiguration) throws LogRecordExporterConfiguratorException {
        BlockingBatchLogRecordProcessorBuilder batchLogRecordProcessorBuilder = BlockingBatchLogRecordProcessor.builder(logRecordExporter);
        int maxBatchSize = loggingExportConfiguration.getIntValue("mule.openTelemetry.logging.exporter.batch.maxSize");
        if (maxBatchSize < 512) {
            throw new LogRecordExporterConfiguratorException("The batch max size cannot be lower than 512");
        }
        int batchQueueSize = loggingExportConfiguration.getIntValue("mule.openTelemetry.logging.exporter.batch.queueSize");
        return batchLogRecordProcessorBuilder.setMaxQueueSize(batchQueueSize).setScheduleDelay(Long.getLong(MULE_OPEN_TELEMETRY_LOGGING_EXPORTER_BATCH_SCHEDULED_DELAY, OpenTelemetryAutoConfigurableLoggingConfiguration.DEFAULT_BATCH_SCHEDULE_DELAY_MILLIS), TimeUnit.MILLISECONDS).setBackpressureStrategy(OpenTelemetryLoggingExporterBackpressureStrategy.valueOf(loggingExportConfiguration.getStringValue("mule.openTelemetry.logging.exporter.batch.backPressure.strategy"))).setMaxExportBatchSize(maxBatchSize).build();
    }

    private static LogRecordExporter getLogRecordExporter(ObservabilitySignalConfiguration loggingExportConfiguration, SdkMeterProvider exportMetricsMeterProvider) throws LogRecordExporterConfiguratorException {
        String type = loggingExportConfiguration.getStringValue("mule.openTelemetry.logging.exporter.type");
        if (type == null) {
            throw new LogRecordExporterConfiguratorException("A type for log export was not configured.");
        }
        try {
            return OpenTelemetryLoggingExporterTransport.valueOf(type).getLoggingExporterConfigurator().configureExporter(loggingExportConfiguration, (MeterProvider)exportMetricsMeterProvider);
        }
        catch (Exception e) {
            throw new LogRecordExporterConfiguratorException(e);
        }
    }

    public static ExportedLogRecordSniffer getLogRecordSniffer() {
        return sniffedLogRecordExporter.getExportedLogRecordSniffer();
    }

    private static Resource configureLoggingResource(DeployableArtifactDescriptor deployableArtifactDescriptor, ObservabilitySignalConfiguration loggingExportConfiguration) {
        AttributesBuilder attributesBuilder = Attributes.builder().put(AttributeKey.stringKey((String)SERVICE_NAME), (Object)OpenTelemetryLoggingSDKFactory.resolveServiceName(deployableArtifactDescriptor, loggingExportConfiguration)).put(AttributeKey.stringKey((String)SERVICE_NAMESPACE), (Object)OpenTelemetryLoggingSDKFactory.resolveServiceNamespace(loggingExportConfiguration)).put(AttributeKey.stringKey((String)SERVICE_INSTANCE_ID), (Object)OpenTelemetryLoggingSDKFactory.resolveServiceInstanceId(deployableArtifactDescriptor));
        String attributesString = loggingExportConfiguration.getStringValue("mule.openTelemetry.logging.exporter.resource.attributes");
        if (attributesString != null && !attributesString.trim().isEmpty()) {
            try {
                Map attributes = KeyValueParser.parse((String)attributesString, (KeyValueParser.KeyValueType)KeyValueParser.KeyValueType.ATTRIBUTES);
                attributes.forEach((key, value) -> attributesBuilder.put(AttributeKey.stringKey((String)key), value));
            }
            catch (IllegalArgumentException e) {
                throw new LogRecordExporterConfiguratorException("Invalid resource attributes configuration.", e);
            }
        }
        ObservabilitySignalExporterConfigurator.forConfiguration((ObservabilitySignalConfiguration)loggingExportConfiguration).configureAnypointMetadata(() -> "mule.openTelemetry.logging.exporter.resource.includeAnypointMetadata", anypointMetadata -> anypointMetadata.forEach((arg_0, arg_1) -> ((AttributesBuilder)attributesBuilder).put(arg_0, arg_1)));
        return Resource.create((Attributes)attributesBuilder.build());
    }

    private static String resolveServiceName(DeployableArtifactDescriptor deployableArtifactDescriptor, ObservabilitySignalConfiguration loggingExportConfiguration) {
        if (deployableArtifactDescriptor != null) {
            return loggingExportConfiguration.getStringValue("mule.openTelemetry.logging.exporter.resource.service.name", deployableArtifactDescriptor.getName());
        }
        return loggingExportConfiguration.getStringValue("mule.openTelemetry.logging.exporter.resource.service.name", DEFAULT_CONTAINER_SERVICE_NAME);
    }

    private static String resolveServiceNamespace(ObservabilitySignalConfiguration loggingExportConfiguration) {
        return loggingExportConfiguration.getStringValue("mule.openTelemetry.logging.exporter.resource.service.namespace");
    }

    private static String resolveServiceInstanceId(DeployableArtifactDescriptor deployableArtifactDescriptor) {
        if (deployableArtifactDescriptor != null) {
            return deployableArtifactDescriptor.getDescriptorId();
        }
        return UUID.randomUUID().toString();
    }

    private static SdkMeterProvider resolveExportMetricsMeterProvider(ObservabilitySignalConfiguration loggingExporterConfiguration) {
        PeriodicMetricReader periodicReader = PeriodicMetricReader.builder((MetricExporter)new OpenTelemetryExportersMetrics()).setInterval(Duration.ofMillis(Long.parseLong(loggingExporterConfiguration.getStringValue("mule.openTelemetry.logging.exportermetricsLogFrequency")))).build();
        return SdkMeterProvider.builder().registerMetricReader((MetricReader)periodicReader).build();
    }
}

