/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.http.support.api;

import jakarta.inject.Inject;
import java.util.Optional;
import java.util.function.Consumer;
import org.mule.runtime.http.api.client.HttpClientConfiguration;
import org.mule.runtime.http.api.server.HttpServerConfiguration;
import org.mule.runtime.http.support.internal.client.HttpClientConfigToBuilder;
import org.mule.runtime.http.support.internal.client.HttpClientWrapper;
import org.mule.runtime.http.support.internal.message.HttpEntityFactoryImpl;
import org.mule.runtime.http.support.internal.message.HttpRequestBuilderWrapper;
import org.mule.runtime.http.support.internal.message.HttpResponseBuilderWrapper;
import org.mule.runtime.http.support.internal.server.HttpServerConfigToBuilder;
import org.mule.runtime.http.support.internal.server.HttpServerWrapper;
import org.mule.sdk.api.http.HttpService;
import org.mule.sdk.api.http.client.ClientCreationException;
import org.mule.sdk.api.http.client.HttpClient;
import org.mule.sdk.api.http.client.HttpClientConfigurer;
import org.mule.sdk.api.http.domain.entity.HttpEntityFactory;
import org.mule.sdk.api.http.domain.message.request.HttpRequestBuilder;
import org.mule.sdk.api.http.domain.message.response.HttpResponse;
import org.mule.sdk.api.http.domain.message.response.HttpResponseBuilder;
import org.mule.sdk.api.http.server.HttpServer;
import org.mule.sdk.api.http.server.HttpServerConfigurer;
import org.mule.sdk.api.http.server.ServerCreationException;

public class HttpServiceApiDelegate
implements HttpService {
    private HttpEntityFactory httpEntityFactory;
    private org.mule.runtime.http.api.HttpService httpService;

    @Inject
    public void setHttpService(Optional<org.mule.runtime.http.api.HttpService> httpService) {
        this.httpService = httpService.orElse(null);
        this.httpEntityFactory = new HttpEntityFactoryImpl(this.httpService == null ? null : this.httpService.getEntityFactory());
    }

    public HttpClient client(Consumer<HttpClientConfigurer> configCallback) throws ClientCreationException {
        if (this.httpService == null) {
            throw new ClientCreationException("There is no implementation of HttpService available");
        }
        HttpClientConfiguration.Builder builder = new HttpClientConfiguration.Builder();
        HttpClientConfigToBuilder configurer = new HttpClientConfigToBuilder(builder);
        configCallback.accept(configurer);
        HttpClientConfiguration configuration = builder.build();
        try {
            return new HttpClientWrapper(this.httpService.getClientFactory().create(configuration));
        }
        catch (Exception e) {
            throw new ClientCreationException("Couldn't create client", (Throwable)e);
        }
    }

    public HttpServer server(Consumer<HttpServerConfigurer> configCallback) throws ServerCreationException {
        if (this.httpService == null) {
            throw new ServerCreationException("There is no implementation of HttpService available");
        }
        HttpServerConfiguration.Builder builder = new HttpServerConfiguration.Builder();
        HttpServerConfigToBuilder configurer = new HttpServerConfigToBuilder(builder);
        configCallback.accept(configurer);
        HttpServerConfiguration configuration = builder.build();
        try {
            return new HttpServerWrapper(this.httpService.getServerFactory().create(configuration));
        }
        catch (org.mule.runtime.http.api.server.ServerCreationException e) {
            throw new ServerCreationException(e.getMessage(), (Throwable)e);
        }
    }

    public HttpResponseBuilder responseBuilder() {
        return new HttpResponseBuilderWrapper();
    }

    public HttpResponseBuilder responseBuilder(HttpResponse original) {
        return this.responseBuilder().statusCode(Integer.valueOf(original.getStatusCode())).reasonPhrase(original.getReasonPhrase());
    }

    public HttpRequestBuilder requestBuilder() {
        return new HttpRequestBuilderWrapper();
    }

    public HttpRequestBuilder requestBuilder(boolean preserveHeaderCase) {
        return new HttpRequestBuilderWrapper(preserveHeaderCase);
    }

    public HttpEntityFactory entityFactory() {
        return this.httpEntityFactory;
    }
}

