/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.feature.internal.togglz.provider;

import com.github.benmanes.caffeine.cache.Cache;
import com.github.benmanes.caffeine.cache.Caffeine;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.mule.runtime.api.profiling.type.ProfilingEventType;
import org.mule.runtime.feature.internal.togglz.MuleTogglzFeatureMetadata;
import org.mule.runtime.feature.internal.togglz.MuleTogglzProfilingFeature;
import org.mule.runtime.feature.internal.togglz.MuleTogglzRuntimeFeature;
import org.mule.runtime.feature.internal.togglz.provider.MuleTogglzFeatureProvider;
import org.togglz.core.Feature;
import org.togglz.core.metadata.FeatureMetaData;
import org.togglz.core.metadata.enums.EnumFeatureMetaData;

public class DefaultMuleTogglzFeatureProvider
implements MuleTogglzFeatureProvider {
    public static final String RUNTIME_FEATURE_NOT_REGISTERED = "Runtime feature %s not registered";
    public static final String FEATURE_ENUMS_NOT_NULL = "The featureEnums argument must not be null";
    public static final String ARGUMENT_MUST_BE_ENUM = "The featureEnum argument must be an enum";
    public static final String FEATURE_HAS_ALREADY_BEEN_ADDED = "The '%s' feature has already been added";
    public static final String CONSUMER_NAME_MUST_NOT_BE_NULL = "Consumer name must not be null.";
    public static final String FEATURE_NAME_MUST_NOT_BE_NULL = "Feature name must not be null.";
    private final Cache<org.mule.runtime.api.config.Feature, MuleTogglzRuntimeFeature> runtimeFeaturesCache = Caffeine.newBuilder().build();
    private final Cache<ProfilingEventType<?>, Map<String, MuleTogglzProfilingFeature>> profilingEventTypesFeatures = Caffeine.newBuilder().build();
    private final Map<String, FeatureMetaData> metadataCache = new ConcurrentHashMap<String, FeatureMetaData>();
    private final Map<String, Feature> features = new ConcurrentHashMap<String, Feature>();

    public DefaultMuleTogglzFeatureProvider(Class<? extends Feature> initialFeatureEnum) {
        if (initialFeatureEnum == null) {
            throw new IllegalArgumentException(FEATURE_ENUMS_NOT_NULL);
        }
        this.addFeatureEnum(initialFeatureEnum);
    }

    public void addFeatureEnum(Class<? extends Feature> featureEnum) {
        if (featureEnum == null || !featureEnum.isEnum()) {
            throw new IllegalArgumentException(ARGUMENT_MUST_BE_ENUM);
        }
        this.addFeatures(Arrays.asList(featureEnum.getEnumConstants()));
    }

    private void addFeatures(Collection<? extends Feature> newFeatures) {
        for (Feature feature : newFeatures) {
            if (this.metadataCache.put(feature.name(), (FeatureMetaData)new EnumFeatureMetaData(feature)) != null) {
                throw new IllegalArgumentException(String.format(FEATURE_HAS_ALREADY_BEEN_ADDED, feature.name()));
            }
            this.features.put(feature.name(), feature);
        }
    }

    public Set<Feature> getFeatures() {
        return new HashSet<Feature>(this.features.values());
    }

    public FeatureMetaData getMetaData(Feature feature) {
        return this.metadataCache.get(feature.name());
    }

    @Override
    public Feature getRuntimeTogglzFeature(org.mule.runtime.api.config.Feature feature) {
        return (Feature)this.runtimeFeaturesCache.get((Object)feature, ft -> {
            throw new IllegalArgumentException(String.format(RUNTIME_FEATURE_NOT_REGISTERED, feature));
        });
    }

    @Override
    public MuleTogglzRuntimeFeature getOrRegisterRuntimeTogglzFeatureFrom(org.mule.runtime.api.config.Feature feature) {
        return (MuleTogglzRuntimeFeature)this.runtimeFeaturesCache.get((Object)feature, this::newRuntimeTogglzFeature);
    }

    private MuleTogglzRuntimeFeature newRuntimeTogglzFeature(org.mule.runtime.api.config.Feature ft) {
        if (ft == null) {
            throw new IllegalArgumentException(FEATURE_NAME_MUST_NOT_BE_NULL);
        }
        MuleTogglzRuntimeFeature newFeature = new MuleTogglzRuntimeFeature(ft);
        this.addTogglzFeatureMetadata(newFeature);
        return newFeature;
    }

    private void addTogglzFeatureMetadata(Feature newFeature) {
        if (this.metadataCache.put(newFeature.name(), new MuleTogglzFeatureMetadata(newFeature)) != null) {
            return;
        }
        this.features.put(newFeature.name(), newFeature);
    }

    @Override
    public MuleTogglzProfilingFeature getOrRegisterProfilingTogglzFeatureFrom(ProfilingEventType<?> profilingEventType, String consumerName) {
        if (consumerName == null) {
            throw new IllegalArgumentException(CONSUMER_NAME_MUST_NOT_BE_NULL);
        }
        MuleTogglzProfilingFeature consumerFeature = new MuleTogglzProfilingFeature(profilingEventType, consumerName);
        this.addTogglzFeatureMetadata(consumerFeature);
        return ((Map)this.profilingEventTypesFeatures.get(profilingEventType, profEventType -> new ConcurrentHashMap())).computeIfAbsent(consumerName, name -> consumerFeature);
    }

    public Collection<MuleTogglzProfilingFeature> getConsumerFeaturesFor(ProfilingEventType<?> profilingEventType) {
        return ((Map)this.profilingEventTypesFeatures.get(profilingEventType, profEventType -> new ConcurrentHashMap())).values();
    }

    @Override
    public Feature getFeature(String featureName) {
        if (featureName == null) {
            throw new IllegalArgumentException(FEATURE_NAME_MUST_NOT_BE_NULL);
        }
        return this.features.get(featureName);
    }
}

