/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.extension.internal.ast;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Optional;
import java.util.Set;
import java.util.Spliterator;
import java.util.function.UnaryOperator;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.mule.metadata.api.model.MetadataType;
import org.mule.runtime.api.component.ComponentIdentifier;
import org.mule.runtime.api.component.TypedComponentIdentifier;
import org.mule.runtime.api.component.location.ComponentLocation;
import org.mule.runtime.api.component.location.LocationPart;
import org.mule.runtime.api.meta.model.ExtensionModel;
import org.mule.runtime.api.meta.model.config.ConfigurationModel;
import org.mule.runtime.api.meta.model.operation.OperationModel;
import org.mule.runtime.api.meta.model.parameter.ParameterGroupModel;
import org.mule.runtime.api.meta.model.parameter.ParameterizedModel;
import org.mule.runtime.ast.api.ArtifactAst;
import org.mule.runtime.ast.api.ComponentAst;
import org.mule.runtime.ast.api.ComponentGenerationInformation;
import org.mule.runtime.ast.api.ComponentMetadataAst;
import org.mule.runtime.ast.api.ComponentParameterAst;
import org.mule.runtime.ast.api.util.AstTraversalDirection;
import org.mule.runtime.ast.api.util.BaseComponentAst;
import org.mule.runtime.ast.api.util.BaseComponentAstDecorator;
import org.mule.runtime.ast.api.util.ComponentAstPredicatesFactory;
import org.mule.runtime.ast.api.util.MuleArtifactAstCopyUtils;
import org.mule.runtime.dsl.api.component.config.DefaultComponentLocation;
import org.mule.runtime.extension.internal.ast.MacroExpandedComponentAst;
import org.mule.runtime.extension.internal.ast.XmlSdkImplicitConfig;
import org.mule.runtime.extension.internal.ast.property.GlobalElementComponentModelModelProperty;
import org.mule.runtime.extension.internal.ast.property.OperationComponentModelModelProperty;
import org.mule.runtime.module.extension.internal.util.MuleExtensionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MacroExpansionModuleModel {
    private static final Logger LOGGER = LoggerFactory.getLogger(MacroExpansionModuleModel.class);
    public static final String MODULE_CONFIG_GLOBAL_ELEMENT_NAME = "config";
    public static final String MODULE_CONNECTION_GLOBAL_ELEMENT_NAME = "connection";
    public static final String MODULE_OPERATION_CONFIG_REF = "config-ref";
    public static final String TNS_PREFIX = "tns";
    public static final String DEFAULT_GLOBAL_ELEMENTS = "_defaultGlobalElements";
    private static final String DEFAULT_CONFIG_GLOBAL_ELEMENT_SUFFIX = "%s-default-config-global-element-suffix";
    private static final String IMPLICIT_CONFIG_WARNING = "An implicit config is being used for extension %s, this is not fully supported for this extension. All operation usages of this extension should have a reference to an explicit configuration.";
    private final boolean disable_xml_sdk_implicit_configuration_creation = Boolean.valueOf(System.getProperty("mule.disableXmlSdkImplicitConfigurationCreation", "true"));
    private final ArtifactAst applicationModel;
    private final ExtensionModel extensionModel;
    private final boolean isDynamicConfigRefEnabled = Boolean.getBoolean("mule.experimental.enableDynamicConfigRef");

    MacroExpansionModuleModel(ArtifactAst applicationModel, ExtensionModel extensionModel) {
        this.applicationModel = applicationModel;
        this.extensionModel = extensionModel;
    }

    public ArtifactAst expand() {
        List<ComponentAst> moduleGlobalElements = this.getModuleGlobalElements();
        Set<String> moduleGlobalElementsNames = moduleGlobalElements.stream().map(ComponentAst::getComponentId).filter(Optional::isPresent).map(Optional::get).collect(Collectors.toSet());
        return this.expand(moduleGlobalElements, moduleGlobalElementsNames);
    }

    private ArtifactAst expand(List<ComponentAst> moduleComponentModels, Set<String> moduleGlobalElementsNames) {
        ArtifactAst expandedArtifactAst;
        if (this.shouldAddImplicitConfiguration()) {
            LOGGER.warn(String.format(IMPLICIT_CONFIG_WARNING, this.extensionModel.getName()));
            expandedArtifactAst = !this.disable_xml_sdk_implicit_configuration_creation ? MuleArtifactAstCopyUtils.copyRecursively((ArtifactAst)this.applicationModel, UnaryOperator.identity(), () -> Collections.singletonList(new XmlSdkImplicitConfig(this.extensionModel)), comp -> false) : this.applicationModel;
        } else {
            expandedArtifactAst = this.applicationModel;
        }
        return MuleArtifactAstCopyUtils.copyRecursively((ArtifactAst)expandedArtifactAst, comp -> {
            if (comp.getIdentifier().getNamespace().equals(this.extensionModel.getXmlDslModel().getPrefix())) {
                if (comp.getModel(OperationModel.class).isPresent()) {
                    return comp.getModel(OperationModel.class).map(operationModel -> this.expandOperation(expandedArtifactAst, (ComponentAst)comp, (OperationModel)operationModel, moduleGlobalElementsNames, Optional.empty())).orElse((ComponentAst)comp);
                }
                if (comp.getModel(ConfigurationModel.class).isPresent()) {
                    return comp.getModel(ConfigurationModel.class).map(configurationModel -> this.expandGlobalElement(moduleComponentModels, moduleGlobalElementsNames, (ComponentAst)comp, (ConfigurationModel)configurationModel)).orElse((ComponentAst)comp);
                }
            }
            return comp;
        }, () -> this.macroExpandDefaultGlobalElements(moduleGlobalElementsNames).map(Collections::singletonList).orElse(Collections.emptyList()), comp -> false);
    }

    private boolean shouldAddImplicitConfiguration() {
        return this.existOperationThatUsesImplicitConfiguration() && this.hasXmlSdkPropertiesWithDefaultValues();
    }

    private boolean existOperationThatUsesImplicitConfiguration() {
        return this.applicationModel.topLevelComponentsStream().filter(componentAst -> componentAst.getIdentifier().getName().equals("flow") || componentAst.getIdentifier().getName().equals("sub-flow")).flatMap(ComponentAst::directChildrenStream).anyMatch(this::existOperationThatUsesImplicitConfiguration);
    }

    private boolean existOperationThatUsesImplicitConfiguration(ComponentAst componentAst) {
        if (componentAst.getIdentifier().getNamespace().equals(this.extensionModel.getXmlDslModel().getPrefix()) && componentAst.getModel(OperationModel.class).isPresent() && !componentAst.getParameters().contains(MODULE_OPERATION_CONFIG_REF)) {
            return true;
        }
        for (ComponentAst childComponentAst : componentAst.directChildren()) {
            if (!this.existOperationThatUsesImplicitConfiguration(childComponentAst)) continue;
            return true;
        }
        return false;
    }

    private boolean hasXmlSdkPropertiesWithDefaultValues() {
        return this.extensionModel.getConfigurationModel(MODULE_CONFIG_GLOBAL_ELEMENT_NAME).map(ParameterizedModel::getParameterGroupModels).orElse(Collections.emptyList()).stream().filter(parameterGroupModel -> parameterGroupModel.getName().equals("General")).findFirst().map(ParameterGroupModel::getParameterModels).orElse(Collections.emptyList()).stream().noneMatch(parameterModel -> parameterModel.isRequired() && !parameterModel.getName().equals("name"));
    }

    private Optional<String> defaultGlobalElementName() {
        Optional<String> defaultElementName = Optional.empty();
        if (this.extensionModel.getConfigurationModels().isEmpty() && this.extensionModel.getModelProperty(GlobalElementComponentModelModelProperty.class).isPresent()) {
            defaultElementName = this.extensionModel.getModelProperty(GlobalElementComponentModelModelProperty.class).map(globalElementComponentModelModelProperty -> String.format(DEFAULT_CONFIG_GLOBAL_ELEMENT_SUFFIX, this.extensionModel.getName()));
        }
        return defaultElementName;
    }

    private Optional<ComponentAst> macroExpandDefaultGlobalElements(Set<String> moduleGlobalElementsNames) {
        return this.defaultGlobalElementName().map(defaultGlobalElementSuffix -> {
            List<ComponentAst> globalElements = ((GlobalElementComponentModelModelProperty)this.extensionModel.getModelProperty(GlobalElementComponentModelModelProperty.class).get()).getGlobalElements();
            final List mappedGlobalElements = globalElements.stream().map(globalElement -> MuleArtifactAstCopyUtils.copyComponentTreeRecursively((ComponentAst)globalElement, comp -> new MacroExpandedComponentAst((ComponentAst)comp, this.resolveMacroExpandedLocation((String)defaultGlobalElementSuffix, (ComponentAst)globalElement, (ComponentAst)comp), moduleGlobalElementsNames, (String)defaultGlobalElementSuffix, comp.directChildrenStream().collect(Collectors.toList())))).collect(Collectors.toList());
            return new BaseComponentAst(){
                private final ComponentIdentifier identifier;
                {
                    this.identifier = ComponentIdentifier.builder().namespaceUri(MacroExpansionModuleModel.this.extensionModel.getXmlDslModel().getNamespace()).namespace(MacroExpansionModuleModel.this.extensionModel.getXmlDslModel().getPrefix()).name(MacroExpansionModuleModel.DEFAULT_GLOBAL_ELEMENTS).build();
                }

                public Stream<ComponentAst> recursiveStream(AstTraversalDirection direction) {
                    return Stream.concat(Stream.of(this), mappedGlobalElements.stream().flatMap(g -> g.recursiveStream(direction)));
                }

                public Spliterator<ComponentAst> recursiveSpliterator(AstTraversalDirection direction) {
                    return this.recursiveStream(direction).spliterator();
                }

                public List<ComponentAst> directChildren() {
                    return mappedGlobalElements;
                }

                public Collection<ComponentParameterAst> getParameters() {
                    return Collections.emptySet();
                }

                public ComponentParameterAst getParameter(String groupName, String paramName) {
                    throw new NoSuchElementException("_defaultGlobalElements does not have parameters");
                }

                public ExtensionModel getExtensionModel() {
                    return MacroExpansionModuleModel.this.extensionModel;
                }

                public <M> Optional<M> getModel(Class<M> modelClass) {
                    return Optional.empty();
                }

                public MetadataType getType() {
                    return null;
                }

                public Map<String, Object> getAnnotations() {
                    return Collections.emptyMap();
                }

                public ComponentMetadataAst getMetadata() {
                    return ComponentMetadataAst.EMPTY_METADATA;
                }

                public ComponentGenerationInformation getGenerationInformation() {
                    return ComponentGenerationInformation.EMPTY_GENERATION_INFO;
                }

                public ComponentLocation getLocation() {
                    return DefaultComponentLocation.from((String)MacroExpansionModuleModel.DEFAULT_GLOBAL_ELEMENTS);
                }

                public ComponentIdentifier getIdentifier() {
                    return this.identifier;
                }

                public TypedComponentIdentifier.ComponentType getComponentType() {
                    return null;
                }

                public Optional<String> getComponentId() {
                    return Optional.empty();
                }
            };
        });
    }

    private ComponentAst expandGlobalElement(List<ComponentAst> moduleComponentModels, Set<String> moduleGlobalElementsNames, ComponentAst comp, ConfigurationModel configurationModel) {
        Map<String, Object> propertiesMap = comp.getParameters().stream().filter(paramAst -> paramAst.getValue().isRight()).collect(Collectors.toMap(paramAst -> paramAst.getModel().getName(), paramAst -> paramAst.getValue().getRight()));
        Map<String, String> connectionPropertiesMap = this.extractConnectionProperties(comp, configurationModel);
        propertiesMap.putAll(connectionPropertiesMap);
        Map<String, Object> literalsParameters = this.getLiteralParameters(propertiesMap, Collections.emptyMap());
        String defaultGlobalElementSuffix = comp.getComponentId().orElse("");
        final List mappedModuleComponentModels = moduleComponentModels.stream().map(nestedComp -> MuleArtifactAstCopyUtils.copyComponentTreeRecursively((ComponentAst)nestedComp, c -> new MacroExpandedComponentAst((ComponentAst)c, this.resolveMacroExpandedLocation(defaultGlobalElementSuffix, (ComponentAst)nestedComp, (ComponentAst)c), moduleGlobalElementsNames, defaultGlobalElementSuffix, literalsParameters, c.directChildrenStream().collect(Collectors.toList())))).collect(Collectors.toList());
        return new BaseComponentAstDecorator(comp){

            public Stream<ComponentAst> directChildrenStream() {
                return mappedModuleComponentModels.stream();
            }
        };
    }

    private Optional<ConfigurationModel> getConfigurationModel() {
        return this.extensionModel.getConfigurationModel(MODULE_CONFIG_GLOBAL_ELEMENT_NAME);
    }

    private ComponentLocation resolveMacroExpandedLocation(String defaultGlobalElementSuffix, ComponentAst macroExpandedComp, ComponentAst innerComp) {
        ArrayList<DefaultComponentLocation.DefaultLocationPart> parts = new ArrayList<DefaultComponentLocation.DefaultLocationPart>();
        LocationPart firstPart = (LocationPart)macroExpandedComp.getLocation().getParts().get(0);
        parts.add(new DefaultComponentLocation.DefaultLocationPart(macroExpandedComp.getComponentId().map(id -> id.concat("-").concat(defaultGlobalElementSuffix)).orElse(defaultGlobalElementSuffix), firstPart.getPartIdentifier(), firstPart.getFileName(), firstPart.getLine(), firstPart.getColumn()));
        innerComp.getLocation().getParts().stream().skip(2L).map(lp -> (DefaultComponentLocation.DefaultLocationPart)lp).forEach(parts::add);
        return new DefaultComponentLocation(innerComp.getComponentId(), parts);
    }

    private List<ComponentAst> getModuleGlobalElements() {
        return this.extensionModel.getModelProperty(GlobalElementComponentModelModelProperty.class).map(GlobalElementComponentModelModelProperty::getGlobalElements).orElse(Collections.emptyList());
    }

    private ComponentAst expandOperation(ArtifactAst expandedArtifactAst, ComponentAst operationRefModel, OperationModel operationModel, Set<String> moduleGlobalElementsNames, Optional<String> configRefParentTnsName) {
        OperationComponentModelModelProperty operationComponentModelModelProperty = (OperationComponentModelModelProperty)operationModel.getModelProperty(OperationComponentModelModelProperty.class).get();
        ComponentAst operationModuleComponentModel = operationComponentModelModelProperty.getBodyComponentModel();
        Optional<String> configRefName = this.referencesOperationsWithinModule(operationRefModel) ? configRefParentTnsName : this.getConfigRefName(operationRefModel);
        Optional<String> configRef = !configRefName.isPresent() && this.extensionModel.getConfigurationModel(MODULE_CONFIG_GLOBAL_ELEMENT_NAME).isPresent() && this.shouldAddImplicitConfiguration() && !this.disable_xml_sdk_implicit_configuration_creation ? Optional.of(String.format("%s-xml-sdk-implicit-config", this.extensionModel.getName())) : configRefName;
        Map<String, String> propertiesMap = this.extractProperties(expandedArtifactAst, configRef);
        Map<String, String> parametersMap = operationRefModel.getParameters().stream().filter(paramAst -> paramAst.getResolvedRawValue() != null).collect(Collectors.toMap(paramAst -> paramAst.getModel().getName(), paramAst -> paramAst.getResolvedRawValue()));
        Map<String, Object> literalParameters = this.getLiteralParameters(propertiesMap, parametersMap);
        final List processorChainChildren = operationModuleComponentModel.directChildrenStream().map(bodyProcessor -> MuleArtifactAstCopyUtils.copyComponentTreeRecursively((ComponentAst)bodyProcessor, operationChildModel -> this.lookForTNSOperation((ComponentAst)operationChildModel).map(tnsOperation -> this.expandOperation(expandedArtifactAst, (ComponentAst)operationChildModel, (OperationModel)tnsOperation, moduleGlobalElementsNames, configRef)).orElseGet(() -> new MacroExpandedComponentAst((ComponentAst)operationChildModel, operationChildModel.getLocation(), moduleGlobalElementsNames, configRef.orElse(""), literalParameters, operationChildModel.directChildrenStream().collect(Collectors.toList()))))).collect(Collectors.toList());
        return new BaseComponentAstDecorator(operationRefModel){

            public Stream<ComponentAst> directChildrenStream() {
                return Stream.concat(super.directChildrenStream(), processorChainChildren.stream());
            }
        };
    }

    private Optional<String> getConfigRefName(ComponentAst operationRefModel) {
        ComponentParameterAst parameterAst = operationRefModel.getParameter("General", MODULE_OPERATION_CONFIG_REF);
        if (parameterAst != null && parameterAst.getResolvedRawValue() != null) {
            return Optional.of(parameterAst.getResolvedRawValue());
        }
        return this.defaultGlobalElementName();
    }

    private Map<String, Object> getLiteralParameters(Map<String, ?> propertiesMap, Map<String, String> parametersMap) {
        Map<String, Object> literalParameters = propertiesMap.entrySet().stream().filter(entry -> !MuleExtensionUtils.isExpression(entry.getValue())).collect(Collectors.toMap(e -> this.getReplaceableExpression((String)e.getKey(), "vars"), Map.Entry::getValue));
        literalParameters.putAll(parametersMap.entrySet().stream().filter(entry -> !MuleExtensionUtils.isExpression(entry.getValue())).collect(Collectors.toMap(e -> this.getReplaceableExpression((String)e.getKey(), "vars"), Map.Entry::getValue)));
        return literalParameters;
    }

    private String getReplaceableExpression(String name, String prefix) {
        return "#[" + prefix + "." + name + "]";
    }

    private Map<String, String> extractProperties(ArtifactAst expandedArtifactAst, Optional<String> configRefName) {
        HashMap<String, String> valuesMap = new HashMap<String, String>();
        configRefName.filter(configParameter -> this.shouldExtractPropertiesFrom((String)configParameter)).ifPresent(configParameter -> {
            ComponentAst configRefComponentModel = this.getComponentAst(expandedArtifactAst, (String)configParameter);
            ConfigurationModel configurationModel = this.getConfigurationModel().get();
            configRefComponentModel.getParameters().stream().filter(paramAst -> paramAst.getResolvedRawValue() != null).forEach(paramAst -> valuesMap.put(paramAst.getModel().getName(), paramAst.getResolvedRawValue()));
            valuesMap.putAll(this.extractConnectionProperties(configRefComponentModel, configurationModel));
        });
        return valuesMap;
    }

    private boolean shouldExtractPropertiesFrom(String configParameter) {
        if (this.isDynamicConfigRefEnabled && MuleExtensionUtils.isExpression((Object)configParameter)) {
            return false;
        }
        return this.defaultGlobalElementName().map(defaultGlobalElementName -> !defaultGlobalElementName.equals(configParameter)).orElse(true);
    }

    private ComponentAst getComponentAst(ArtifactAst applicationModel, String configParameter) {
        return applicationModel.filteredComponents(ComponentAstPredicatesFactory.equalsNamespace((String)this.extensionModel.getXmlDslModel().getPrefix())).filter(componentModel -> componentModel.getModel(ConfigurationModel.class).isPresent() && configParameter.equals(componentModel.getComponentId().orElse(null))).findFirst().orElseGet(() -> {
            Optional parent = applicationModel.getParent();
            if (parent.isPresent()) {
                return this.getComponentAst((ArtifactAst)parent.get(), configParameter);
            }
            throw new IllegalArgumentException(String.format("There's no <%s:config> named [%s] in the current mule app nor in its domain", this.extensionModel.getXmlDslModel().getPrefix(), configParameter));
        });
    }

    private Map<String, String> extractConnectionProperties(ComponentAst configRefComponentModel, ConfigurationModel configurationModel) {
        return configurationModel.getConnectionProviderModel(MODULE_CONNECTION_GLOBAL_ELEMENT_NAME).flatMap(connectionProviderModel -> configRefComponentModel.directChildrenStream().filter(componentModel -> MODULE_CONNECTION_GLOBAL_ELEMENT_NAME.equals(componentModel.getIdentifier().getName())).findFirst().map(connectionComponentModel -> connectionComponentModel.getParameters().stream().filter(paramAst -> paramAst.getResolvedRawValue() != null).collect(Collectors.toMap(paramAst -> paramAst.getModel().getName(), paramAst -> paramAst.getResolvedRawValue())))).orElse(Collections.emptyMap());
    }

    private boolean referencesOperationsWithinModule(ComponentAst operationComponentModel) {
        return TNS_PREFIX.equals(operationComponentModel.getIdentifier().getNamespace());
    }

    private Optional<OperationModel> lookForTNSOperation(ComponentAst componentModel) {
        if (this.referencesOperationsWithinModule(componentModel)) {
            return componentModel.getModel(OperationModel.class);
        }
        return Optional.empty();
    }
}

