/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.extension.internal.loader;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Sets;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.TreeSet;
import java.util.function.Supplier;
import java.util.function.UnaryOperator;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.xml.namespace.QName;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import org.apache.commons.io.IOUtils;
import org.apache.commons.io.output.ByteArrayOutputStream;
import org.jgrapht.Graph;
import org.jgrapht.alg.cycle.CycleDetector;
import org.jgrapht.graph.DefaultDirectedGraph;
import org.jgrapht.graph.DefaultEdge;
import org.mule.metadata.api.builder.BaseTypeBuilder;
import org.mule.metadata.api.model.MetadataFormat;
import org.mule.metadata.api.model.MetadataType;
import org.mule.metadata.catalog.api.PrimitiveTypesTypeLoader;
import org.mule.metadata.catalog.api.TypeResolver;
import org.mule.metadata.catalog.api.TypeResolverException;
import org.mule.runtime.api.component.ComponentIdentifier;
import org.mule.runtime.api.dsl.DslResolvingContext;
import org.mule.runtime.api.exception.MuleRuntimeException;
import org.mule.runtime.api.i18n.I18nMessageFactory;
import org.mule.runtime.api.meta.Category;
import org.mule.runtime.api.meta.model.ExtensionModel;
import org.mule.runtime.api.meta.model.ModelProperty;
import org.mule.runtime.api.meta.model.XmlDslModel;
import org.mule.runtime.api.meta.model.config.ConfigurationModel;
import org.mule.runtime.api.meta.model.connection.ConnectionManagementType;
import org.mule.runtime.api.meta.model.connection.ConnectionProviderModel;
import org.mule.runtime.api.meta.model.declaration.fluent.ConfigurationDeclarer;
import org.mule.runtime.api.meta.model.declaration.fluent.ConnectionProviderDeclarer;
import org.mule.runtime.api.meta.model.declaration.fluent.ExtensionDeclarer;
import org.mule.runtime.api.meta.model.declaration.fluent.HasOperationDeclarer;
import org.mule.runtime.api.meta.model.declaration.fluent.OperationDeclaration;
import org.mule.runtime.api.meta.model.declaration.fluent.OperationDeclarer;
import org.mule.runtime.api.meta.model.declaration.fluent.OutputDeclarer;
import org.mule.runtime.api.meta.model.declaration.fluent.ParameterDeclarer;
import org.mule.runtime.api.meta.model.declaration.fluent.ParameterizedDeclarer;
import org.mule.runtime.api.meta.model.deprecated.DeprecationModel;
import org.mule.runtime.api.meta.model.display.DisplayModel;
import org.mule.runtime.api.meta.model.display.LayoutModel;
import org.mule.runtime.api.meta.model.error.ErrorModel;
import org.mule.runtime.api.meta.model.error.ErrorModelBuilder;
import org.mule.runtime.api.meta.model.operation.OperationModel;
import org.mule.runtime.api.meta.model.parameter.ParameterRole;
import org.mule.runtime.api.meta.model.parameter.ParameterizedModel;
import org.mule.runtime.api.util.LazyValue;
import org.mule.runtime.ast.api.ArtifactAst;
import org.mule.runtime.ast.api.ComponentAst;
import org.mule.runtime.ast.api.ComponentParameterAst;
import org.mule.runtime.ast.api.util.BaseComponentAstDecorator;
import org.mule.runtime.ast.api.util.MuleArtifactAstCopyUtils;
import org.mule.runtime.ast.api.xml.AstXmlParser;
import org.mule.runtime.config.api.properties.ConfigurationPropertiesResolver;
import org.mule.runtime.config.internal.dsl.model.ClassLoaderResourceProvider;
import org.mule.runtime.config.internal.dsl.model.config.DefaultConfigurationPropertiesResolver;
import org.mule.runtime.config.internal.dsl.model.config.DefaultConfigurationProperty;
import org.mule.runtime.config.internal.dsl.model.config.EnvironmentPropertiesConfigurationProvider;
import org.mule.runtime.config.internal.dsl.model.config.FileConfigurationPropertiesProvider;
import org.mule.runtime.config.internal.dsl.model.config.GlobalPropertyConfigurationPropertiesProvider;
import org.mule.runtime.config.internal.dsl.model.config.SystemPropertiesConfigurationProvider;
import org.mule.runtime.core.api.error.Errors;
import org.mule.runtime.core.api.util.StringUtils;
import org.mule.runtime.extension.api.exception.IllegalModelDefinitionException;
import org.mule.runtime.extension.api.exception.IllegalParameterModelDefinitionException;
import org.mule.runtime.extension.api.extension.XmlSdk1ExtensionModelProvider;
import org.mule.runtime.extension.api.loader.ExtensionLoadingContext;
import org.mule.runtime.extension.api.loader.ExtensionModelLoadingRequest;
import org.mule.runtime.extension.api.loader.xml.declaration.DeclarationOperation;
import org.mule.runtime.extension.api.model.operation.ImmutableOperationModel;
import org.mule.runtime.extension.api.property.XmlExtensionModelProperty;
import org.mule.runtime.extension.api.util.XmlModelUtils;
import org.mule.runtime.extension.internal.ast.property.GlobalElementComponentModelModelProperty;
import org.mule.runtime.extension.internal.ast.property.OperationComponentModelModelProperty;
import org.mule.runtime.extension.internal.ast.property.PrivateOperationsModelProperty;
import org.mule.runtime.extension.internal.ast.property.TestConnectionGlobalElementModelProperty;
import org.mule.runtime.extension.internal.loader.DefaultExtensionLoadingContext;
import org.mule.runtime.extension.internal.loader.ExtensionModelFactory;
import org.mule.runtime.extension.internal.loader.ForTnsTransformerFactory;
import org.mule.runtime.extension.internal.loader.validator.property.InvalidTestConnectionMarkerModelProperty;
import org.mule.runtime.extension.internal.property.NoReconnectionStrategyModelProperty;
import org.mule.runtime.internal.dsl.NullDslResolvingContext;
import org.mule.runtime.module.extension.internal.runtime.exception.ErrorMappingUtils;
import org.mule.runtime.properties.api.ConfigurationPropertiesProvider;
import org.mule.runtime.properties.api.ResourceProvider;
import org.vibur.objectpool.ConcurrentPool;
import org.vibur.objectpool.PoolObjectFactory;
import org.vibur.objectpool.PoolService;
import org.vibur.objectpool.util.ConcurrentCollection;
import org.vibur.objectpool.util.ConcurrentLinkedQueueCollection;

public final class XmlExtensionLoaderDelegate {
    public static final String CYCLIC_OPERATIONS_ERROR = "Cyclic operations detected, offending ones: [%s]";
    private static final String RAISE_ERROR = "raise-error";
    private static final ComponentIdentifier RAISE_ERROR_IDENTIFIER = ComponentIdentifier.builder().namespace("mule").name("raise-error").build();
    public static final String GLOBAL_PROPERTY = "global-property";
    private static final String PARAMETER_NAME = "name";
    private static final String PARAMETER_DEFAULT_VALUE = "defaultValue";
    private static final String TYPE_ATTRIBUTE = "type";
    private static final String MODULE_NAME = "name";
    private static final String MODULE_NAMESPACE_NAME = "module";
    protected static final String CONFIG_NAME = "config";
    private static final Map<String, ParameterRole> parameterRoleTypes = ImmutableMap.builder().put((Object)"BEHAVIOUR", (Object)ParameterRole.BEHAVIOUR).put((Object)"CONTENT", (Object)ParameterRole.CONTENT).put((Object)"PRIMARY", (Object)ParameterRole.PRIMARY_CONTENT).build();
    private static final String CATEGORY = "category";
    private static final String VENDOR = "vendor";
    private static final String PASSWORD = "password";
    private static final String ORDER_ATTRIBUTE = "order";
    private static final String TAB_ATTRIBUTE = "tab";
    private static final String DISPLAY_NAME_ATTRIBUTE = "displayName";
    private static final String SUMMARY_ATTRIBUTE = "summary";
    private static final String EXAMPLE_ATTRIBUTE = "example";
    private static final String ERROR_TYPE_ATTRIBUTE = "type";
    private static final String ROLE = "role";
    private static final String ATTRIBUTE_USE = "use";
    private static final String ATTRIBUTE_VISIBILITY = "visibility";
    private static final String NAMESPACE_SEPARATOR = ":";
    private static final String XMLNS_TNS = "xmlns:tns";
    private static final QName MODULE_CONNECTION_MARKER_ANNOTATION_QNAME = new QName("http://www.w3.org/2000/xmlns/", "connection", "xmlns");
    public static final String MODULE_CONNECTION_MARKER_ANNOTATION_ATTRIBUTE = MODULE_CONNECTION_MARKER_ANNOTATION_QNAME.getPrefix() + ":" + MODULE_CONNECTION_MARKER_ANNOTATION_QNAME.getLocalPart();
    private static final String GLOBAL_ELEMENT_NAME_ATTRIBUTE = "name";
    private static final ComponentIdentifier OPERATION_IDENTIFIER = ComponentIdentifier.builder().namespace("module").name("operation").build();
    private static final ComponentIdentifier OPERATION_PROPERTY_IDENTIFIER = ComponentIdentifier.builder().namespace("module").name("property").build();
    private static final ComponentIdentifier CONNECTION_PROPERTIES_IDENTIFIER = ComponentIdentifier.builder().namespace("module").name("connection").build();
    private static final ComponentIdentifier OPERATION_PARAMETERS_IDENTIFIER = ComponentIdentifier.builder().namespace("module").name("parameters").build();
    private static final ComponentIdentifier OPERATION_PARAMETER_IDENTIFIER = ComponentIdentifier.builder().namespace("module").name("parameter").build();
    private static final ComponentIdentifier OPERATION_BODY_IDENTIFIER = ComponentIdentifier.builder().namespace("module").name("body").build();
    private static final ComponentIdentifier OPERATION_OUTPUT_IDENTIFIER = ComponentIdentifier.builder().namespace("module").name("output").build();
    private static final ComponentIdentifier OPERATION_OUTPUT_ATTRIBUTES_IDENTIFIER = ComponentIdentifier.builder().namespace("module").name("output-attributes").build();
    private static final ComponentIdentifier OPERATION_ERRORS_IDENTIFIER = ComponentIdentifier.builder().namespace("module").name("errors").build();
    private static final ComponentIdentifier OPERATION_ERROR_IDENTIFIER = ComponentIdentifier.builder().namespace("module").name("error").build();
    private static final ComponentIdentifier MODULE_IDENTIFIER = ComponentIdentifier.builder().namespace("module").name("module").build();
    public static final String XSD_SUFFIX = ".xsd";
    private static final String XML_SUFFIX = ".xml";
    private static final String TYPES_XML_SUFFIX = "-catalog.xml";
    private static final int FOR_TNS_XSTL_TRANSFORMER_POOL_MAX_SIZE = Math.max(1, Runtime.getRuntime().availableProcessors() / 2);
    private static final PoolService<Transformer> FOR_TNS_XSTL_TRANSFORMER_POOL = new ConcurrentPool((ConcurrentCollection)new ConcurrentLinkedQueueCollection(), (PoolObjectFactory)new ForTnsTransformerFactory(), 1, FOR_TNS_XSTL_TRANSFORMER_POOL_MAX_SIZE, false);
    private static final Set<ComponentIdentifier> NOT_GLOBAL_ELEMENT_IDENTIFIERS = Sets.newHashSet((Object[])new ComponentIdentifier[]{OPERATION_PROPERTY_IDENTIFIER, CONNECTION_PROPERTIES_IDENTIFIER, OPERATION_IDENTIFIER});
    private final String modulePath;
    private final boolean validateXml;
    private final Optional<String> declarationPath;
    private final List<String> resourcesPaths;
    private TypeResolver typeResolver;
    private Map<String, DeclarationOperation> declarationMap;

    private static ParameterRole getRole(String role) {
        if (!parameterRoleTypes.containsKey(role)) {
            throw new IllegalParameterModelDefinitionException(String.format("The parametrized role [%s] doesn't match any of the expected types [%s]", role, String.join((CharSequence)", ", parameterRoleTypes.keySet())));
        }
        return parameterRoleTypes.get(role);
    }

    public XmlExtensionLoaderDelegate(String modulePath, boolean validateXml, Optional<String> declarationPath, List<String> resourcesPaths) {
        Preconditions.checkArgument((!StringUtils.isEmpty((String)modulePath) ? 1 : 0) != 0, (Object)"modulePath must not be empty");
        this.modulePath = modulePath;
        this.validateXml = validateXml;
        this.declarationPath = declarationPath;
        this.resourcesPaths = resourcesPaths;
    }

    public void declare(ExtensionLoadingContext context) {
        URL resource = this.getResource(this.modulePath);
        if (resource == null) {
            throw new IllegalArgumentException(String.format("There's no reachable XML in the path '%s'", this.modulePath));
        }
        try {
            this.loadCustomTypes();
        }
        catch (Exception e) {
            throw new IllegalArgumentException(String.format("The custom type file [%s] for the module '%s' cannot be read properly", this.getCustomTypeFilename(), this.modulePath), e);
        }
        this.loadDeclaration();
        HashSet<ExtensionModel> loaderExtensions = new HashSet<ExtensionModel>(context.getDslResolvingContext().getExtensions());
        loaderExtensions.add(XmlSdk1ExtensionModelProvider.getExtensionModel());
        HashSet<ExtensionModel> extensions = new HashSet<ExtensionModel>(loaderExtensions);
        try {
            this.createTnsExtensionModel(resource, loaderExtensions).ifPresent(extensions::add);
        }
        catch (IOException e) {
            throw new MuleRuntimeException(I18nMessageFactory.createStaticMessage((String)String.format("There was an issue reading the stream for the resource %s", resource.getFile())));
        }
        ArtifactAst moduleAst = this.getModuleDocument(extensions, resource);
        this.loadModuleExtension(context.getExtensionDeclarer(), moduleAst, false);
    }

    private URL getResource(String resource) {
        return Thread.currentThread().getContextClassLoader().getResource(resource);
    }

    private void loadCustomTypes() {
        String customTypes = this.getCustomTypeFilename();
        URL resourceCustomType = this.getResource(customTypes);
        this.typeResolver = resourceCustomType != null ? TypeResolver.createFrom((URL)resourceCustomType, (ClassLoader)Thread.currentThread().getContextClassLoader()) : this.getEmptyTypeResolver();
    }

    private TypeResolver getEmptyTypeResolver() {
        return TypeResolver.create((ClassLoader)Thread.currentThread().getContextClassLoader());
    }

    private String getCustomTypeFilename() {
        return this.modulePath.replace(XML_SUFFIX, TYPES_XML_SUFFIX);
    }

    private void loadDeclaration() {
        this.declarationMap = new HashMap<String, DeclarationOperation>();
        this.declarationPath.ifPresent(operationsOutputPathValue -> {
            URL operationsOutputResource = this.getResource((String)operationsOutputPathValue);
            if (operationsOutputResource != null) {
                try {
                    this.declarationMap = DeclarationOperation.fromString(IOUtils.toString((URL)operationsOutputResource, (Charset)StandardCharsets.UTF_8));
                }
                catch (IOException e) {
                    throw new IllegalArgumentException(String.format("The declarations file [%s] for the module '%s' cannot be read properly", operationsOutputPathValue, this.modulePath), e);
                }
            }
        });
    }

    private ArtifactAst getModuleDocument(Set<ExtensionModel> extensions, URL resource) {
        AstXmlParser.Builder parserBuilder = AstXmlParser.builder().withExtensionModels(extensions);
        if (!this.validateXml) {
            parserBuilder = parserBuilder.withSchemaValidationsDisabled();
        }
        AstXmlParser xmlToAstParser = parserBuilder.build();
        return xmlToAstParser.parse(new URL[]{resource});
    }

    private Optional<ExtensionModel> createTnsExtensionModel(URL resource, Set<ExtensionModel> extensionModels) throws IOException {
        ByteArrayOutputStream resultStream = new ByteArrayOutputStream();
        Transformer transformer = (Transformer)FOR_TNS_XSTL_TRANSFORMER_POOL.take();
        try (BufferedInputStream resourceIS = new BufferedInputStream(resource.openStream());){
            transformer.transform(new StreamSource(resourceIS), new StreamResult((OutputStream)resultStream));
        }
        catch (TransformerException e) {
            throw new MuleRuntimeException(I18nMessageFactory.createStaticMessage((String)String.format("There was an issue transforming the stream for the resource %s while trying to remove the content of the <body> element to generate an XSD", resource.getFile())), (Throwable)e);
        }
        finally {
            FOR_TNS_XSTL_TRANSFORMER_POOL.restore((Object)transformer);
        }
        ExtensionDeclarer extensionDeclarer = new ExtensionDeclarer();
        AstXmlParser xmlToAstParser = AstXmlParser.builder().withExtensionModels(extensionModels).withSchemaValidationsDisabled().build();
        ArtifactAst transformedModuleAst = xmlToAstParser.parse("transformed_" + resource.getFile(), resultStream.toInputStream());
        if (transformedModuleAst.namespaceDefinition().getUnresovedNamespaces().containsKey(XMLNS_TNS)) {
            this.loadModuleExtension(extensionDeclarer, transformedModuleAst, true);
            return Optional.of(this.createExtensionModel(extensionDeclarer));
        }
        return Optional.empty();
    }

    private ComponentAst getModuleComponentModel(ArtifactAst moduleAst) {
        moduleAst.updatePropertiesResolver((UnaryOperator)this.getConfigurationPropertiesResolver(moduleAst));
        return moduleAst.topLevelComponentsStream().filter(c -> MODULE_IDENTIFIER.equals(c.getIdentifier())).findFirst().orElseThrow(() -> new MuleRuntimeException(I18nMessageFactory.createStaticMessage((String)String.format("The root element of a module must be '%s' but it wasn't found", MODULE_IDENTIFIER.toString()))));
    }

    private ConfigurationPropertiesResolver getConfigurationPropertiesResolver(ArtifactAst ast) {
        DefaultConfigurationPropertiesResolver globalPropertiesConfigurationPropertiesResolver = new DefaultConfigurationPropertiesResolver(Optional.of(new XmlExtensionConfigurationPropertiesResolver()), this.createProviderFromGlobalProperties(ast));
        DefaultConfigurationPropertiesResolver envVariablesResolver = new DefaultConfigurationPropertiesResolver(Optional.of(globalPropertiesConfigurationPropertiesResolver), (ConfigurationPropertiesProvider)new EnvironmentPropertiesConfigurationProvider());
        DefaultConfigurationPropertiesResolver systemPropertiesResolver = new DefaultConfigurationPropertiesResolver(Optional.of(envVariablesResolver), (ConfigurationPropertiesProvider)new SystemPropertiesConfigurationProvider());
        String description = String.format("External files for smart connector '%s'", this.modulePath);
        FileConfigurationPropertiesProvider externalPropertiesConfigurationProvider = new FileConfigurationPropertiesProvider((ResourceProvider)new ClassLoaderResourceProvider(Thread.currentThread().getContextClassLoader()), description);
        return new DefaultConfigurationPropertiesResolver(Optional.of(systemPropertiesResolver), (ConfigurationPropertiesProvider)externalPropertiesConfigurationProvider);
    }

    private ConfigurationPropertiesProvider createProviderFromGlobalProperties(ArtifactAst ast) {
        return new GlobalPropertyConfigurationPropertiesProvider((Supplier)new LazyValue(() -> {
            HashMap globalProperties = new HashMap();
            ast.topLevelComponentsStream().flatMap(comp -> comp.directChildrenStream()).filter(comp -> GLOBAL_PROPERTY.equals(comp.getIdentifier().getName())).forEach(comp -> {
                String key = comp.getParameter("General", "name").getResolvedRawValue();
                String rawValue = comp.getParameter("General", "value").getRawValue();
                globalProperties.put(key, new DefaultConfigurationProperty((Object)String.format("global-property - file: %s - lineNumber %s", comp.getMetadata().getFileName().orElse("(n/a)"), comp.getMetadata().getStartLine().orElse(-1)), key, (Object)rawValue));
            });
            return globalProperties;
        }));
    }

    private static Optional<String> getStringParameter(ComponentAst componentAst, String parameterName) {
        return Optional.ofNullable(componentAst.getParameter("General", parameterName)).map(c -> (String)c.getValue().getRight());
    }

    private void loadModuleExtension(ExtensionDeclarer declarer, ArtifactAst artifactAst, boolean comesFromTNS) {
        ComponentAst moduleAst = this.getModuleComponentModel(artifactAst);
        String name = XmlExtensionLoaderDelegate.getStringParameter(moduleAst, "name").orElse(null);
        String version = "4.0.0";
        String category = XmlExtensionLoaderDelegate.getStringParameter(moduleAst, CATEGORY).orElse("COMMUNITY");
        String vendor = XmlExtensionLoaderDelegate.getStringParameter(moduleAst, VENDOR).orElse("MuleSoft");
        XmlDslModel xmlDslModel = comesFromTNS ? this.getTnsXmlDslModel(artifactAst, name, "4.0.0") : this.getXmlDslModel(artifactAst, name, "4.0.0");
        String description = this.getDescription(moduleAst);
        String xmlnsTnsValue = artifactAst.namespaceDefinition().getUnresovedNamespaces().getOrDefault(XMLNS_TNS, null);
        if (!comesFromTNS && xmlnsTnsValue != null && !xmlDslModel.getNamespace().equals(xmlnsTnsValue)) {
            throw new MuleRuntimeException(I18nMessageFactory.createStaticMessage((String)String.format("The %s attribute value of the module must be '%s', but found '%s'", XMLNS_TNS, xmlDslModel.getNamespace(), xmlnsTnsValue)));
        }
        this.resourcesPaths.stream().forEach(arg_0 -> ((ExtensionDeclarer)declarer).withResource(arg_0));
        this.fillDeclarer(declarer, name, "4.0.0", category, vendor, xmlDslModel, description);
        declarer.withModelProperty((ModelProperty)this.getXmlExtensionModelProperty(artifactAst, xmlDslModel));
        DefaultDirectedGraph directedGraph = new DefaultDirectedGraph(DefaultEdge.class);
        List<ComponentAst> globalElementsComponentModel = this.extractGlobalElementsFrom(moduleAst);
        this.addGlobalElementModelProperty(declarer, globalElementsComponentModel);
        Optional<ConfigurationDeclarer> configurationDeclarer = this.loadPropertiesFrom(declarer, moduleAst, globalElementsComponentModel);
        HasOperationDeclarer hasOperationDeclarer = configurationDeclarer.map(d -> d).orElse((HasOperationDeclarer)declarer);
        ExtensionDeclarer temporalPublicOpsDeclarer = new ExtensionDeclarer();
        this.fillDeclarer(temporalPublicOpsDeclarer, name, "4.0.0", category, vendor, xmlDslModel, description);
        this.loadOperationsFrom(Optional.empty(), (HasOperationDeclarer)temporalPublicOpsDeclarer, moduleAst, (Graph<String, DefaultEdge>)directedGraph, xmlDslModel, OperationVisibility.PUBLIC, Optional.empty());
        this.validateNoCycles((Graph<String, DefaultEdge>)directedGraph);
        try {
            moduleAst = this.enrichRecursively(moduleAst, this.createExtensionModel(temporalPublicOpsDeclarer));
        }
        catch (IllegalModelDefinitionException illegalModelDefinitionException) {
            // empty catch block
        }
        if (comesFromTNS) {
            this.loadOperationsFrom(Optional.empty(), hasOperationDeclarer, moduleAst, (Graph<String, DefaultEdge>)directedGraph, xmlDslModel, OperationVisibility.PRIVATE, Optional.empty());
        } else {
            ExtensionDeclarer temporalPrivateOpsDeclarer = new ExtensionDeclarer();
            this.fillDeclarer(temporalPrivateOpsDeclarer, name, "4.0.0", category, vendor, xmlDslModel, description);
            this.loadOperationsFrom(Optional.empty(), (HasOperationDeclarer)temporalPrivateOpsDeclarer, moduleAst, (Graph<String, DefaultEdge>)directedGraph, xmlDslModel, OperationVisibility.PRIVATE, Optional.empty());
            ExtensionModel privateTnsExtensionModel = this.createExtensionModel(temporalPrivateOpsDeclarer);
            moduleAst = this.enrichRecursively(moduleAst, privateTnsExtensionModel);
            PrivateOperationsModelProperty privateOperations = new PrivateOperationsModelProperty(privateTnsExtensionModel.getOperationModels());
            declarer.withModelProperty((ModelProperty)privateOperations);
        }
        this.validateNoCycles((Graph<String, DefaultEdge>)directedGraph);
        ExtensionDeclarer temporalAllOpsDeclarer = new ExtensionDeclarer();
        this.fillDeclarer(temporalAllOpsDeclarer, name, "4.0.0", category, vendor, xmlDslModel, description);
        this.loadOperationsFrom(Optional.empty(), (HasOperationDeclarer)temporalAllOpsDeclarer, moduleAst, (Graph<String, DefaultEdge>)directedGraph, xmlDslModel, OperationVisibility.PRIVATE, Optional.empty());
        this.loadOperationsFrom(Optional.empty(), (HasOperationDeclarer)temporalAllOpsDeclarer, moduleAst, (Graph<String, DefaultEdge>)directedGraph, xmlDslModel, OperationVisibility.PUBLIC, Optional.empty());
        Optional<ExtensionModel> allTnsExtensionModel = Optional.empty();
        try {
            allTnsExtensionModel = Optional.of(this.createExtensionModel(temporalAllOpsDeclarer));
        }
        catch (IllegalModelDefinitionException illegalModelDefinitionException) {
            // empty catch block
        }
        this.loadOperationsFrom(Optional.of(declarer), hasOperationDeclarer, moduleAst, (Graph<String, DefaultEdge>)directedGraph, xmlDslModel, OperationVisibility.PUBLIC, allTnsExtensionModel);
    }

    private void validateNoCycles(Graph<String, DefaultEdge> directedGraph) {
        CycleDetector cycleDetector = new CycleDetector(directedGraph);
        Set cycles = cycleDetector.findCycles();
        if (!cycles.isEmpty()) {
            throw new MuleRuntimeException(I18nMessageFactory.createStaticMessage((String)String.format(CYCLIC_OPERATIONS_ERROR, new TreeSet(cycles))));
        }
    }

    private ComponentAst enrichRecursively(ComponentAst moduleAst, ExtensionModel result) {
        return MuleArtifactAstCopyUtils.copyComponentTreeRecursively((ComponentAst)moduleAst, comp -> {
            if ("tns".equals(comp.getIdentifier().getNamespace())) {
                final Optional<OperationModel> enrichedOperationModel = result.getOperationModel(comp.getIdentifier().getName()).filter(model -> OperationModel.class.isAssignableFrom(model.getClass())).map(model -> this.enrichOperationModel((OperationModel)model, result));
                return new BaseComponentAstDecorator((ComponentAst)comp, (ComponentAst)comp){
                    final /* synthetic */ ComponentAst val$comp;
                    {
                        this.val$comp = componentAst;
                        super(x0);
                    }

                    public <M> Optional<M> getModel(Class<M> modelClass) {
                        return enrichedOperationModel.isPresent() && OperationModel.class.isAssignableFrom(modelClass) ? enrichedOperationModel : this.val$comp.getModel(modelClass);
                    }
                };
            }
            return comp;
        });
    }

    private OperationModel enrichOperationModel(OperationModel model, ExtensionModel result) {
        Set enrichedModelProperties = model.getModelProperties().stream().map(mp -> {
            if (mp instanceof OperationComponentModelModelProperty) {
                OperationComponentModelModelProperty ocm = (OperationComponentModelModelProperty)mp;
                return new OperationComponentModelModelProperty(this.enrichRecursively(ocm.getOperationComponentModel(), result), this.enrichRecursively(ocm.getBodyComponentModel(), result));
            }
            return mp;
        }).collect(Collectors.toSet());
        if (model instanceof OperationModel) {
            OperationModel opModel = model;
            return new ImmutableOperationModel(opModel.getName(), opModel.getDescription(), opModel.getParameterGroupModels(), opModel.getNestedComponents(), opModel.getOutput(), opModel.getOutputAttributes(), opModel.isBlocking(), opModel.getExecutionType(), opModel.requiresConnection(), opModel.isTransactional(), opModel.supportsStreaming(), (DisplayModel)opModel.getDisplayModel().orElse(null), opModel.getErrorModels(), opModel.getStereotype(), opModel.getVisibility(), enrichedModelProperties, opModel.getNotificationModels(), (DeprecationModel)opModel.getDeprecationModel().orElse(null));
        }
        return model;
    }

    private ExtensionModel createExtensionModel(ExtensionDeclarer declarer) {
        return new ExtensionModelFactory().create((ExtensionLoadingContext)new DefaultExtensionLoadingContext(declarer, ExtensionModelLoadingRequest.builder((ClassLoader)Thread.currentThread().getContextClassLoader(), (DslResolvingContext)new NullDslResolvingContext()).build()));
    }

    private void fillDeclarer(ExtensionDeclarer declarer, String name, String version, String category, String vendor, XmlDslModel xmlDslModel, String description) {
        declarer.named(name).describedAs(description).fromVendor(vendor).onVersion(version).withCategory(Category.valueOf((String)category.toUpperCase())).withXmlDsl(xmlDslModel);
    }

    private XmlExtensionModelProperty getXmlExtensionModelProperty(ArtifactAst moduleAst, XmlDslModel xmlDslModel) {
        return new XmlExtensionModelProperty(moduleAst.dependencies().stream().map(em -> em.getXmlDslModel().getNamespace()).filter(namespace -> !xmlDslModel.getNamespace().equals(namespace)).collect(Collectors.toSet()));
    }

    private XmlDslModel getTnsXmlDslModel(ArtifactAst moduleAst, String name, String version) {
        String namespace = (String)moduleAst.namespaceDefinition().getUnresovedNamespaces().get(XMLNS_TNS);
        String stringPrefix = "tns";
        Map schemaLocations = moduleAst.namespaceDefinition().getSchemaLocations();
        if (!schemaLocations.containsKey(namespace)) {
            return this.getXmlDslModel(moduleAst, name, version);
        }
        String[] tnsSchemaLocationParts = ((String)schemaLocations.get(namespace)).split("/");
        return XmlDslModel.builder().setSchemaVersion(version).setPrefix("tns").setNamespace(namespace).setSchemaLocation((String)schemaLocations.get(namespace)).setXsdFileName(tnsSchemaLocationParts[tnsSchemaLocationParts.length - 1]).build();
    }

    private XmlDslModel getXmlDslModel(ArtifactAst artifactAst, String name, String version) {
        Optional<String> prefix = Optional.ofNullable(artifactAst.namespaceDefinition().getPrefix());
        Optional<String> namespace = Optional.ofNullable(artifactAst.namespaceDefinition().getNamespace());
        return XmlModelUtils.createXmlLanguageModel(prefix, namespace, (String)name, (String)version);
    }

    private String getDescription(ComponentAst moduleAst) {
        return moduleAst.getMetadata().getDocAttributes().getOrDefault("description", "");
    }

    private List<ComponentAst> extractGlobalElementsFrom(ComponentAst moduleAst) {
        return moduleAst.directChildrenStream().filter(child -> !NOT_GLOBAL_ELEMENT_IDENTIFIERS.contains(child.getIdentifier())).collect(Collectors.toList());
    }

    private Optional<ConfigurationDeclarer> loadPropertiesFrom(ExtensionDeclarer declarer, ComponentAst moduleAst, List<ComponentAst> globalElementsComponentModel) {
        List<ComponentAst> configurationProperties = this.extractProperties(moduleAst);
        List<ComponentAst> connectionProperties = this.extractConnectionProperties(moduleAst);
        this.validateProperties(configurationProperties, connectionProperties);
        if (!configurationProperties.isEmpty() || !connectionProperties.isEmpty()) {
            declarer.withModelProperty((ModelProperty)new NoReconnectionStrategyModelProperty());
            ConfigurationDeclarer configurationDeclarer = declarer.withConfig(CONFIG_NAME);
            configurationProperties.forEach(param -> this.extractProperty((ParameterizedDeclarer)configurationDeclarer, (ComponentAst)param));
            this.addConnectionProvider(configurationDeclarer, connectionProperties, globalElementsComponentModel);
            return Optional.of(configurationDeclarer);
        }
        return Optional.empty();
    }

    private void addGlobalElementModelProperty(ExtensionDeclarer declarer, List<ComponentAst> globalElementsComponentModel) {
        if (!globalElementsComponentModel.isEmpty()) {
            declarer.withModelProperty((ModelProperty)new GlobalElementComponentModelModelProperty(globalElementsComponentModel));
        }
    }

    private List<ComponentAst> extractProperties(ComponentAst moduleAst) {
        return moduleAst.directChildrenStream().filter(child -> child.getIdentifier().equals(OPERATION_PROPERTY_IDENTIFIER)).collect(Collectors.toList());
    }

    private List<ComponentAst> extractConnectionProperties(ComponentAst moduleAst) {
        List connectionsComponentModel = moduleAst.directChildrenStream().filter(child -> child.getIdentifier().equals(CONNECTION_PROPERTIES_IDENTIFIER)).collect(Collectors.toList());
        if (connectionsComponentModel.size() > 1) {
            throw new MuleRuntimeException(I18nMessageFactory.createStaticMessage((String)String.format("There cannot be more than 1 child [%s] element per [%s], found [%d]", CONNECTION_PROPERTIES_IDENTIFIER.getName(), MODULE_IDENTIFIER.getName(), connectionsComponentModel.size())));
        }
        return connectionsComponentModel.isEmpty() ? Collections.emptyList() : this.extractProperties((ComponentAst)connectionsComponentModel.get(0));
    }

    private void validateProperties(List<ComponentAst> configurationProperties, List<ComponentAst> connectionProperties) {
        List connectionPropertiesNames = connectionProperties.stream().map(ComponentAst::getComponentId).filter(Optional::isPresent).map(Optional::get).collect(Collectors.toList());
        List intersectedProperties = configurationProperties.stream().map(ComponentAst::getComponentId).filter(Optional::isPresent).map(Optional::get).filter(connectionPropertiesNames::contains).collect(Collectors.toList());
        if (!intersectedProperties.isEmpty()) {
            throw new MuleRuntimeException(I18nMessageFactory.createStaticMessage((String)String.format("There cannot be properties with the same name even if they are within a <connection>, repeated properties are: [%s]", intersectedProperties.stream().collect(Collectors.joining(", ")))));
        }
    }

    private void addConnectionProvider(ConfigurationDeclarer configurationDeclarer, List<ComponentAst> connectionProperties, List<ComponentAst> globalElementsComponentModel) {
        Optional<ComponentAst> testConnectionGlobalElementOptional = this.getTestConnectionGlobalElement(configurationDeclarer, globalElementsComponentModel);
        if (testConnectionGlobalElementOptional.isPresent() || !connectionProperties.isEmpty()) {
            ConnectionProviderDeclarer connectionProviderDeclarer = configurationDeclarer.withConnectionProvider("connection");
            connectionProviderDeclarer.withConnectionManagementType(ConnectionManagementType.NONE);
            connectionProperties.stream().forEach(param -> this.extractProperty((ParameterizedDeclarer)connectionProviderDeclarer, (ComponentAst)param));
            testConnectionGlobalElementOptional.flatMap(testConnectionGlobalElement -> testConnectionGlobalElement.getParameter("General", "name").getValue().getValue()).ifPresent(testConnectionGlobalElementName -> connectionProviderDeclarer.withModelProperty((ModelProperty)new TestConnectionGlobalElementModelProperty((String)testConnectionGlobalElementName)));
        }
    }

    private Optional<ComponentAst> getTestConnectionGlobalElement(ConfigurationDeclarer configurationDeclarer, List<ComponentAst> globalElementsComponentModel) {
        List markedAsTestConnectionGlobalElements = globalElementsComponentModel.stream().filter(globalElementComponentModel -> {
            Object connection = globalElementComponentModel.getAnnotations().get(MODULE_CONNECTION_MARKER_ANNOTATION_QNAME.toString());
            if (connection == null) {
                return false;
            }
            return Boolean.parseBoolean(connection.toString());
        }).collect(Collectors.toList());
        if (markedAsTestConnectionGlobalElements.size() > 1) {
            throw new MuleRuntimeException(I18nMessageFactory.createStaticMessage((String)String.format("It can only be one global element marked as test connectivity [%s] but found [%d], offended global elements are: [%s]", MODULE_CONNECTION_MARKER_ANNOTATION_ATTRIBUTE, markedAsTestConnectionGlobalElements.size(), markedAsTestConnectionGlobalElements.stream().map(ComponentAst::getComponentId).filter(Optional::isPresent).map(Optional::get).collect(Collectors.joining(", ")))));
        }
        Optional<Object> testConnectionGlobalElement = markedAsTestConnectionGlobalElements.stream().findFirst();
        if (!testConnectionGlobalElement.isPresent()) {
            testConnectionGlobalElement = this.findTestConnectionGlobalElementFrom(globalElementsComponentModel);
        } else {
            Optional<ComponentAst> temporalTestConnectionGlobalElement = this.findTestConnectionGlobalElementFrom(Collections.singletonList(testConnectionGlobalElement.get()));
            if (!temporalTestConnectionGlobalElement.isPresent() || !temporalTestConnectionGlobalElement.get().equals(testConnectionGlobalElement.get())) {
                configurationDeclarer.withModelProperty((ModelProperty)new InvalidTestConnectionMarkerModelProperty(testConnectionGlobalElement.flatMap(ComponentAst::getComponentId).orElse(null), testConnectionGlobalElement.get().getIdentifier().toString()));
            }
        }
        return testConnectionGlobalElement;
    }

    private Optional<ComponentAst> findTestConnectionGlobalElementFrom(List<ComponentAst> globalElementsComponentModel) {
        List testConnectionComponentModels = globalElementsComponentModel.stream().filter(globalElementComponentModel -> globalElementComponentModel.getModel(ConfigurationModel.class).map(configurationModel -> configurationModel.getConnectionProviders().stream().anyMatch(ConnectionProviderModel::supportsConnectivityTesting)).orElse(false)).collect(Collectors.toList());
        if (testConnectionComponentModels.size() > 1) {
            throw new MuleRuntimeException(I18nMessageFactory.createStaticMessage((String)String.format("There are [%d] global elements that can be potentially used for test connection when it should be just one. Mark any of them with the attribute [%s=\"true\"], offended global elements are: [%s]", testConnectionComponentModels.size(), MODULE_CONNECTION_MARKER_ANNOTATION_ATTRIBUTE, testConnectionComponentModels.stream().map(ComponentAst::getComponentId).filter(Optional::isPresent).map(Optional::get).sorted().collect(Collectors.joining(", ")))));
        }
        return testConnectionComponentModels.stream().findFirst();
    }

    private void loadOperationsFrom(Optional<ExtensionDeclarer> extensionDeclarer, HasOperationDeclarer declarer, ComponentAst moduleAst, Graph<String, DefaultEdge> directedGraph, XmlDslModel xmlDslModel, OperationVisibility visibility, Optional<ExtensionModel> tnsExtensionModel) {
        moduleAst.directChildrenStream().filter(child -> child.getIdentifier().equals(OPERATION_IDENTIFIER)).filter(operationModel -> operationModel.getParameter("General", ATTRIBUTE_VISIBILITY).getValue().getRight().equals(visibility.toString())).forEach(operationModel -> this.extractOperationExtension(extensionDeclarer, declarer, (ComponentAst)operationModel, directedGraph, xmlDslModel, tnsExtensionModel));
    }

    private void extractOperationExtension(Optional<ExtensionDeclarer> extensionDeclarer, HasOperationDeclarer declarer, ComponentAst operationModel, Graph<String, DefaultEdge> directedGraph, XmlDslModel xmlDslModel, Optional<ExtensionModel> tnsExtensionModel) {
        String operationName = operationModel.getComponentId().orElse(null);
        OperationDeclarer operationDeclarer = declarer.withOperation(operationName);
        ComponentAst bodyComponentModel = operationModel.directChildrenStream().filter(child -> child.getIdentifier().equals(OPERATION_BODY_IDENTIFIER)).findFirst().orElseThrow(() -> new IllegalArgumentException(String.format("The operation '%s' is missing the <body> statement", operationName)));
        directedGraph.addVertex((Object)operationName);
        this.fillGraphWithTnsReferences(directedGraph, operationName, bodyComponentModel.directChildrenStream());
        if (tnsExtensionModel.isPresent()) {
            operationDeclarer.withModelProperty((ModelProperty)new OperationComponentModelModelProperty(this.enrichRecursively(operationModel, tnsExtensionModel.get()), this.enrichRecursively(bodyComponentModel, tnsExtensionModel.get())));
        } else {
            operationDeclarer.withModelProperty((ModelProperty)new OperationComponentModelModelProperty(operationModel, bodyComponentModel));
        }
        operationDeclarer.describedAs(this.getDescription(operationModel));
        ((OperationDeclaration)operationDeclarer.getDeclaration()).setDisplayModel(this.getDisplayModel(operationModel));
        this.extractOperationParameters(operationDeclarer, operationModel);
        this.extractOutputType(operationDeclarer.withOutput(), OPERATION_OUTPUT_IDENTIFIER, operationModel, this.getDeclarationOutputFor(operationName));
        this.extractOutputType(operationDeclarer.withOutputAttributes(), OPERATION_OUTPUT_ATTRIBUTES_IDENTIFIER, operationModel, this.getDeclarationOutputAttributesFor(operationName));
        this.declareErrorModels(extensionDeclarer, operationDeclarer, xmlDslModel, operationName, operationModel);
    }

    private Optional<MetadataType> getDeclarationOutputFor(String operationName) {
        Optional<MetadataType> result = Optional.empty();
        if (this.declarationMap.containsKey(operationName)) {
            result = Optional.of(this.declarationMap.get(operationName).getOutput());
        }
        return result;
    }

    private Optional<MetadataType> getDeclarationOutputAttributesFor(String operationName) {
        Optional<MetadataType> result = Optional.empty();
        if (this.declarationMap.containsKey(operationName)) {
            result = Optional.of(this.declarationMap.get(operationName).getOutputAttributes());
        }
        return result;
    }

    private void fillGraphWithTnsReferences(Graph<String, DefaultEdge> directedGraph, String sourceOperationVertex, Stream<ComponentAst> innerComponents) {
        innerComponents.forEach(childMPComponentModel -> {
            if ("tns".equals(childMPComponentModel.getIdentifier().getNamespace())) {
                String targetOperationVertex = childMPComponentModel.getIdentifier().getName();
                if (!directedGraph.containsVertex((Object)targetOperationVertex)) {
                    directedGraph.addVertex((Object)targetOperationVertex);
                }
                directedGraph.addEdge((Object)sourceOperationVertex, (Object)targetOperationVertex);
            } else {
                childMPComponentModel.directChildrenStream().forEach(childChildMPComponentModel -> this.fillGraphWithTnsReferences(directedGraph, sourceOperationVertex, childMPComponentModel.directChildrenStream()));
            }
        });
    }

    private void extractOperationParameters(OperationDeclarer operationDeclarer, ComponentAst componentModel) {
        Optional<ComponentAst> optionalParametersComponentModel = componentModel.directChildrenStream().filter(child -> child.getIdentifier().equals(OPERATION_PARAMETERS_IDENTIFIER)).findAny();
        if (optionalParametersComponentModel.isPresent()) {
            optionalParametersComponentModel.get().directChildrenStream().filter(child -> child.getIdentifier().equals(OPERATION_PARAMETER_IDENTIFIER)).forEach(param -> {
                String role = param.getParameter("General", ROLE).getValue().getRight().toString();
                this.extractParameter((ParameterizedDeclarer)operationDeclarer, (ComponentAst)param, XmlExtensionLoaderDelegate.getRole(role));
            });
        }
    }

    private void extractProperty(ParameterizedDeclarer parameterizedDeclarer, ComponentAst param) {
        this.extractParameter(parameterizedDeclarer, param, ParameterRole.BEHAVIOUR);
    }

    private void extractParameter(ParameterizedDeclarer parameterizedDeclarer, ComponentAst param, ParameterRole role) {
        LayoutModel.LayoutModelBuilder layoutModelBuilder = LayoutModel.builder();
        param.getParameter("General", PASSWORD).getValue().getValue().filter(v -> (Boolean)v).ifPresent(value -> layoutModelBuilder.asPassword());
        param.getParameter("General", ORDER_ATTRIBUTE).getValue().getValue().ifPresent(value -> layoutModelBuilder.order(((Integer)value).intValue()));
        param.getParameter("General", TAB_ATTRIBUTE).getValue().getValue().ifPresent(value -> layoutModelBuilder.tabName((String)value));
        param.getParameter("General", "type").getValue().getValue().ifPresent(receivedInputType -> {
            DisplayModel displayModel = this.getDisplayModel(param);
            MetadataType parameterType = this.extractType((String)receivedInputType);
            ParameterDeclarer parameterDeclarer = this.getParameterDeclarer(parameterizedDeclarer, param);
            parameterDeclarer.describedAs(this.getDescription(param)).withLayout(layoutModelBuilder.build()).withDisplayModel(displayModel).withRole(role).ofType(parameterType);
        });
    }

    private DisplayModel getDisplayModel(ComponentAst componentModel) {
        DisplayModel.DisplayModelBuilder displayModelBuilder = DisplayModel.builder();
        componentModel.getParameter("General", DISPLAY_NAME_ATTRIBUTE).getValue().getValue().ifPresent(value -> displayModelBuilder.displayName((String)value));
        componentModel.getParameter("General", SUMMARY_ATTRIBUTE).getValue().getValue().ifPresent(value -> displayModelBuilder.summary((String)value));
        componentModel.getParameter("General", EXAMPLE_ATTRIBUTE).getValue().getValue().ifPresent(value -> displayModelBuilder.example((String)value));
        return displayModelBuilder.build();
    }

    private ParameterDeclarer getParameterDeclarer(ParameterizedDeclarer parameterizedDeclarer, ComponentAst param) {
        String parameterName = param.getParameter("General", "name").getRawValue();
        Optional parameterDefaultValue = param.getParameter("General", PARAMETER_DEFAULT_VALUE).getValue().mapLeft(expr -> "#[" + expr + "]").getValue();
        UseEnum use = UseEnum.valueOf(param.getParameter("General", ATTRIBUTE_USE).getValue().getRight().toString());
        if (UseEnum.REQUIRED.equals((Object)use) && parameterDefaultValue.isPresent()) {
            throw new IllegalParameterModelDefinitionException(String.format("The parameter [%s] cannot have the %s attribute set to %s when it has a default value", new Object[]{parameterName, ATTRIBUTE_USE, UseEnum.REQUIRED}));
        }
        boolean parameterRequired = UseEnum.REQUIRED.equals((Object)use) || UseEnum.AUTO.equals((Object)use) && !parameterDefaultValue.isPresent();
        return parameterRequired ? parameterizedDeclarer.onDefaultParameterGroup().withRequiredParameter(parameterName) : parameterizedDeclarer.onDefaultParameterGroup().withOptionalParameter(parameterName).defaultingTo(parameterDefaultValue.orElse(null));
    }

    private void extractOutputType(OutputDeclarer outputDeclarer, ComponentIdentifier componentIdentifier, ComponentAst operationModel, Optional<MetadataType> calculatedOutput) {
        Optional<ComponentAst> outputAttributesComponentModel = operationModel.directChildrenStream().filter(child -> child.getIdentifier().equals(componentIdentifier)).findFirst();
        outputAttributesComponentModel.ifPresent(outputComponentModel -> outputDeclarer.describedAs(this.getDescription((ComponentAst)outputComponentModel)));
        MetadataType metadataType = this.getMetadataType(outputAttributesComponentModel, calculatedOutput);
        outputDeclarer.ofType(metadataType);
    }

    private MetadataType getMetadataType(Optional<ComponentAst> outputAttributesComponentModel, Optional<MetadataType> declarationMetadataType) {
        MetadataType metadataType;
        if (declarationMetadataType.isPresent()) {
            metadataType = declarationMetadataType.get();
        } else if (outputAttributesComponentModel.isPresent()) {
            String receivedOutputAttributeType = XmlExtensionLoaderDelegate.getStringParameter(outputAttributesComponentModel.get(), "type").orElse(null);
            metadataType = this.extractType(receivedOutputAttributeType);
        } else {
            metadataType = BaseTypeBuilder.create((MetadataFormat)MetadataFormat.JAVA).voidType().build();
        }
        return metadataType;
    }

    private MetadataType extractType(String receivedType) {
        Optional metadataType;
        block3: {
            metadataType = Optional.empty();
            try {
                metadataType = this.typeResolver.resolveType(receivedType);
            }
            catch (TypeResolverException e) {
                if (metadataType.isPresent()) break block3;
                throw new IllegalParameterModelDefinitionException(String.format("The type obtained [%s] cannot be resolved", receivedType), (Throwable)e);
            }
        }
        if (!metadataType.isPresent()) {
            String errorMessage = String.format("should not have reach here. Type obtained [%s] when supported default types are [%s].", receivedType, String.join((CharSequence)", ", PrimitiveTypesTypeLoader.PRIMITIVE_TYPES.keySet()));
            throw new IllegalParameterModelDefinitionException(errorMessage);
        }
        return (MetadataType)metadataType.get();
    }

    private void declareErrorModels(Optional<ExtensionDeclarer> extensionDeclarer, OperationDeclarer operationDeclarer, XmlDslModel xmlDslModel, String operationName, ComponentAst operationModel) {
        Optional<ComponentAst> optionalErrorsComponentModel = operationModel.directChildrenStream().filter(child -> child.getIdentifier().equals(OPERATION_ERRORS_IDENTIFIER)).findAny();
        optionalErrorsComponentModel.ifPresent(componentModel -> componentModel.directChildrenStream().filter(child -> child.getIdentifier().equals(OPERATION_ERROR_IDENTIFIER)).forEach(param -> {
            String namespace = xmlDslModel.getPrefix().toUpperCase();
            String errorType = (String)param.getParameter("General", "type").getValue().getRight();
            if (errorType.contains(NAMESPACE_SEPARATOR)) {
                throw new IllegalModelDefinitionException(String.format("The operation [%s] cannot have an <error> [%s] that contains a reserved character [%s]", operationName, errorType, NAMESPACE_SEPARATOR));
            }
            ErrorModel errorModel = ErrorModelBuilder.newError((String)errorType, (String)namespace).withParent(ErrorModelBuilder.newError((ComponentIdentifier)Errors.ComponentIdentifiers.Handleable.ANY).build()).build();
            operationDeclarer.withErrorModel(errorModel);
            extensionDeclarer.ifPresent(ext -> ext.withErrorModel(errorModel));
        }));
        extensionDeclarer.ifPresent(ext -> operationModel.getModel(ParameterizedModel.class).ifPresent(om -> operationModel.recursiveStream().forEach(comp -> {
            ComponentParameterAst parameter;
            if (comp.getIdentifier().equals(RAISE_ERROR_IDENTIFIER) && (parameter = comp.getParameter("General", "type")) != null) {
                parameter.getValue().getValue().map(r -> (String)r).filter(representation -> !StringUtils.isEmpty((String)representation)).ifPresent(representation -> {
                    ComponentIdentifier raiseType = ComponentIdentifier.buildFromStringRepresentation((String)representation);
                    ext.withErrorModel(ErrorModelBuilder.newError((String)raiseType.getName(), (String)raiseType.getNamespace()).withParent(ErrorModelBuilder.newError((ComponentIdentifier)Errors.ComponentIdentifiers.Handleable.ANY).build()).build());
                });
            }
            ErrorMappingUtils.forEachErrorMappingDo((ComponentAst)comp, mappings -> mappings.forEach(mapping -> {
                String representation = mapping.getTarget();
                if (StringUtils.isEmpty((String)representation)) {
                    return;
                }
                ComponentIdentifier target = ComponentIdentifier.buildFromStringRepresentation((String)representation);
                ext.withErrorModel(ErrorModelBuilder.newError((String)target.getName(), (String)target.getNamespace()).withParent(ErrorModelBuilder.newError((ComponentIdentifier)Errors.ComponentIdentifiers.Handleable.ANY).build()).build());
            }));
        })));
    }

    private class XmlExtensionConfigurationPropertiesResolver
    implements ConfigurationPropertiesResolver {
        private XmlExtensionConfigurationPropertiesResolver() {
        }

        public Object resolveValue(String value) {
            return value;
        }

        public Object resolvePlaceholderKeyValue(String placeholderKey) {
            return placeholderKey;
        }
    }

    public static enum OperationVisibility {
        PRIVATE,
        PUBLIC;

    }

    private static enum UseEnum {
        REQUIRED,
        OPTIONAL,
        AUTO;

    }
}

