/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.extension.internal.loader.validator;

import java.util.Set;
import org.mule.runtime.api.meta.NamedObject;
import org.mule.runtime.api.meta.model.ExtensionModel;
import org.mule.runtime.config.internal.model.properties.PropertiesResolverUtils;
import org.mule.runtime.extension.api.loader.ExtensionModelValidator;
import org.mule.runtime.extension.api.loader.Problem;
import org.mule.runtime.extension.api.loader.ProblemsReporter;
import org.mule.runtime.extension.internal.ast.property.GlobalElementComponentModelModelProperty;

public class ForbiddenConfigurationPropertiesValidator
implements ExtensionModelValidator {
    public static final String CONFIGURATION_PROPERTY_NOT_SUPPORTED_FORMAT_MESSAGE = "Configuration properties is not supported, either use <mule:global-property ../>, ${file::file.txt} or <module:property/> instead. Offending global element '%s'";

    public void validate(ExtensionModel extensionModel, ProblemsReporter problemsReporter) {
        extensionModel.getModelProperty(GlobalElementComponentModelModelProperty.class).ifPresent(modelProperty -> {
            Set configurationPropertiesCollection = PropertiesResolverUtils.loadProviderFactories().keySet();
            modelProperty.getGlobalElements().forEach(globalElementComponentModel -> {
                if (configurationPropertiesCollection.contains(globalElementComponentModel.getIdentifier())) {
                    problemsReporter.addError(new Problem((NamedObject)extensionModel, String.format(CONFIGURATION_PROPERTY_NOT_SUPPORTED_FORMAT_MESSAGE, globalElementComponentModel.getIdentifier())));
                }
            });
        });
    }
}

