/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.extension.internal.runtime.execution;

import java.lang.reflect.Method;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.function.Supplier;
import javax.inject.Inject;
import org.apache.commons.lang3.ArrayUtils;
import org.mule.runtime.api.exception.MuleException;
import org.mule.runtime.api.exception.MuleRuntimeException;
import org.mule.runtime.api.i18n.I18nMessageFactory;
import org.mule.runtime.api.lifecycle.Initialisable;
import org.mule.runtime.api.lifecycle.InitialisationException;
import org.mule.runtime.api.lifecycle.Lifecycle;
import org.mule.runtime.api.meta.model.ComponentModel;
import org.mule.runtime.api.meta.model.parameter.ParameterGroupModel;
import org.mule.runtime.api.util.collection.SmallMap;
import org.mule.runtime.core.api.MuleContext;
import org.mule.runtime.core.api.context.MuleContextAware;
import org.mule.runtime.core.api.lifecycle.LifecycleUtils;
import org.mule.runtime.core.api.util.ClassUtils;
import org.mule.runtime.core.internal.util.CompositeClassLoader;
import org.mule.runtime.extension.api.runtime.operation.ExecutionContext;
import org.mule.runtime.module.extension.api.runtime.executor.MethodExecutor;
import org.mule.runtime.module.extension.internal.runtime.exception.SdkMethodInvocationException;
import org.mule.runtime.module.extension.internal.runtime.execution.ArgumentResolverDelegate;
import org.mule.runtime.module.extension.internal.runtime.execution.MethodArgumentResolverDelegate;
import org.mule.runtime.module.extension.internal.runtime.execution.OperationArgumentResolverFactory;
import org.mule.runtime.module.extension.internal.runtime.execution.executor.MethodExecutorGenerator;
import org.mule.runtime.module.extension.internal.runtime.resolver.ArgumentResolver;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GeneratedMethodComponentExecutor<M extends ComponentModel>
implements MuleContextAware,
Lifecycle,
OperationArgumentResolverFactory<M> {
    private static final Logger LOGGER = LoggerFactory.getLogger(GeneratedMethodComponentExecutor.class);
    private static final ArgumentResolverDelegate NO_ARGS_DELEGATE = new NoArgumentsResolverDelegate();
    private final List<ParameterGroupModel> groups;
    private final Method method;
    private final Object componentInstance;
    private final ClassLoader extensionClassLoader;
    @Inject
    private MethodExecutorGenerator methodExecutorGenerator;
    private ArgumentResolverDelegate argumentResolverDelegate;
    private MethodExecutor methodExecutor;
    private MuleContext muleContext;

    public GeneratedMethodComponentExecutor(List<ParameterGroupModel> groups, Method method, Object componentInstance) {
        this.groups = groups;
        this.method = method;
        this.componentInstance = componentInstance;
        this.extensionClassLoader = method.getDeclaringClass().getClassLoader();
    }

    public Object execute(ExecutionContext<M> executionContext) {
        try {
            return this.methodExecutor.execute(executionContext);
        }
        catch (MuleRuntimeException e) {
            throw e;
        }
        catch (Throwable t) {
            throw new SdkMethodInvocationException(t);
        }
    }

    private Supplier<Object>[] getParameterValues(ExecutionContext<M> executionContext, Class<?>[] parameterTypes) {
        return this.argumentResolverDelegate.resolveDeferred(executionContext, parameterTypes);
    }

    public void initialise() throws InitialisationException {
        LifecycleUtils.initialiseIfNeeded((Object)this.componentInstance, (boolean)true, (MuleContext)this.muleContext);
        this.argumentResolverDelegate = ArrayUtils.isEmpty((Object[])this.method.getParameterTypes()) ? NO_ARGS_DELEGATE : this.getMethodArgumentResolver(this.groups, this.method);
        try {
            this.methodExecutor = this.methodExecutorGenerator.generate(this.componentInstance, this.method, this.argumentResolverDelegate);
        }
        catch (Exception e) {
            throw new InitialisationException((Throwable)e, (Initialisable)this);
        }
    }

    private ArgumentResolverDelegate getMethodArgumentResolver(List<ParameterGroupModel> groups, Method method) {
        try {
            MethodArgumentResolverDelegate resolver = new MethodArgumentResolverDelegate(groups, method);
            LifecycleUtils.initialiseIfNeeded((Object)resolver, (MuleContext)this.muleContext);
            return resolver;
        }
        catch (Exception e) {
            throw new MuleRuntimeException(I18nMessageFactory.createStaticMessage((String)"Could not initialize argument resolver resolver"), (Throwable)e);
        }
    }

    public void start() throws MuleException {
        LifecycleUtils.startIfNeeded((Object)this.componentInstance);
    }

    public void stop() throws MuleException {
        LifecycleUtils.stopIfNeeded((Object)this.componentInstance);
    }

    public void dispose() {
        LifecycleUtils.disposeIfNeeded((Object)this.componentInstance, (Logger)LOGGER);
    }

    public void setMuleContext(MuleContext context) {
        this.muleContext = context;
        if (this.componentInstance instanceof MuleContextAware) {
            ((MuleContextAware)this.componentInstance).setMuleContext(context);
        }
    }

    @Override
    public Function<ExecutionContext<M>, Map<String, Object>> createArgumentResolver(M operationModel) {
        return ec -> {
            Thread thread = Thread.currentThread();
            ClassLoader currentClassLoader = thread.getContextClassLoader();
            CompositeClassLoader compositeClassLoader = CompositeClassLoader.from((ClassLoader)this.extensionClassLoader, (ClassLoader)currentClassLoader);
            ClassUtils.setContextClassLoader((Thread)thread, (ClassLoader)currentClassLoader, (ClassLoader)compositeClassLoader);
            try {
                Supplier<Object>[] resolved = this.getParameterValues((ExecutionContext<M>)ec, this.method.getParameterTypes());
                int parameterCount = this.method.getParameterCount();
                Map resolvedParams = SmallMap.forSize((int)parameterCount);
                for (int i = 0; i < parameterCount; ++i) {
                    resolvedParams.put(this.method.getParameters()[i].getName(), resolved[i]);
                }
                Map map = resolvedParams;
                return map;
            }
            finally {
                ClassUtils.setContextClassLoader((Thread)thread, (ClassLoader)compositeClassLoader, (ClassLoader)currentClassLoader);
            }
        };
    }

    private static class NoArgumentsResolverDelegate
    implements ArgumentResolverDelegate {
        private static final Supplier[] EMPTY_SUPPLIER = new Supplier[0];
        private static final Object[] EMPTY = new Object[0];

        private NoArgumentsResolverDelegate() {
        }

        @Override
        public ArgumentResolver<?>[] getArgumentResolvers() {
            return new ArgumentResolver[0];
        }

        @Override
        public Object[] resolve(ExecutionContext executionContext, Class<?>[] parameterTypes) {
            return EMPTY;
        }

        @Override
        public Supplier<Object>[] resolveDeferred(ExecutionContext executionContext, Class<?>[] parameterTypes) {
            return EMPTY_SUPPLIER;
        }
    }
}

