/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.extension.internal.runtime.config;

import javax.inject.Inject;
import org.mule.runtime.api.connection.ConnectionProvider;
import org.mule.runtime.api.exception.MuleException;
import org.mule.runtime.api.i18n.I18nMessageFactory;
import org.mule.runtime.api.meta.model.ExtensionModel;
import org.mule.runtime.api.meta.model.config.ConfigurationModel;
import org.mule.runtime.core.api.MuleContext;
import org.mule.runtime.core.api.config.ConfigurationException;
import org.mule.runtime.core.api.connector.ConnectionManager;
import org.mule.runtime.core.api.el.ExpressionManager;
import org.mule.runtime.core.api.event.CoreEvent;
import org.mule.runtime.core.api.lifecycle.LifecycleUtils;
import org.mule.runtime.core.internal.registry.DefaultRegistry;
import org.mule.runtime.core.privileged.event.BaseEventContext;
import org.mule.runtime.extension.api.runtime.ExpirationPolicy;
import org.mule.runtime.extension.api.runtime.config.ConfigurationInstance;
import org.mule.runtime.extension.api.runtime.config.ConfigurationProvider;
import org.mule.runtime.metadata.internal.MuleMetadataService;
import org.mule.runtime.module.extension.api.runtime.config.ConfigurationProviderFactory;
import org.mule.runtime.module.extension.api.runtime.resolver.ConnectionProviderValueResolver;
import org.mule.runtime.module.extension.api.runtime.resolver.ResolverSet;
import org.mule.runtime.module.extension.api.runtime.resolver.ValueResolver;
import org.mule.runtime.module.extension.internal.runtime.config.ConfigurationInstanceFactory;
import org.mule.runtime.module.extension.internal.runtime.config.ConfigurationProviderToolingAdapter;
import org.mule.runtime.module.extension.internal.runtime.config.DynamicConfigurationProvider;
import org.mule.runtime.module.extension.internal.runtime.config.StaticConfigurationProvider;
import org.mule.runtime.module.extension.internal.runtime.resolver.ConnectionProviderResolver;
import org.mule.runtime.module.extension.internal.util.MuleExtensionUtils;
import org.mule.runtime.module.extension.internal.util.ReflectionCache;

public final class DefaultConfigurationProviderFactory
implements ConfigurationProviderFactory {
    @Inject
    private ReflectionCache reflectionCache;
    @Inject
    private ExpressionManager expressionManager;
    @Inject
    private MuleContext muleContext;

    @Override
    public ConfigurationProvider createDynamicConfigurationProvider(String name, ExtensionModel extensionModel, ConfigurationModel configurationModel, ResolverSet resolverSet, ConnectionProviderValueResolver connectionProviderResolver, ExpirationPolicy expirationPolicy) {
        this.configureConnectionProviderResolver(name, connectionProviderResolver);
        return new DynamicConfigurationProvider(name, extensionModel, configurationModel, resolverSet, connectionProviderResolver, expirationPolicy, this.reflectionCache, this.expressionManager, this.muleContext);
    }

    @Override
    public ConfigurationProvider createStaticConfigurationProvider(String name, ExtensionModel extensionModel, ConfigurationModel configurationModel, ResolverSet resolverSet, ConnectionProviderValueResolver connectionProviderResolver) throws Exception {
        return MuleExtensionUtils.withExtensionClassLoader(extensionModel, () -> {
            ConfigurationInstance configuration;
            this.configureConnectionProviderResolver(name, connectionProviderResolver);
            CoreEvent initialiserEvent = null;
            try {
                initialiserEvent = org.mule.runtime.module.extension.api.util.MuleExtensionUtils.getInitialiserEvent(this.muleContext);
                LifecycleUtils.initialiseIfNeeded((Object)resolverSet, (boolean)true, (MuleContext)this.muleContext);
                ConfigurationInstanceFactory configurationFactory = new ConfigurationInstanceFactory(extensionModel, configurationModel, resolverSet, this.expressionManager, this.muleContext);
                configuration = configurationFactory.createConfiguration(name, initialiserEvent, connectionProviderResolver);
            }
            catch (MuleException e) {
                throw new ConfigurationException(I18nMessageFactory.createStaticMessage((String)String.format("Could not create configuration '%s' for the '%s'", name, extensionModel.getName())), (Throwable)e);
            }
            finally {
                if (initialiserEvent != null) {
                    ((BaseEventContext)initialiserEvent.getContext()).success();
                }
            }
            DefaultRegistry registry = new DefaultRegistry(this.muleContext);
            return registry.lookupByType(MuleMetadataService.class).map(metadataService -> new ConfigurationProviderToolingAdapter(name, extensionModel, configurationModel, configuration, (MuleMetadataService)metadataService, (ConnectionManager)registry.lookupByName("_muleConnectionManager").get(), this.reflectionCache, this.muleContext)).orElseGet(() -> new StaticConfigurationProvider(name, extensionModel, configurationModel, configuration, this.muleContext));
        });
    }

    private void configureConnectionProviderResolver(String configName, ValueResolver<ConnectionProvider> resolver) {
        if (resolver instanceof ConnectionProviderResolver) {
            ((ConnectionProviderResolver)resolver).setOwnerConfigName(configName);
        }
    }
}

