/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.extension.internal.loader.java;

import java.util.Objects;
import org.mule.runtime.api.exception.MuleRuntimeException;
import org.mule.runtime.api.i18n.I18nMessageFactory;
import org.mule.runtime.api.util.LazyValue;
import org.mule.runtime.core.api.util.ClassUtils;
import org.mule.runtime.core.internal.component.AnnotatedObjectInvocationHandler;
import org.mule.runtime.extension.api.runtime.config.ConfigurationFactory;
import org.mule.runtime.module.artifact.internal.classloader.WithAttachedClassLoaders;
import org.mule.runtime.module.extension.internal.util.IntrospectionUtils;
import org.mule.runtime.module.extension.internal.util.ReflectionCache;

public final class TypeAwareConfigurationFactory
implements ConfigurationFactory {
    private final LazyValue<Class<?>> configurationType;
    private final ClassLoader extensionClassLoader;

    public TypeAwareConfigurationFactory(Class<?> configurationType, ClassLoader extensionClassLoader, boolean addAnnotationsToClass) {
        Objects.requireNonNull(configurationType, "configuration type cannot be null");
        Objects.requireNonNull(extensionClassLoader, "extensionClassLoader type cannot be null");
        IntrospectionUtils.checkInstantiable(configurationType, new ReflectionCache());
        this.extensionClassLoader = extensionClassLoader;
        this.configurationType = new LazyValue(() -> {
            if (!addAnnotationsToClass) {
                return configurationType;
            }
            return (Class)ClassUtils.withContextClassLoader((ClassLoader)this.extensionClassLoader, () -> {
                Class annotated = AnnotatedObjectInvocationHandler.addAnnotationsToClass((Class)configurationType);
                if (extensionClassLoader instanceof WithAttachedClassLoaders) {
                    ((WithAttachedClassLoaders)extensionClassLoader).attachClassLoader(annotated.getClassLoader().getParent() != null ? annotated.getClassLoader().getParent() : annotated.getClassLoader());
                }
                return annotated;
            });
        });
    }

    public Object newInstance() {
        try {
            return ClassUtils.withContextClassLoader((ClassLoader)this.extensionClassLoader, ((Class)this.configurationType.get())::newInstance);
        }
        catch (Exception e) {
            throw new MuleRuntimeException(I18nMessageFactory.createStaticMessage((String)("Could not instantiate configuration of type " + ((Class)this.configurationType.get()).getName())), (Throwable)e);
        }
    }

    public Class<?> getObjectType() {
        return (Class)this.configurationType.get();
    }
}

