/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.extension.internal.runtime.resolver;

import javax.inject.Inject;
import org.mule.runtime.api.artifact.Registry;
import org.mule.runtime.api.exception.MuleException;
import org.mule.runtime.api.lifecycle.Initialisable;
import org.mule.runtime.api.lifecycle.InitialisationException;
import org.mule.runtime.api.metadata.DataType;
import org.mule.runtime.api.transformation.TransformationService;
import org.mule.runtime.api.util.Preconditions;
import org.mule.runtime.core.api.MuleContext;
import org.mule.runtime.core.api.el.ExtendedExpressionManager;
import org.mule.runtime.module.extension.internal.runtime.resolver.ExpressionValueResolver;
import org.mule.runtime.module.extension.internal.runtime.resolver.TypeSafeValueResolverWrapper;
import org.mule.runtime.module.extension.internal.runtime.resolver.ValueResolver;
import org.mule.runtime.module.extension.internal.runtime.resolver.ValueResolvingContext;

public class TypeSafeExpressionValueResolver<T>
implements ValueResolver<T>,
Initialisable {
    private final Class<T> expectedType;
    private final String expression;
    private TypeSafeValueResolverWrapper<T> delegate;
    @Inject
    private TransformationService transformationService;
    @Inject
    private ExtendedExpressionManager extendedExpressionManager;
    @Inject
    private MuleContext muleContext;
    @Inject
    private Registry registry;
    private DataType expectedDataType;
    private Boolean melDefault;
    private Boolean melAvailable;

    public TypeSafeExpressionValueResolver(String expression, Class<T> expectedType, DataType expectedDataType) {
        Preconditions.checkArgument((expectedType != null ? 1 : 0) != 0, (String)"expected type cannot be null");
        this.expression = expression;
        this.expectedType = expectedType;
        this.expectedDataType = expectedDataType;
    }

    @Override
    public T resolve(ValueResolvingContext context) throws MuleException {
        return this.delegate.resolve(context);
    }

    @Override
    public boolean isDynamic() {
        return true;
    }

    public void initialise() throws InitialisationException {
        ExpressionValueResolver resolver = new ExpressionValueResolver(this.expression, this.expectedDataType, this.melDefault, this.melAvailable);
        resolver.setExtendedExpressionManager(this.extendedExpressionManager);
        resolver.setRegistry(this.registry);
        resolver.initialise();
        this.delegate = new TypeSafeValueResolverWrapper<T>(resolver, this.expectedType);
        this.delegate.setTransformationService(this.transformationService);
        this.delegate.setMuleContext(this.muleContext);
        this.delegate.initialise();
    }

    public void setTransformationService(TransformationService transformationService) {
        this.transformationService = transformationService;
    }

    public void setExtendedExpressionManager(ExtendedExpressionManager extendedExpressionManager) {
        this.extendedExpressionManager = extendedExpressionManager;
    }

    public void setMuleContext(MuleContext muleContext) {
        this.muleContext = muleContext;
    }

    public void setMelDefault(Boolean melDefault) {
        this.melDefault = melDefault;
    }

    public void setMelAvailable(Boolean melAvailable) {
        this.melAvailable = melAvailable;
    }
}

