/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.extension.internal.loader.java.enricher;

import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.mule.runtime.api.meta.model.ModelProperty;
import org.mule.runtime.api.meta.model.declaration.fluent.BaseDeclaration;
import org.mule.runtime.api.meta.model.declaration.fluent.ConfigurationDeclaration;
import org.mule.runtime.api.meta.model.declaration.fluent.ConnectedDeclaration;
import org.mule.runtime.api.meta.model.declaration.fluent.ConnectionProviderDeclaration;
import org.mule.runtime.api.meta.model.declaration.fluent.NamedDeclaration;
import org.mule.runtime.api.meta.model.declaration.fluent.WithParametersDeclaration;
import org.mule.runtime.extension.api.annotation.metadata.RequiredForMetadata;
import org.mule.runtime.extension.api.loader.DeclarationEnricherPhase;
import org.mule.runtime.extension.api.loader.ExtensionLoadingContext;
import org.mule.runtime.extension.api.loader.WalkingDeclarationEnricher;
import org.mule.runtime.extension.api.property.InfrastructureParameterModelProperty;
import org.mule.runtime.extension.api.property.RequiredForMetadataModelProperty;
import org.mule.runtime.module.extension.internal.loader.java.type.property.ExtensionParameterDescriptorModelProperty;

public class RequiredForMetadataDeclarationEnricher
implements WalkingDeclarationEnricher {
    public DeclarationEnricherPhase getExecutionPhase() {
        return DeclarationEnricherPhase.POST_STRUCTURE;
    }

    public Optional<WalkingDeclarationEnricher.DeclarationEnricherWalkDelegate> getWalkDelegate(ExtensionLoadingContext extensionLoadingContext) {
        return Optional.of(new WalkingDeclarationEnricher.DeclarationEnricherWalkDelegate(){

            public void onConfiguration(ConfigurationDeclaration declaration) {
                RequiredForMetadataDeclarationEnricher.this.registerRequiredParametersForMetadata((BaseDeclaration)declaration);
            }

            public void onConnectionProvider(ConnectedDeclaration owner, ConnectionProviderDeclaration declaration) {
                RequiredForMetadataDeclarationEnricher.this.registerRequiredParametersForMetadata((BaseDeclaration)declaration);
            }
        });
    }

    private <T extends BaseDeclaration> void registerRequiredParametersForMetadata(T declaration) {
        List<String> parametersRequiredForMetadata = this.getParametersNameRequiredForMetadata((WithParametersDeclaration)declaration);
        if (!parametersRequiredForMetadata.isEmpty()) {
            declaration.addModelProperty((ModelProperty)new RequiredForMetadataModelProperty(parametersRequiredForMetadata));
        }
    }

    private List<String> getParametersNameRequiredForMetadata(WithParametersDeclaration declaration) {
        ArrayList<String> nonInfrastructureParameterNames = new ArrayList<String>();
        List<String> parametersRequiredForMetadata = declaration.getAllParameters().stream().filter(pd -> !pd.getModelProperty(InfrastructureParameterModelProperty.class).isPresent()).peek(pd -> nonInfrastructureParameterNames.add(pd.getName())).filter(p -> p.getModelProperty(ExtensionParameterDescriptorModelProperty.class).map(mp -> mp.getExtensionParameter().isAnnotatedWith(RequiredForMetadata.class)).orElse(false)).map(NamedDeclaration::getName).collect(Collectors.toList());
        if (parametersRequiredForMetadata.isEmpty()) {
            return nonInfrastructureParameterNames;
        }
        return parametersRequiredForMetadata;
    }
}

