/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.extension.internal.loader.parser.java;

import java.util.List;
import org.mule.runtime.api.meta.model.ModelProperty;
import org.mule.runtime.extension.api.loader.ExtensionLoadingContext;
import org.mule.runtime.module.extension.api.loader.java.type.ExtensionParameter;
import org.mule.runtime.module.extension.internal.loader.parser.java.StackableTypesModelPropertyResolver;

public final class ParameterDeclarationContext {
    private static final StackableTypesModelPropertyResolver STACKABLE_TYPES_RESOLVER = StackableTypesModelPropertyResolver.newInstance();
    private final String componentName;
    private final String componentType;
    private final ExtensionLoadingContext loadingContext;
    private final boolean keyResolverAvailable;

    public static ParameterDeclarationContext forConfig(String configName, ExtensionLoadingContext loadingContext) {
        return new ParameterDeclarationContext(configName, "Configuration", loadingContext);
    }

    public static ParameterDeclarationContext forOperation(String operationName, ExtensionLoadingContext loadingContext) {
        return new ParameterDeclarationContext(operationName, "Operation", loadingContext);
    }

    public static ParameterDeclarationContext forOperation(String operationName, ExtensionLoadingContext loadingContext, boolean keyResolverAvailable) {
        return new ParameterDeclarationContext(operationName, "Operation", loadingContext, keyResolverAvailable);
    }

    public static ParameterDeclarationContext forSource(String sourceName, ExtensionLoadingContext loadingContext) {
        return new ParameterDeclarationContext(sourceName, "Source", loadingContext);
    }

    public static ParameterDeclarationContext forSource(String sourceName, ExtensionLoadingContext loadingContext, boolean keyResolverAvailable) {
        return new ParameterDeclarationContext(sourceName, "Source", loadingContext, keyResolverAvailable);
    }

    public static ParameterDeclarationContext forConnectionProvider(String connectionProviderName, ExtensionLoadingContext loadingContext) {
        return new ParameterDeclarationContext(connectionProviderName, "Connection Provider", loadingContext);
    }

    public static ParameterDeclarationContext forFunction(String functionName, ExtensionLoadingContext loadingContext) {
        return new ParameterDeclarationContext(functionName, "Function", loadingContext);
    }

    public static ParameterDeclarationContext forRoute(String routeName, ExtensionLoadingContext loadingContext) {
        return new ParameterDeclarationContext(routeName, "Route", loadingContext);
    }

    public ParameterDeclarationContext(String componentName, String componentType, ExtensionLoadingContext loadingContext) {
        this(componentName, componentType, loadingContext, false);
    }

    public ParameterDeclarationContext(String componentName, String componentType, ExtensionLoadingContext loadingContext, boolean keyResolverAvailable) {
        this.componentName = componentName;
        this.componentType = componentType;
        this.loadingContext = loadingContext;
        this.keyResolverAvailable = keyResolverAvailable;
    }

    public String getComponentName() {
        return this.componentName;
    }

    public String getComponentType() {
        return this.componentType;
    }

    public ExtensionLoadingContext getLoadingContext() {
        return this.loadingContext;
    }

    public boolean isKeyResolverAvailable() {
        return this.keyResolverAvailable;
    }

    public List<ModelProperty> resolveStackableTypes(ExtensionParameter extensionParameter) {
        return STACKABLE_TYPES_RESOLVER.resolveStackableProperties(extensionParameter, this);
    }
}

