/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.extension.internal.runtime.source.poll;

import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DelegateRunnable
implements Runnable {
    private static final Logger LOGGER = LoggerFactory.getLogger(DelegateRunnable.class);
    private Runnable delegate;
    private Lock lock = new ReentrantLock();

    public DelegateRunnable(Runnable delegate) {
        this.delegate = delegate;
    }

    @Override
    public void run() {
        if (this.lock.tryLock()) {
            try {
                if (this.delegate != null) {
                    this.delegate.run();
                } else {
                    LOGGER.debug("The execution of the task was skipped because no delegate was set.");
                }
            }
            finally {
                this.lock.unlock();
            }
        }
    }

    public void setDelegate(Runnable delegate) {
        this.lock.lock();
        this.delegate = delegate;
        this.lock.unlock();
    }
}

