/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.extension.internal.runtime.connectivity.oauth;

import java.lang.reflect.Field;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.mule.runtime.api.connection.ConnectionProvider;
import org.mule.runtime.api.connection.ConnectionValidationResult;
import org.mule.runtime.api.exception.MuleRuntimeException;
import org.mule.runtime.api.i18n.I18nMessageFactory;
import org.mule.runtime.api.meta.model.connection.ConnectionProviderModel;
import org.mule.runtime.api.meta.model.operation.OperationModel;
import org.mule.runtime.api.util.LazyValue;
import org.mule.runtime.api.util.Reference;
import org.mule.runtime.core.api.connection.util.ConnectionProviderUtils;
import org.mule.runtime.core.api.util.ExceptionUtils;
import org.mule.runtime.core.api.util.func.CheckedSupplier;
import org.mule.runtime.extension.api.connectivity.oauth.AccessTokenExpiredException;
import org.mule.runtime.extension.api.connectivity.oauth.AuthorizationCodeGrantType;
import org.mule.runtime.extension.api.connectivity.oauth.AuthorizationCodeState;
import org.mule.runtime.extension.api.connectivity.oauth.ClientCredentialsGrantType;
import org.mule.runtime.extension.api.connectivity.oauth.OAuthGrantType;
import org.mule.runtime.extension.api.connectivity.oauth.OAuthGrantTypeVisitor;
import org.mule.runtime.extension.api.connectivity.oauth.OAuthState;
import org.mule.runtime.extension.api.connectivity.oauth.PlatformManagedOAuthGrantType;
import org.mule.runtime.extension.api.exception.IllegalConnectionProviderModelDefinitionException;
import org.mule.runtime.extension.api.runtime.config.ConfigurationInstance;
import org.mule.runtime.extension.api.security.CredentialsPlacement;
import org.mule.runtime.module.extension.api.runtime.privileged.ExecutionContextAdapter;
import org.mule.runtime.module.extension.internal.loader.java.property.oauth.OAuthCallbackValuesModelProperty;
import org.mule.runtime.module.extension.internal.runtime.connectivity.oauth.OAuthConnectionProviderWrapper;
import org.mule.runtime.module.extension.internal.runtime.connectivity.oauth.authcode.AuthorizationCodeConfig;
import org.mule.runtime.module.extension.internal.runtime.connectivity.oauth.authcode.AuthorizationCodeConnectionProviderWrapper;
import org.mule.runtime.module.extension.internal.runtime.connectivity.oauth.authcode.ImmutableAuthorizationCodeState;
import org.mule.runtime.module.extension.internal.util.FieldSetter;
import org.mule.runtime.module.extension.internal.util.IntrospectionUtils;
import org.mule.runtime.oauth.api.builder.ClientCredentialsLocation;
import org.mule.runtime.oauth.api.state.ResourceOwnerOAuthContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ExtensionsOAuthUtils {
    private static final Logger LOGGER = LoggerFactory.getLogger(ExtensionsOAuthUtils.class);
    public static final int MAX_REFRESH_ATTEMPTS = 2;

    public static AuthorizationCodeState toAuthorizationCodeState(AuthorizationCodeConfig config, ResourceOwnerOAuthContext context) {
        return new ImmutableAuthorizationCodeState(context.getAccessToken(), context.getRefreshToken(), context.getResourceOwnerId(), context.getExpiresIn(), context.getState(), config.getAuthorizationUrl(), config.getAccessTokenUrl(), config.getCallbackConfig().getExternalCallbackUrl(), config.getConsumerKey(), config.getConsumerSecret());
    }

    public static ClientCredentialsLocation toCredentialsLocation(CredentialsPlacement placement) {
        if (placement == CredentialsPlacement.BASIC_AUTH_HEADER) {
            return ClientCredentialsLocation.BASIC_AUTH_HEADER;
        }
        if (placement == CredentialsPlacement.QUERY_PARAMS) {
            return ClientCredentialsLocation.QUERY_PARAMS;
        }
        if (placement == CredentialsPlacement.BODY) {
            return ClientCredentialsLocation.BODY;
        }
        throw new IllegalArgumentException("Unsupported CredentialsPlacement type " + placement.name());
    }

    public static OAuthConnectionProviderWrapper getOAuthConnectionProvider(ExecutionContextAdapter operationContext) {
        ConfigurationInstance config = (ConfigurationInstance)operationContext.getConfiguration().get();
        return ExtensionsOAuthUtils.getOAuthConnectionProvider((ConnectionProvider)config.getConnectionProvider().get());
    }

    public static OAuthConnectionProviderWrapper getOAuthConnectionProvider(ConnectionProvider provider) {
        ConnectionProvider oauthProvider = ConnectionProviderUtils.unwrapProviderWrapper((ConnectionProvider)provider, OAuthConnectionProviderWrapper.class);
        return oauthProvider instanceof OAuthConnectionProviderWrapper ? (OAuthConnectionProviderWrapper)oauthProvider : null;
    }

    public static Map<Field, String> getCallbackValuesExtractors(ConnectionProviderModel providerModel) {
        return providerModel.getModelProperty(OAuthCallbackValuesModelProperty.class).map(OAuthCallbackValuesModelProperty::getCallbackValues).orElseGet(Collections::emptyMap);
    }

    public static <T extends OAuthState> FieldSetter<Object, Object> getOAuthStateSetter(Object target, Class<T> stateType, OAuthGrantType grantType) {
        List stateFields = IntrospectionUtils.getFields(target.getClass()).stream().filter(f -> f.getType().equals(stateType)).collect(Collectors.toList());
        if (stateFields.size() != 1) {
            throw new IllegalConnectionProviderModelDefinitionException(String.format("Connection Provider of class '%s' uses OAuth2 %s grant type and thus should contain one (and only one) field of type %s. %d were found", target.getClass().getName(), grantType.getName(), stateType, stateFields.size()));
        }
        return new FieldSetter<Object, Object>((Field)stateFields.get(0));
    }

    public static <C> void updateOAuthParameters(Object target, Map<Field, String> callbackValues, ResourceOwnerOAuthContext context) {
        Map responseParameters = context.getTokenResponseParameters();
        callbackValues.keySet().forEach(field -> {
            String key = field.getName();
            if (responseParameters.containsKey(key)) {
                new FieldSetter((Field)field).set(target, responseParameters.get(key));
            }
        });
    }

    public static <C> ConnectionValidationResult validateOAuthConnection(OAuthConnectionProviderWrapper<C> oAuthConnectionProviderWrapper, C connection, ResourceOwnerOAuthContext context) {
        return ExtensionsOAuthUtils.validateOAuthConnection(oAuthConnectionProviderWrapper, connection, context, 2);
    }

    private static <C> ConnectionValidationResult validateOAuthConnection(OAuthConnectionProviderWrapper<C> oAuthConnectionProviderWrapper, C connection, ResourceOwnerOAuthContext context, int maxRefreshAttempts) {
        ConnectionValidationResult connectionValidationResult = ExtensionsOAuthUtils.validateOAuthConnection(oAuthConnectionProviderWrapper.getDelegate(), connection, context);
        if (!connectionValidationResult.isValid() && maxRefreshAttempts > 0 && ExtensionsOAuthUtils.refreshTokenIfNecessary(oAuthConnectionProviderWrapper, (Throwable)connectionValidationResult.getException())) {
            return ExtensionsOAuthUtils.validateOAuthConnection(oAuthConnectionProviderWrapper, connection, context, --maxRefreshAttempts);
        }
        return connectionValidationResult;
    }

    public static <C> ConnectionValidationResult validateOAuthConnection(ConnectionProvider<C> connectionProvider, C connection, ResourceOwnerOAuthContext context) {
        try {
            if (context.getAccessToken() != null) {
                return connectionProvider.validate(connection);
            }
            String message = "Server did not granted an access token";
            return ConnectionValidationResult.failure((String)message, (Exception)new IllegalStateException(message));
        }
        catch (Exception e) {
            return ConnectionValidationResult.failure((String)"Could not obtain an access token", (Exception)e);
        }
    }

    public static <T> T withRefreshToken(Supplier<ConnectionProvider> connectionProviderSupplier, CheckedSupplier<T> supplier) throws Exception {
        return ExtensionsOAuthUtils.withRefreshToken(connectionProviderSupplier, supplier, 2);
    }

    public static <T> T withRefreshToken(Supplier<ConnectionProvider> connectionProviderSupplier, CheckedSupplier<T> supplier, int maxRefreshAttempts) throws Exception {
        try {
            return (T)supplier.getChecked();
        }
        catch (Throwable e) {
            if (maxRefreshAttempts > 0 && ExtensionsOAuthUtils.refreshTokenIfNecessary(connectionProviderSupplier, e)) {
                return ExtensionsOAuthUtils.withRefreshToken(connectionProviderSupplier, supplier, --maxRefreshAttempts);
            }
            if (e instanceof Exception) {
                throw (Exception)e;
            }
            return (T)supplier.handleException(e);
        }
    }

    public static <T> T withRefreshToken(ConnectionProvider connectionProvider, CheckedSupplier<T> supplier) throws Exception {
        return ExtensionsOAuthUtils.withRefreshToken(() -> connectionProvider, supplier);
    }

    public static boolean refreshTokenIfNecessary(ExecutionContextAdapter<OperationModel> operationContext, Throwable e) {
        OAuthConnectionProviderWrapper connectionProvider = ExtensionsOAuthUtils.getOAuthConnectionProvider(operationContext);
        return ExtensionsOAuthUtils.refreshTokenIfNecessary(() -> connectionProvider, e, Optional.of(new LazyValue(() -> String.format("at operation '%s:%s' using config '%s'", operationContext.getExtensionModel().getName(), ((OperationModel)operationContext.getComponentModel()).getName(), ((ConfigurationInstance)operationContext.getConfiguration().get()).getName()))), Optional.of(new LazyValue(() -> ((ConfigurationInstance)operationContext.getConfiguration().get()).getName())));
    }

    public static boolean refreshTokenIfNecessary(ConnectionProvider connectionProvider, Throwable e) {
        return ExtensionsOAuthUtils.refreshTokenIfNecessary(() -> connectionProvider, e, Optional.empty(), Optional.empty());
    }

    private static boolean refreshTokenIfNecessary(Supplier<ConnectionProvider> connectionProviderSupplier, Throwable e) {
        return ExtensionsOAuthUtils.refreshTokenIfNecessary(connectionProviderSupplier, e, Optional.empty(), Optional.empty());
    }

    private static boolean refreshTokenIfNecessary(Supplier<ConnectionProvider> connectionProviderSupplier, Throwable e, final Optional<LazyValue<String>> refreshContext, Optional<LazyValue<String>> configName) {
        AccessTokenExpiredException expiredException = ExtensionsOAuthUtils.getTokenExpirationException(e);
        if (expiredException == null) {
            return false;
        }
        final OAuthConnectionProviderWrapper oauthConnectionProvider = ExtensionsOAuthUtils.getOAuthConnectionProvider(connectionProviderSupplier.get());
        if (oauthConnectionProvider == null) {
            return false;
        }
        final Reference resourceOwnerIdReference = new Reference(Optional.empty());
        oauthConnectionProvider.getGrantType().accept(new OAuthGrantTypeVisitor(){

            public void visit(AuthorizationCodeGrantType grantType) {
                AuthorizationCodeConnectionProviderWrapper cp = (AuthorizationCodeConnectionProviderWrapper)oauthConnectionProvider;
                String rsId = cp.getResourceOwnerId();
                resourceOwnerIdReference.set(Optional.of(rsId));
                if (LOGGER.isInfoEnabled()) {
                    LOGGER.info("AccessToken for resourceOwner '{}' expired {}. Will attempt to refresh token and retry", (Object)rsId, (Object)refreshContext.map(LazyValue::get).orElse(""));
                }
            }

            public void visit(ClientCredentialsGrantType grantType) {
                this.logTokenExpiration();
            }

            public void visit(PlatformManagedOAuthGrantType grantType) {
                this.logTokenExpiration();
            }

            private void logTokenExpiration() {
                if (LOGGER.isInfoEnabled()) {
                    LOGGER.info("AccessToken expired {}. Will attempt to refresh token and retry", (Object)refreshContext.map(LazyValue::get).orElse(""));
                }
            }
        });
        Optional resourceOwnerId = (Optional)resourceOwnerIdReference.get();
        try {
            oauthConnectionProvider.refreshToken(resourceOwnerId.orElse(""));
        }
        catch (Exception refreshException) {
            String errorMessage = String.format("AccessToken %s expired %s. Refresh token workflow was attempted but failed.", ExtensionsOAuthUtils.forResourceOwner(resourceOwnerId), refreshContext.map(LazyValue::get).orElse(""));
            LOGGER.error(errorMessage, (Throwable)refreshException);
            throw new MuleRuntimeException(I18nMessageFactory.createStaticMessage((String)errorMessage), (Throwable)refreshException);
        }
        if (LOGGER.isInfoEnabled()) {
            LOGGER.info("Access Token successfully refreshed {} on config '{}'", (Object)ExtensionsOAuthUtils.forResourceOwner(resourceOwnerId), (Object)configName.map(LazyValue::get).orElse(""));
        }
        return true;
    }

    private static AccessTokenExpiredException getTokenExpirationException(Throwable e) {
        return ExceptionUtils.extractOfType((Throwable)e, AccessTokenExpiredException.class).orElse(null);
    }

    private static String forResourceOwner(Optional<String> resourceOwnerId) {
        return resourceOwnerId.map(id -> "for resource owner '" + id + "'").orElse("");
    }

    private ExtensionsOAuthUtils() {
    }
}

