/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.extension.internal.runtime.connectivity.oauth.clientcredentials;

import java.lang.reflect.Field;
import java.util.Map;
import java.util.Optional;
import org.mule.runtime.api.util.MultiMap;
import org.mule.runtime.extension.api.connectivity.oauth.ClientCredentialsGrantType;
import org.mule.runtime.extension.api.security.CredentialsPlacement;
import org.mule.runtime.module.extension.internal.runtime.connectivity.oauth.OAuthConfig;
import org.mule.runtime.module.extension.internal.runtime.connectivity.oauth.OAuthObjectStoreConfig;

public class ClientCredentialsConfig
extends OAuthConfig<ClientCredentialsGrantType> {
    private static final String CONFIG_ID_SEPARATOR = "//";
    private final String clientId;
    private final String clientSecret;
    private final String tokenUrl;
    private final String scope;
    private final CredentialsPlacement credentialsPlacement;
    private final ClientCredentialsGrantType grantType;
    private final String configIdentifier;

    public ClientCredentialsConfig(String ownerConfigName, Optional<OAuthObjectStoreConfig> storeConfig, MultiMap<String, String> customParameters, MultiMap<String, String> customHeaders, Map<Field, String> parameterExtractors, String clientId, String clientSecret, String tokenUrl, String scope, CredentialsPlacement credentialsPlacement, ClientCredentialsGrantType grantType) {
        super(ownerConfigName, storeConfig, customParameters, customHeaders, parameterExtractors);
        this.clientId = clientId;
        this.clientSecret = clientSecret;
        this.tokenUrl = tokenUrl;
        this.scope = scope;
        this.credentialsPlacement = credentialsPlacement;
        this.grantType = grantType;
        this.configIdentifier = this.generateConfigIdentifier();
    }

    private String generateConfigIdentifier() {
        StringBuilder configIdentifierBuilder = new StringBuilder();
        configIdentifierBuilder.append(this.getOwnerConfigName());
        configIdentifierBuilder.append(CONFIG_ID_SEPARATOR);
        configIdentifierBuilder.append(this.getClientId());
        configIdentifierBuilder.append(CONFIG_ID_SEPARATOR);
        configIdentifierBuilder.append(this.getClientSecret());
        configIdentifierBuilder.append(CONFIG_ID_SEPARATOR);
        configIdentifierBuilder.append(this.getTokenUrl());
        configIdentifierBuilder.append(CONFIG_ID_SEPARATOR);
        configIdentifierBuilder.append(this.getScope().orElse(""));
        return configIdentifierBuilder.toString();
    }

    public String getClientId() {
        return this.clientId;
    }

    public String getClientSecret() {
        return this.clientSecret;
    }

    public String getTokenUrl() {
        return this.tokenUrl;
    }

    public CredentialsPlacement getCredentialsPlacement() {
        return this.credentialsPlacement;
    }

    public Optional<String> getScope() {
        return Optional.ofNullable(this.scope);
    }

    public String getConfigIdentifier() {
        return this.configIdentifier;
    }

    @Override
    public ClientCredentialsGrantType getGrantType() {
        return this.grantType;
    }
}

