/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.extension.internal.runtime.resolver;

import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.mule.runtime.api.component.ComponentIdentifier;
import org.mule.runtime.api.message.Error;
import org.mule.runtime.core.api.error.Errors;
import org.mule.runtime.extension.api.runtime.operation.ExecutionContext;
import org.mule.runtime.extension.api.runtime.source.SourceCallbackContext;
import org.mule.runtime.extension.api.runtime.source.SourceResult;
import org.mule.runtime.module.extension.internal.runtime.resolver.ArgumentResolver;

public class SourceResultArgumentResolver
implements ArgumentResolver<SourceResult> {
    private final ArgumentResolver<Error> errorArgumentResolver;
    private final ArgumentResolver<SourceCallbackContext> callbackContextArgumentResolver;
    private static final Set<String> GENERATE_ERRORS = Stream.of(Errors.ComponentIdentifiers.Handleable.SOURCE_RESPONSE_GENERATE, Errors.ComponentIdentifiers.Handleable.SOURCE_ERROR_RESPONSE_GENERATE).map(ComponentIdentifier::getName).collect(Collectors.toSet());

    public SourceResultArgumentResolver(ArgumentResolver<Error> errorArgumentResolver, ArgumentResolver<SourceCallbackContext> callbackContextArgumentResolver) {
        this.errorArgumentResolver = errorArgumentResolver;
        this.callbackContextArgumentResolver = callbackContextArgumentResolver;
    }

    @Override
    public SourceResult resolve(ExecutionContext executionContext) {
        Error error = this.errorArgumentResolver.resolve(executionContext);
        SourceCallbackContext callbackContext = this.callbackContextArgumentResolver.resolve(executionContext);
        if (error == null) {
            return SourceResult.success((SourceCallbackContext)callbackContext);
        }
        String errorIdentifier = error.getErrorType().getIdentifier();
        return this.isErrorGeneratingErrorResponse(errorIdentifier) ? SourceResult.invocationError((Error)error, (SourceCallbackContext)callbackContext) : SourceResult.responseError((Error)error, (SourceCallbackContext)callbackContext);
    }

    private boolean isErrorGeneratingErrorResponse(String identifier) {
        return GENERATE_ERRORS.contains(identifier);
    }
}

