/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.extension.internal.runtime.operation;

import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;
import java.util.function.Function;
import org.mule.runtime.api.exception.ErrorTypeRepository;
import org.mule.runtime.api.meta.model.ComponentModel;
import org.mule.runtime.api.meta.model.ExtensionModel;
import org.mule.runtime.core.api.MuleContext;
import org.mule.runtime.core.api.execution.ExecutionTemplate;
import org.mule.runtime.core.api.execution.TransactionalExecutionTemplate;
import org.mule.runtime.core.api.retry.policy.RetryPolicyTemplate;
import org.mule.runtime.core.api.rx.Exceptions;
import org.mule.runtime.core.api.transaction.TransactionConfig;
import org.mule.runtime.core.api.util.ClassUtils;
import org.mule.runtime.core.api.util.func.CheckedBiFunction;
import org.mule.runtime.extension.api.runtime.operation.CompletableComponentExecutor;
import org.mule.runtime.extension.api.runtime.operation.ExecutionContext;
import org.mule.runtime.module.extension.api.runtime.privileged.ExecutionContextAdapter;
import org.mule.runtime.module.extension.internal.runtime.config.MutableConfigurationStats;
import org.mule.runtime.module.extension.internal.runtime.exception.ExceptionHandlerManager;
import org.mule.runtime.module.extension.internal.runtime.exception.ModuleExceptionHandler;
import org.mule.runtime.module.extension.internal.runtime.execution.interceptor.InterceptorChain;
import org.mule.runtime.module.extension.internal.runtime.operation.ExecutionMediator;
import org.mule.runtime.module.extension.internal.util.MuleExtensionUtils;
import org.mule.runtime.module.extension.internal.util.ReconnectionUtils;

public final class DefaultExecutionMediator<M extends ComponentModel>
implements ExecutionMediator<M> {
    private final ExceptionHandlerManager exceptionEnricherManager;
    private final InterceptorChain interceptorChain;
    private final ExecutionTemplate<?> defaultExecutionTemplate = callback -> callback.process();
    private final ModuleExceptionHandler moduleExceptionHandler;
    private final ResultTransformer resultTransformer;
    private final ClassLoader extensionClassLoader;

    public DefaultExecutionMediator(ExtensionModel extensionModel, M operationModel, InterceptorChain interceptorChain, ErrorTypeRepository typeRepository) {
        this(extensionModel, operationModel, interceptorChain, typeRepository, null);
    }

    public DefaultExecutionMediator(ExtensionModel extensionModel, M operationModel, InterceptorChain interceptorChain, ErrorTypeRepository typeRepository, ResultTransformer resultTransformer) {
        this.interceptorChain = interceptorChain;
        this.exceptionEnricherManager = new ExceptionHandlerManager(extensionModel, (ComponentModel)operationModel, typeRepository);
        this.moduleExceptionHandler = new ModuleExceptionHandler((ComponentModel)operationModel, extensionModel, typeRepository);
        this.resultTransformer = resultTransformer;
        this.extensionClassLoader = MuleExtensionUtils.getClassLoader(extensionModel);
    }

    @Override
    public void execute(CompletableComponentExecutor<M> executor, ExecutionContextAdapter<M> context, CompletableComponentExecutor.ExecutorCallback callback) {
        MutableConfigurationStats stats = MuleExtensionUtils.getMutableConfigurationStats(context);
        if (stats != null) {
            stats.addInflightOperation();
        }
        try {
            this.getExecutionTemplate(context).execute(() -> {
                this.executeWithInterceptors(executor, context, stats, callback);
                return null;
            });
        }
        catch (Exception e) {
            callback.error((Throwable)e);
        }
        catch (Throwable t) {
            callback.error(Exceptions.wrapFatal((Throwable)t));
        }
    }

    private void executeWithRetry(ExecutionContextAdapter<M> context, RetryPolicyTemplate retryPolicy, Consumer<CompletableComponentExecutor.ExecutorCallback> executeCommand, CompletableComponentExecutor.ExecutorCallback callback) {
        retryPolicy.applyPolicy(() -> {
            CompletableFuture future = new CompletableFuture();
            executeCommand.accept(new FutureExecutionCallbackDecorator(future));
            return future;
        }, e -> ReconnectionUtils.shouldRetry(e, context), e -> this.interceptorChain.onError(context, (Throwable)e), ReconnectionUtils.NULL_THROWABLE_CONSUMER, Function.identity(), context.getCurrentScheduler()).whenComplete((v, e) -> {
            if (e != null) {
                callback.error(e);
            } else {
                callback.complete(v);
            }
        });
    }

    private void executeWithInterceptors(CompletableComponentExecutor<M> executor, final ExecutionContextAdapter<M> context, final MutableConfigurationStats stats, final CompletableComponentExecutor.ExecutorCallback executorCallback) {
        CompletableComponentExecutor.ExecutorCallback callbackDelegate = new CompletableComponentExecutor.ExecutorCallback(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void complete(Object value) {
                try {
                    DefaultExecutionMediator.this.interceptorChain.onSuccess(context, value);
                    executorCallback.complete(value);
                }
                catch (Throwable t) {
                    try {
                        t = DefaultExecutionMediator.this.handleError(t, context);
                    }
                    catch (Throwable throwable) {
                        executorCallback.error(t);
                        throw throwable;
                    }
                    executorCallback.error(t);
                }
                finally {
                    if (stats != null) {
                        stats.discountInflightOperation();
                    }
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void error(Throwable t) {
                try {
                    t = DefaultExecutionMediator.this.handleError(t, context);
                }
                finally {
                    try {
                        executorCallback.error(t);
                    }
                    finally {
                        if (stats != null) {
                            stats.discountInflightOperation();
                        }
                    }
                }
            }
        };
        RetryPolicyTemplate retryPolicy = context.getRetryPolicyTemplate().orElse(null);
        if (retryPolicy != null && retryPolicy.isEnabled()) {
            this.executeWithRetry(context, retryPolicy, callback -> this.executeCommand(executor, context, (CompletableComponentExecutor.ExecutorCallback)callback), callbackDelegate);
        } else {
            this.executeCommand(executor, context, callbackDelegate);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void executeCommand(CompletableComponentExecutor<M> executor, ExecutionContextAdapter<M> context, CompletableComponentExecutor.ExecutorCallback callback) {
        Throwable t = this.interceptorChain.before(context, callback);
        if (t == null) {
            if (this.resultTransformer != null) {
                callback = new TransformingExecutionCallbackDecorator<M>(callback, context, this.resultTransformer);
            }
            Thread currentThread = Thread.currentThread();
            ClassLoader currentClassLoader = currentThread.getContextClassLoader();
            ClassUtils.setContextClassLoader((Thread)currentThread, (ClassLoader)currentClassLoader, (ClassLoader)this.extensionClassLoader);
            try {
                executor.execute(context, callback);
            }
            finally {
                ClassUtils.setContextClassLoader((Thread)currentThread, (ClassLoader)this.extensionClassLoader, (ClassLoader)currentClassLoader);
            }
        }
    }

    private Throwable handleError(Throwable e, ExecutionContextAdapter context) {
        e = this.exceptionEnricherManager.process(e);
        e = this.moduleExceptionHandler.processException(e);
        e = this.interceptorChain.onError(context, e);
        return e;
    }

    Throwable applyBeforeInterceptors(ExecutionContextAdapter executionContext) {
        return this.interceptorChain.before(executionContext, null);
    }

    void applyAfterInterceptors(ExecutionContext executionContext) {
        this.interceptorChain.abort(executionContext);
    }

    private <T> ExecutionTemplate<T> getExecutionTemplate(ExecutionContextAdapter<ComponentModel> context) {
        if (context.getTransactionConfig().isPresent()) {
            return TransactionalExecutionTemplate.createTransactionalExecutionTemplate((MuleContext)context.getMuleContext(), (TransactionConfig)context.getTransactionConfig().get());
        }
        return this.defaultExecutionTemplate;
    }

    private static class TransformingExecutionCallbackDecorator<M extends ComponentModel>
    implements CompletableComponentExecutor.ExecutorCallback {
        private final CompletableComponentExecutor.ExecutorCallback delegate;
        private final ExecutionContextAdapter<M> executionContext;
        private final ResultTransformer resultTransformer;

        public TransformingExecutionCallbackDecorator(CompletableComponentExecutor.ExecutorCallback delegate, ExecutionContextAdapter<M> executionContext, ResultTransformer resultTransformer) {
            this.delegate = delegate;
            this.executionContext = executionContext;
            this.resultTransformer = resultTransformer;
        }

        public void complete(Object value) {
            try {
                this.delegate.complete(this.resultTransformer.apply(this.executionContext, value));
            }
            catch (Exception e) {
                this.delegate.error((Throwable)e);
            }
        }

        public void error(Throwable e) {
            this.delegate.error(e);
        }
    }

    private static class FutureExecutionCallbackDecorator
    implements CompletableComponentExecutor.ExecutorCallback {
        private final CompletableFuture<Object> future;

        private FutureExecutionCallbackDecorator(CompletableFuture<Object> future) {
            this.future = future;
        }

        public void complete(Object value) {
            this.future.complete(value);
        }

        public void error(Throwable e) {
            this.future.completeExceptionally(e);
        }
    }

    @FunctionalInterface
    public static interface ResultTransformer
    extends CheckedBiFunction<ExecutionContextAdapter, Object, Object> {
    }
}

