/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.extension.internal.loader.validation;

import org.mule.runtime.api.meta.NamedObject;
import org.mule.runtime.api.meta.model.ExtensionModel;
import org.mule.runtime.api.meta.model.parameter.ParameterGroupModel;
import org.mule.runtime.api.meta.model.parameter.ParameterizedModel;
import org.mule.runtime.api.meta.model.util.ExtensionWalker;
import org.mule.runtime.extension.api.loader.ExtensionModelValidator;
import org.mule.runtime.extension.api.loader.Problem;
import org.mule.runtime.extension.api.loader.ProblemsReporter;
import org.mule.runtime.module.extension.internal.loader.java.property.CompileTimeModelProperty;
import org.mule.runtime.module.extension.internal.loader.java.property.ParameterGroupModelProperty;

public final class ParameterGroupModelValidator
implements ExtensionModelValidator {
    public void validate(ExtensionModel extensionModel, final ProblemsReporter problemsReporter) {
        final boolean isCompileTime = extensionModel.getModelProperty(CompileTimeModelProperty.class).isPresent();
        new ExtensionWalker(){

            protected void onParameterGroup(ParameterizedModel owner, ParameterGroupModel model) {
                ParameterGroupModelValidator.this.validateIsInstantiable(model, problemsReporter);
                if (isCompileTime) {
                    ParameterGroupModelValidator.this.validateNonEmptyGroup(model, problemsReporter);
                }
            }
        }.walk(extensionModel);
    }

    private void validateIsInstantiable(ParameterGroupModel groupModel, ProblemsReporter problemsReporter) {
        groupModel.getModelProperty(ParameterGroupModelProperty.class).map(ParameterGroupModelProperty::getDescriptor).ifPresent(group -> {
            if (!group.getType().isInstantiable()) {
                problemsReporter.addError(new Problem((NamedObject)groupModel, String.format("The parameter group of type '%s' should be non abstract with a default constructor.", group.getType().getDeclaringClass())));
            }
        });
    }

    private void validateNonEmptyGroup(ParameterGroupModel groupModel, ProblemsReporter problemsReporter) {
        if (groupModel.getParameterModels().isEmpty()) {
            problemsReporter.addError(new Problem((NamedObject)groupModel, "ParameterGroups cannot be empty. At least one user-facing parameter should be declared, but none was found."));
        }
    }
}

