/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.extension.internal.runtime.operation;

import org.mule.runtime.api.meta.model.ExtensionModel;
import org.mule.runtime.api.meta.model.operation.OperationModel;
import org.mule.runtime.core.api.extension.ExtensionManager;
import org.mule.runtime.core.api.retry.policy.RetryPolicyTemplate;
import org.mule.runtime.core.api.streaming.CursorProviderFactory;
import org.mule.runtime.core.internal.policy.PolicyManager;
import org.mule.runtime.extension.api.runtime.config.ConfigurationProvider;
import org.mule.runtime.extension.api.runtime.operation.CompletableComponentExecutor;
import org.mule.runtime.module.extension.api.runtime.privileged.ExecutionContextAdapter;
import org.mule.runtime.module.extension.internal.runtime.connectivity.oauth.ExtensionsOAuthUtils;
import org.mule.runtime.module.extension.internal.runtime.operation.DefaultExecutionMediator;
import org.mule.runtime.module.extension.internal.runtime.operation.OperationMessageProcessor;
import org.mule.runtime.module.extension.internal.runtime.resolver.ResolverSet;
import org.mule.runtime.module.extension.internal.util.ReflectionCache;

public class OAuthOperationMessageProcessor
extends OperationMessageProcessor {
    public OAuthOperationMessageProcessor(ExtensionModel extensionModel, OperationModel operationModel, ConfigurationProvider configurationProvider, String target, String targetValue, ResolverSet resolverSet, CursorProviderFactory cursorProviderFactory, RetryPolicyTemplate retryPolicyTemplate, ExtensionManager extensionManager, PolicyManager policyManager, ReflectionCache reflectionCache, DefaultExecutionMediator.ResultTransformer resultTransformer, long outerFluxTerminationTimeout) {
        super(extensionModel, operationModel, configurationProvider, target, targetValue, resolverSet, cursorProviderFactory, retryPolicyTemplate, extensionManager, policyManager, reflectionCache, resultTransformer, outerFluxTerminationTimeout);
    }

    @Override
    protected void executeOperation(ExecutionContextAdapter<OperationModel> operationContext, CompletableComponentExecutor.ExecutorCallback callback) {
        super.executeOperation(operationContext, this.refreshable(operationContext, callback));
    }

    private CompletableComponentExecutor.ExecutorCallback refreshable(final ExecutionContextAdapter<OperationModel> operationContext, final CompletableComponentExecutor.ExecutorCallback callback) {
        return new CompletableComponentExecutor.ExecutorCallback(){

            public void complete(Object value) {
                callback.complete(value);
            }

            public void error(Throwable e) {
                try {
                    if (ExtensionsOAuthUtils.refreshTokenIfNecessary(operationContext, e)) {
                        OAuthOperationMessageProcessor.super.executeOperation(operationContext, callback);
                    } else {
                        callback.error(e);
                    }
                }
                catch (Exception refreshException) {
                    callback.error((Throwable)refreshException);
                }
            }
        };
    }
}

