/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.extension.internal.runtime.source;

import java.util.Map;
import java.util.Optional;
import java.util.concurrent.Executor;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Consumer;
import javax.inject.Inject;
import org.mule.runtime.api.cluster.ClusterService;
import org.mule.runtime.api.component.Component;
import org.mule.runtime.api.connection.ConnectionException;
import org.mule.runtime.api.exception.DefaultMuleException;
import org.mule.runtime.api.exception.MuleException;
import org.mule.runtime.api.exception.MuleRuntimeException;
import org.mule.runtime.api.lifecycle.Initialisable;
import org.mule.runtime.api.lifecycle.InitialisationException;
import org.mule.runtime.api.lifecycle.Lifecycle;
import org.mule.runtime.api.lifecycle.LifecycleException;
import org.mule.runtime.api.meta.model.ComponentModel;
import org.mule.runtime.api.meta.model.ExtensionModel;
import org.mule.runtime.api.meta.model.config.ConfigurationModel;
import org.mule.runtime.api.meta.model.parameter.ParameterizedModel;
import org.mule.runtime.api.meta.model.source.SourceModel;
import org.mule.runtime.api.notification.NotificationListenerRegistry;
import org.mule.runtime.api.scheduler.Scheduler;
import org.mule.runtime.api.scheduler.SchedulerService;
import org.mule.runtime.api.tx.TransactionType;
import org.mule.runtime.api.util.LazyValue;
import org.mule.runtime.core.api.MuleContext;
import org.mule.runtime.core.api.connector.ConnectionManager;
import org.mule.runtime.core.api.el.ExpressionManager;
import org.mule.runtime.core.api.event.CoreEvent;
import org.mule.runtime.core.api.extension.ExtensionManager;
import org.mule.runtime.core.api.lifecycle.LifecycleState;
import org.mule.runtime.core.api.lifecycle.LifecycleStateEnabled;
import org.mule.runtime.core.api.lifecycle.LifecycleUtils;
import org.mule.runtime.core.api.lifecycle.PrimaryNodeLifecycleNotificationListener;
import org.mule.runtime.core.api.processor.Processor;
import org.mule.runtime.core.api.retry.RetryCallback;
import org.mule.runtime.core.api.retry.RetryContext;
import org.mule.runtime.core.api.retry.async.AsynchronousRetryTemplate;
import org.mule.runtime.core.api.retry.policy.RetryPolicyTemplate;
import org.mule.runtime.core.api.rx.Exceptions;
import org.mule.runtime.core.api.source.MessageSource;
import org.mule.runtime.core.api.streaming.CursorProviderFactory;
import org.mule.runtime.core.api.transaction.MuleTransactionConfig;
import org.mule.runtime.core.api.transaction.TransactionConfig;
import org.mule.runtime.core.api.transaction.TransactionFactory;
import org.mule.runtime.core.api.util.ExceptionUtils;
import org.mule.runtime.core.api.util.func.CheckedRunnable;
import org.mule.runtime.core.internal.execution.ExceptionCallback;
import org.mule.runtime.core.internal.lifecycle.DefaultLifecycleManager;
import org.mule.runtime.core.internal.retry.ReconnectionConfig;
import org.mule.runtime.core.internal.util.MessagingExceptionResolver;
import org.mule.runtime.core.privileged.PrivilegedMuleContext;
import org.mule.runtime.core.privileged.event.BaseEventContext;
import org.mule.runtime.core.privileged.exception.ErrorTypeLocator;
import org.mule.runtime.core.privileged.execution.MessageProcessContext;
import org.mule.runtime.core.privileged.execution.MessageProcessingManager;
import org.mule.runtime.extension.api.runtime.config.ConfigurationInstance;
import org.mule.runtime.extension.api.runtime.config.ConfigurationProvider;
import org.mule.runtime.extension.api.runtime.config.ConfigurationStats;
import org.mule.runtime.extension.api.runtime.config.ConfiguredComponent;
import org.mule.runtime.extension.api.runtime.source.ParameterizedSource;
import org.mule.runtime.module.extension.internal.runtime.ExtensionComponent;
import org.mule.runtime.module.extension.internal.runtime.config.MutableConfigurationStats;
import org.mule.runtime.module.extension.internal.runtime.exception.ExceptionHandlerManager;
import org.mule.runtime.module.extension.internal.runtime.operation.IllegalSourceException;
import org.mule.runtime.module.extension.internal.runtime.resolver.ObjectBasedParameterValueResolver;
import org.mule.runtime.module.extension.internal.runtime.resolver.ParameterValueResolver;
import org.mule.runtime.module.extension.internal.runtime.source.DefaultSourceCallback;
import org.mule.runtime.module.extension.internal.runtime.source.SourceAdapter;
import org.mule.runtime.module.extension.internal.runtime.source.SourceAdapterFactory;
import org.mule.runtime.module.extension.internal.runtime.source.SourceCallbackFactory;
import org.mule.runtime.module.extension.internal.runtime.source.SourceConnectionManager;
import org.mule.runtime.module.extension.internal.util.MuleExtensionUtils;
import org.mule.runtime.module.extension.internal.util.ReflectionCache;
import org.reactivestreams.Publisher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import reactor.core.publisher.Mono;

public class ExtensionMessageSource
extends ExtensionComponent<SourceModel>
implements MessageSource,
ExceptionCallback<ConnectionException>,
ParameterizedSource,
ConfiguredComponent,
LifecycleStateEnabled {
    private static final Logger LOGGER = LoggerFactory.getLogger(ExtensionMessageSource.class);
    @Inject
    private MessageProcessingManager messageProcessingManager;
    @Inject
    private SchedulerService schedulerService;
    @Inject
    private NotificationListenerRegistry notificationListenerRegistry;
    @Inject
    private ReflectionCache reflectionCache;
    @Inject
    private ExpressionManager expressionManager;
    @Inject
    private ClusterService clusterService;
    private final SourceModel sourceModel;
    private final SourceAdapterFactory sourceAdapterFactory;
    private final boolean primaryNodeOnly;
    private final RetryPolicyTemplate customRetryPolicyTemplate;
    private final MessageSource.BackPressureStrategy backPressureStrategy;
    private final ExceptionHandlerManager exceptionEnricherManager;
    private final AtomicBoolean reconnecting = new AtomicBoolean(false);
    private final DefaultLifecycleManager<ExtensionMessageSource> lifecycleManager;
    private SourceConnectionManager sourceConnectionManager;
    private Processor messageProcessor;
    private LazyValue<TransactionConfig> transactionConfig = new LazyValue(this::buildTransactionConfig);
    private SourceAdapter sourceAdapter;
    private RetryPolicyTemplate retryPolicyTemplate;
    private Scheduler retryScheduler;
    private Scheduler flowTriggerScheduler;
    private AtomicBoolean started = new AtomicBoolean(false);

    public ExtensionMessageSource(ExtensionModel extensionModel, SourceModel sourceModel, SourceAdapterFactory sourceAdapterFactory, ConfigurationProvider configurationProvider, boolean primaryNodeOnly, RetryPolicyTemplate retryPolicyTemplate, CursorProviderFactory cursorProviderFactory, MessageSource.BackPressureStrategy backPressureStrategy, ExtensionManager managerAdapter) {
        super(extensionModel, sourceModel, configurationProvider, cursorProviderFactory, managerAdapter);
        this.sourceModel = sourceModel;
        this.sourceAdapterFactory = sourceAdapterFactory;
        this.customRetryPolicyTemplate = retryPolicyTemplate;
        this.primaryNodeOnly = primaryNodeOnly;
        this.backPressureStrategy = backPressureStrategy;
        this.exceptionEnricherManager = new ExceptionHandlerManager(extensionModel, (ComponentModel)sourceModel);
        this.lifecycleManager = new DefaultLifecycleManager(sourceModel.getName(), (Lifecycle)this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized void createSource(boolean restarting) throws Exception {
        if (this.sourceAdapter == null) {
            CoreEvent initialiserEvent = null;
            try {
                initialiserEvent = org.mule.runtime.module.extension.api.util.MuleExtensionUtils.getInitialiserEvent(this.muleContext);
                Optional<ConfigurationInstance> configurationInstance = this.startUsingConfiguration(initialiserEvent);
                this.sourceAdapter = this.sourceAdapterFactory.createAdapter(configurationInstance, this.createSourceCallbackFactory(), (Component)this, this.sourceConnectionManager, new MessagingExceptionResolver((Component)this), restarting);
                this.muleContext.getInjector().inject((Object)this.sourceAdapter);
                this.retryPolicyTemplate = this.createRetryPolicyTemplate(this.customRetryPolicyTemplate);
                LifecycleUtils.initialiseIfNeeded((Object)this.retryPolicyTemplate, (boolean)true, (MuleContext)this.muleContext);
            }
            finally {
                if (initialiserEvent != null) {
                    ((BaseEventContext)initialiserEvent.getContext()).success();
                }
            }
        }
    }

    private void startSource(boolean restarting) throws MuleException {
        try {
            if (restarting && !this.retryPolicyTemplate.isAsync()) {
                new AsynchronousRetryTemplate(this.retryPolicyTemplate).execute((RetryCallback)new StartSourceCallback(restarting), (Executor)this.retryScheduler);
            } else {
                this.retryPolicyTemplate.execute((RetryCallback)new StartSourceCallback(restarting), (Executor)this.retryScheduler);
            }
        }
        catch (Throwable e) {
            if (e instanceof MuleException) {
                throw (MuleException)e;
            }
            throw new MuleRuntimeException(e);
        }
    }

    private void startSource() throws MuleException {
        this.startSource(false);
    }

    private RetryPolicyTemplate createRetryPolicyTemplate(RetryPolicyTemplate customTemplate) {
        return this.getConfigurationInstance().map(config -> config.getConnectionProvider().orElse(null)).map(provider -> this.connectionManager.getReconnectionConfigFor(provider).getRetryPolicyTemplate(customTemplate)).orElseGet(() -> customTemplate != null ? customTemplate : ReconnectionConfig.getDefault().getRetryPolicyTemplate());
    }

    private void stopSource() throws MuleException {
        if (this.sourceAdapter != null) {
            try {
                CoreEvent initialiserEvent = org.mule.runtime.module.extension.api.util.MuleExtensionUtils.getInitialiserEvent(this.muleContext);
                this.stopUsingConfiguration(initialiserEvent);
                this.sourceAdapter.stop();
                if (this.usesDynamicConfiguration()) {
                    this.disposeSource();
                }
            }
            catch (Exception e) {
                throw new DefaultMuleException(String.format("Found exception stopping source '%s' of root component '%s'", this.sourceAdapter.getName(), this.getLocation().getRootContainerName()), (Throwable)e);
            }
        }
    }

    public Optional<ConfigurationInstance> getConfigurationInstance() {
        return this.sourceAdapter.getConfigurationInstance();
    }

    private SourceCallbackFactory createSourceCallbackFactory() {
        return completionHandlerFactory -> DefaultSourceCallback.builder().setExceptionCallback(this).setSourceModel(this.sourceModel).setConfigurationInstance(this.getConfigurationInstance().orElse(null)).setTransactionConfig((TransactionConfig)this.transactionConfig.get()).setSource(this).setListener(this.messageProcessor).setProcessingManager(this.messageProcessingManager).setMuleContext(this.muleContext).setProcessContextSupplier(this::createProcessingContext).setCursorStreamProviderFactory(this.getCursorProviderFactory()).setCompletionHandlerFactory(completionHandlerFactory).build();
    }

    public void onException(ConnectionException exception) {
        if (!this.reconnecting.compareAndSet(false, true)) {
            LOGGER.error(String.format("Message source '%s' on flow '%s' found connection error but reconnection is already in progress. Error was: %s", this.sourceModel.getName(), this.getLocation().getRootContainerName(), exception.getMessage()), (Throwable)exception);
            return;
        }
        LOGGER.warn(String.format("Message source '%s' on flow '%s' threw exception. Attempting to reconnect...", this.sourceAdapter.getName(), this.getLocation().getRootContainerName()), (Throwable)exception);
        Mono reconnectionAction = this.sourceAdapter.getReconnectionAction(exception).map(p -> Mono.from((Publisher)this.retryPolicyTemplate.applyPolicy(p, this.retryScheduler))).orElseGet(() -> Mono.create(sink -> {
            try {
                exception.getConnection().ifPresent(this.sourceConnectionManager::invalidate);
                this.restart();
                sink.success();
            }
            catch (Exception e) {
                sink.error((Throwable)e);
            }
        }));
        reconnectionAction.doOnSuccess(v -> this.onReconnectionSuccessful()).doOnError(this::onReconnectionFailed).doAfterTerminate(() -> this.reconnecting.set(false)).subscribe();
    }

    private void onReconnectionSuccessful() {
        if (LOGGER.isWarnEnabled()) {
            LOGGER.warn("Message source '{}' on flow '{}' successfully reconnected", (Object)this.sourceModel.getName(), (Object)this.getLocation().getRootContainerName());
        }
    }

    private void onReconnectionFailed(Throwable exception) {
        LOGGER.error(String.format("Message source '%s' on flow '%s' could not be reconnected. Will be shutdown. %s", this.sourceModel.getName(), this.getLocation().getRootContainerName(), exception.getMessage()), exception);
        this.shutdown();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void restart() throws MuleException {
        AtomicBoolean atomicBoolean = this.started;
        synchronized (atomicBoolean) {
            if (this.started.get()) {
                this.stopSource();
                this.disposeSource();
                this.startSource(true);
            } else {
                LOGGER.warn(String.format("Message source '%s' on flow '%s' is stopped. Not doing restart", this.getLocation().getRootContainerName(), this.getLocation().getRootContainerName()));
            }
        }
    }

    @Override
    public void doStart() throws MuleException {
        if (this.shouldRunOnThisNode()) {
            this.reallyDoStart();
        }
    }

    private void reallyDoStart() throws MuleException {
        this.lifecycle(() -> this.lifecycleManager.fireStartPhase((phase, o) -> {
            LifecycleUtils.startIfNeeded((Object)this.retryPolicyTemplate);
            if (this.retryScheduler == null) {
                this.retryScheduler = this.schedulerService.ioScheduler();
            }
            if (this.flowTriggerScheduler == null) {
                this.flowTriggerScheduler = this.schedulerService.cpuLightScheduler();
            }
            AtomicBoolean atomicBoolean = this.started;
            synchronized (atomicBoolean) {
                this.startSource();
                this.started.set(true);
            }
        }));
    }

    @Override
    public void doStop() throws MuleException {
        this.safeLifecycle(() -> this.lifecycleManager.fireStopPhase((phase, o) -> {
            AtomicBoolean atomicBoolean = this.started;
            synchronized (atomicBoolean) {
                this.started.set(false);
                this.stopSource();
            }
            this.stopSchedulers();
        }));
    }

    @Override
    public void doDispose() {
        try {
            this.safeLifecycle(() -> this.lifecycleManager.fireDisposePhase((phase, o) -> {
                this.disposeSource();
                LifecycleUtils.stopIfNeeded((Object)this.retryPolicyTemplate);
                LifecycleUtils.disposeIfNeeded((Object)this.retryPolicyTemplate, (Logger)LOGGER);
                this.stopSchedulers();
            }));
        }
        catch (MuleException e) {
            LOGGER.warn(String.format("Failed to dispose message source at root element '%s'. %s", this.getLocation().getRootContainerName(), e.getMessage()), (Throwable)e);
        }
    }

    private void lifecycle(CheckedRunnable runnable) throws MuleException {
        try {
            runnable.run();
        }
        catch (Throwable e) {
            this.handleLifecycleException(e, false);
        }
    }

    private void safeLifecycle(CheckedRunnable runnable) throws MuleException {
        try {
            runnable.run();
        }
        catch (Throwable e) {
            this.handleLifecycleException(e, true);
        }
    }

    private void handleLifecycleException(Throwable e, boolean unwrapLifecycleException) throws MuleException {
        e = Exceptions.unwrap((Throwable)e);
        if (unwrapLifecycleException && e instanceof LifecycleException && e.getCause() != null) {
            e = e.getCause();
        }
        if (e instanceof IllegalStateException) {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("Skipping lifecycle phase: " + e.getMessage(), e);
            }
        } else {
            if (e instanceof MuleException) {
                throw (MuleException)e;
            }
            throw new DefaultMuleException(e);
        }
    }

    private void shutdown() {
        try {
            LifecycleUtils.stopIfNeeded((Object)((Object)this));
        }
        catch (Exception e) {
            LOGGER.error(String.format("Failed to stop source '%s' on flow '%s'", this.sourceAdapter.getName(), this.getLocation().getRootContainerName()), (Throwable)e);
        }
        LifecycleUtils.disposeIfNeeded((Object)((Object)this), (Logger)LOGGER);
    }

    private void stopSchedulers() {
        if (this.retryScheduler != null) {
            try {
                this.retryScheduler.stop();
            }
            finally {
                this.retryScheduler = null;
            }
        }
        if (this.flowTriggerScheduler != null) {
            try {
                this.flowTriggerScheduler.stop();
            }
            finally {
                this.flowTriggerScheduler = null;
            }
        }
    }

    private void disposeSource() {
        LifecycleUtils.disposeIfNeeded((Object)this.sourceAdapter, (Logger)LOGGER);
        this.sourceAdapter = null;
    }

    private TransactionConfig buildTransactionConfig() {
        MuleTransactionConfig transactionConfig = new MuleTransactionConfig();
        transactionConfig.setAction(MuleExtensionUtils.toActionCode(this.sourceAdapter.getTransactionalAction()));
        transactionConfig.setMuleContext(this.muleContext);
        TransactionType transactionalType = this.sourceAdapter.getTransactionalType();
        transactionConfig.setFactory((TransactionFactory)this.transactionFactoryLocator.lookUpTransactionFactory(transactionalType).orElseThrow(() -> new IllegalStateException(String.format("Unable to create Source with Transactions of Type: [%s]. No factory available for this transaction type", transactionalType))));
        return transactionConfig;
    }

    SourceConnectionManager getSourceConnectionManager() {
        return this.sourceConnectionManager;
    }

    private MessageProcessContext createProcessingContext() {
        return new MessageProcessContext(){

            public boolean supportsAsynchronousProcessing() {
                return true;
            }

            public MessageSource getMessageSource() {
                return ExtensionMessageSource.this;
            }

            public Scheduler getFlowExecutionExecutor() {
                return ExtensionMessageSource.this.flowTriggerScheduler;
            }

            public Optional<TransactionConfig> getTransactionConfig() {
                return ExtensionMessageSource.this.sourceModel.isTransactional() ? Optional.of(ExtensionMessageSource.this.transactionConfig.get()) : Optional.empty();
            }

            public ClassLoader getExecutionClassLoader() {
                return ExtensionMessageSource.this.muleContext.getExecutionClassLoader();
            }

            public ErrorTypeLocator getErrorTypeLocator() {
                return ((PrivilegedMuleContext)ExtensionMessageSource.this.muleContext).getErrorTypeLocator();
            }
        };
    }

    public void setListener(Processor listener) {
        this.messageProcessor = listener;
    }

    @Override
    protected void validateOperationConfiguration(ConfigurationProvider configurationProvider) {
        ConfigurationModel configurationModel = configurationProvider.getConfigurationModel();
        if (!configurationModel.getSourceModel(this.sourceModel.getName()).isPresent() && !configurationProvider.getExtensionModel().getSourceModel(this.sourceModel.getName()).isPresent()) {
            throw new IllegalSourceException(String.format("Root component '%s' defines an usage of operation '%s' which points to configuration '%s'. The selected config does not support that operation.", this.getLocation().getRootContainerName(), this.sourceModel.getName(), configurationProvider.getName()));
        }
    }

    @Override
    protected ParameterValueResolver getParameterValueResolver() {
        return new ObjectBasedParameterValueResolver(this.sourceAdapter.getDelegate(), (ParameterizedModel)this.sourceModel, this.reflectionCache);
    }

    @Override
    protected void doInitialise() throws InitialisationException {
        if (this.shouldRunOnThisNode()) {
            this.reallyDoInitialise();
        } else {
            new PrimaryNodeLifecycleNotificationListener(() -> {
                this.reallyDoInitialise();
                this.reallyDoStart();
            }, this.notificationListenerRegistry).register();
        }
    }

    private void reallyDoInitialise() throws InitialisationException {
        try {
            this.lifecycle(() -> this.lifecycleManager.fireInitialisePhase((phase, o) -> {
                this.sourceConnectionManager = new SourceConnectionManager((ConnectionManager)this.connectionManager);
                try {
                    this.createSource(false);
                    LifecycleUtils.initialiseIfNeeded((Object)this.sourceAdapter);
                }
                catch (Exception e) {
                    throw new InitialisationException((Throwable)e, (Initialisable)this);
                }
            }));
        }
        catch (MuleException e) {
            if (e instanceof InitialisationException) {
                throw (InitialisationException)((Object)e);
            }
            throw new InitialisationException((Throwable)e, (Initialisable)this);
        }
    }

    /*
     * Exception decompiling
     */
    public Map<String, Object> getInitialisationParameters() {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public MessageSource.BackPressureStrategy getBackPressureStrategy() {
        return this.backPressureStrategy;
    }

    public LifecycleState getLifecycleState() {
        return this.lifecycleManager.getState();
    }

    private boolean shouldRunOnThisNode() {
        return this.primaryNodeOnly ? this.clusterService.isPrimaryPollingInstance() : true;
    }

    private Optional<ConfigurationInstance> startUsingConfiguration(CoreEvent event) {
        return this.getConfigurationAndTryToMutateStats(event, mutableConfigurationStats -> mutableConfigurationStats.addRunningSource());
    }

    private void stopUsingConfiguration(CoreEvent event) {
        this.getConfigurationAndTryToMutateStats(event, mutableConfigurationStats -> mutableConfigurationStats.discountRunningSource());
    }

    private Optional<ConfigurationInstance> getConfigurationAndTryToMutateStats(CoreEvent event, Consumer<MutableConfigurationStats> mutableConfigurationStatsConsumer) {
        Optional<ConfigurationInstance> configurationInstanceOptional = this.getConfiguration(event);
        configurationInstanceOptional.ifPresent(configurationInstance -> {
            ConfigurationStats configurationStats = configurationInstance.getStatistics();
            if (configurationStats instanceof MutableConfigurationStats) {
                mutableConfigurationStatsConsumer.accept((MutableConfigurationStats)configurationStats);
            }
        });
        return configurationInstanceOptional;
    }

    private class StartSourceCallback
    implements RetryCallback {
        boolean restarting;

        StartSourceCallback(boolean restarting) {
            this.restarting = restarting;
        }

        public void doWork(RetryContext context) throws Exception {
            try {
                ExtensionMessageSource.this.createSource(this.restarting);
                LifecycleUtils.initialiseIfNeeded((Object)ExtensionMessageSource.this.sourceAdapter);
                ExtensionMessageSource.this.sourceAdapter.start();
                ExtensionMessageSource.this.reconnecting.set(false);
            }
            catch (Exception e) {
                try {
                    ExtensionMessageSource.this.stopSource();
                }
                catch (Exception eStop) {
                    e.addSuppressed(eStop);
                }
                try {
                    ExtensionMessageSource.this.disposeSource();
                }
                catch (Exception eDispose) {
                    e.addSuppressed(eDispose);
                }
                Throwable throwable = ExtensionMessageSource.this.exceptionEnricherManager.process(e);
                Optional connectionException = ExceptionUtils.extractConnectionException((Throwable)throwable);
                if (connectionException.isPresent()) {
                    throwable = (Throwable)connectionException.get();
                }
                throw throwable instanceof Exception ? (Exception)throwable : new MuleRuntimeException(throwable);
            }
        }

        public String getWorkDescription() {
            return "Message Source Reconnection";
        }

        public Object getWorkOwner() {
            return ExtensionMessageSource.this;
        }
    }
}

