/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.extension.internal.loader.enricher;

import java.lang.reflect.Field;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.mule.metadata.api.ClassTypeLoader;
import org.mule.metadata.api.model.MetadataType;
import org.mule.runtime.api.meta.ExpressionSupport;
import org.mule.runtime.api.meta.model.ModelProperty;
import org.mule.runtime.api.meta.model.declaration.fluent.BaseDeclaration;
import org.mule.runtime.api.meta.model.declaration.fluent.ConfigurationDeclaration;
import org.mule.runtime.api.meta.model.declaration.fluent.ConnectedDeclaration;
import org.mule.runtime.api.meta.model.declaration.fluent.ConnectionProviderDeclaration;
import org.mule.runtime.api.meta.model.declaration.fluent.ExtensionDeclaration;
import org.mule.runtime.api.meta.model.declaration.fluent.OperationDeclaration;
import org.mule.runtime.api.meta.model.declaration.fluent.OutputDeclaration;
import org.mule.runtime.api.meta.model.declaration.fluent.ParameterDeclaration;
import org.mule.runtime.api.meta.model.declaration.fluent.ParameterGroupDeclaration;
import org.mule.runtime.api.meta.model.declaration.fluent.util.DeclarationWalker;
import org.mule.runtime.api.meta.model.display.LayoutModel;
import org.mule.runtime.api.meta.model.operation.ExecutionType;
import org.mule.runtime.api.meta.model.parameter.ParameterRole;
import org.mule.runtime.api.util.Reference;
import org.mule.runtime.extension.api.annotation.Expression;
import org.mule.runtime.extension.api.annotation.connectivity.oauth.OAuthCallbackValue;
import org.mule.runtime.extension.api.annotation.connectivity.oauth.OAuthParameter;
import org.mule.runtime.extension.api.connectivity.oauth.AuthorizationCodeGrantType;
import org.mule.runtime.extension.api.connectivity.oauth.ClientCredentialsGrantType;
import org.mule.runtime.extension.api.connectivity.oauth.OAuthGrantTypeVisitor;
import org.mule.runtime.extension.api.connectivity.oauth.OAuthModelProperty;
import org.mule.runtime.extension.api.connectivity.oauth.OAuthParameterModelProperty;
import org.mule.runtime.extension.api.declaration.type.ExtensionsTypeLoaderFactory;
import org.mule.runtime.extension.api.exception.IllegalConnectionProviderModelDefinitionException;
import org.mule.runtime.extension.api.loader.DeclarationEnricher;
import org.mule.runtime.extension.api.loader.DeclarationEnricherPhase;
import org.mule.runtime.extension.api.loader.ExtensionLoadingContext;
import org.mule.runtime.module.extension.api.loader.java.property.ComponentExecutorModelProperty;
import org.mule.runtime.module.extension.internal.loader.enricher.AbstractAnnotatedDeclarationEnricher;
import org.mule.runtime.module.extension.internal.loader.java.property.DeclaringMemberModelProperty;
import org.mule.runtime.module.extension.internal.loader.java.property.oauth.OAuthCallbackValuesModelProperty;
import org.mule.runtime.module.extension.internal.runtime.connectivity.oauth.UnauthorizeOperationExecutor;
import org.mule.runtime.module.extension.internal.util.IntrospectionUtils;

public class JavaOAuthDeclarationEnricher
implements DeclarationEnricher {
    public DeclarationEnricherPhase getExecutionPhase() {
        return DeclarationEnricherPhase.STRUCTURE;
    }

    public void enrich(ExtensionLoadingContext extensionLoadingContext) {
        new EnricherDelegate().enrich(extensionLoadingContext);
    }

    private class EnricherDelegate
    extends AbstractAnnotatedDeclarationEnricher {
        private final ClassTypeLoader typeLoader = ExtensionsTypeLoaderFactory.getDefault().createTypeLoader();
        private final MetadataType stringType = this.typeLoader.load(String.class);
        private final MetadataType voidType = this.typeLoader.load(Void.TYPE);

        private EnricherDelegate() {
        }

        public void enrich(ExtensionLoadingContext extensionLoadingContext) {
            ExtensionDeclaration extensionDeclaration = (ExtensionDeclaration)extensionLoadingContext.getExtensionDeclarer().getDeclaration();
            final HashSet visitedProviders = new HashSet();
            final HashSet oauthConfigs = new HashSet();
            final Reference oauthGloballySupported = new Reference((Object)false);
            final Reference supportsAuthCode = new Reference((Object)false);
            final Reference supportsClientCredentials = new Reference((Object)false);
            new DeclarationWalker(){

                protected void onConnectionProvider(ConnectedDeclaration owner, ConnectionProviderDeclaration declaration) {
                    if (!visitedProviders.add(new Reference((Object)declaration))) {
                        return;
                    }
                    declaration.getModelProperty(OAuthModelProperty.class).ifPresent(mp -> {
                        mp.getGrantTypes().forEach(grantType -> grantType.accept(new OAuthGrantTypeVisitor(){

                            public void visit(AuthorizationCodeGrantType grantType) {
                                supportsAuthCode.set((Object)true);
                            }

                            public void visit(ClientCredentialsGrantType grantType) {
                                supportsClientCredentials.set((Object)true);
                            }
                        }));
                        if (owner instanceof ExtensionDeclaration) {
                            oauthGloballySupported.set((Object)true);
                        } else if (owner instanceof ConfigurationDeclaration) {
                            oauthConfigs.add(new Reference((Object)((ConfigurationDeclaration)owner)));
                        }
                        EnricherDelegate.this.enrichOAuthParameters(declaration);
                        EnricherDelegate.this.extractImplementingType((BaseDeclaration<? extends BaseDeclaration>)declaration).ifPresent(type -> EnricherDelegate.this.enrichCallbackValues(declaration, type));
                    });
                }
            }.walk(extensionDeclaration);
            List<ConfigurationDeclaration> configs = (Boolean)oauthGloballySupported.get() != false ? extensionDeclaration.getConfigurations() : oauthConfigs.stream().map(Reference::get).collect(Collectors.toList());
            OperationDeclaration unauthorize = this.buildUnauthorizeOperation((Boolean)supportsAuthCode.get());
            configs.forEach(c -> c.addOperation(unauthorize));
        }

        private void enrichOAuthParameters(ConnectionProviderDeclaration declaration) {
            declaration.getAllParameters().forEach(p -> p.getModelProperty(DeclaringMemberModelProperty.class).map(DeclaringMemberModelProperty::getDeclaringField).ifPresent(field -> {
                OAuthParameter annotation = field.getAnnotation(OAuthParameter.class);
                if (annotation != null) {
                    this.validateExpressionSupport(declaration, (ParameterDeclaration)p, (Field)field);
                    p.setExpressionSupport(ExpressionSupport.NOT_SUPPORTED);
                    p.addModelProperty((ModelProperty)new OAuthParameterModelProperty(annotation.requestAlias(), annotation.placement()));
                }
            }));
        }

        private void validateExpressionSupport(ConnectionProviderDeclaration provider, ParameterDeclaration parameter, Field field) {
            Expression expression = field.getAnnotation(Expression.class);
            if (expression != null && expression.value() != ExpressionSupport.NOT_SUPPORTED) {
                throw new IllegalConnectionProviderModelDefinitionException(String.format("Parameter '%s' in Connection Provider '%s' is marked as supporting expressions. Expressions are not supported in OAuth parameters", parameter.getName(), provider.getName()));
            }
        }

        private void enrichCallbackValues(ConnectionProviderDeclaration declaration, Class type) {
            Map<Field, String> values = IntrospectionUtils.getAnnotatedFields(type, OAuthCallbackValue.class).stream().collect(Collectors.toMap(Function.identity(), field -> field.getAnnotation(OAuthCallbackValue.class).expression()));
            if (!values.isEmpty()) {
                declaration.addModelProperty((ModelProperty)new OAuthCallbackValuesModelProperty(values));
            }
        }

        private OperationDeclaration buildUnauthorizeOperation(boolean supportsAuthCode) {
            OperationDeclaration operation = new OperationDeclaration("unauthorize");
            operation.setDescription("Deletes all the access token information of a given resource owner id so that it's impossible to execute any operation for that user without doing the authorization dance again");
            operation.setBlocking(true);
            operation.setExecutionType(ExecutionType.BLOCKING);
            operation.setOutput(this.toDeclaration(this.voidType));
            operation.setOutputAttributes(this.toDeclaration(this.voidType));
            operation.setRequiresConnection(false);
            operation.setSupportsStreaming(false);
            operation.setTransactional(false);
            operation.addModelProperty((ModelProperty)new ComponentExecutorModelProperty((model, params) -> new UnauthorizeOperationExecutor()));
            if (supportsAuthCode) {
                ParameterGroupDeclaration group = operation.getParameterGroup("General");
                group.showInDsl(false);
                ParameterDeclaration parameter = new ParameterDeclaration("resourceOwnerId");
                parameter.setDescription("The id of the resource owner which access should be invalidated");
                parameter.setExpressionSupport(ExpressionSupport.SUPPORTED);
                parameter.setLayoutModel(LayoutModel.builder().build());
                parameter.setRequired(false);
                parameter.setParameterRole(ParameterRole.BEHAVIOUR);
                parameter.setType(this.stringType, false);
                group.addParameter(parameter);
            }
            return operation;
        }

        private OutputDeclaration toDeclaration(MetadataType type) {
            OutputDeclaration declaration = new OutputDeclaration();
            declaration.setType(type, false);
            return declaration;
        }
    }
}

