/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.extension.internal.runtime.source;

import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import java.util.function.Function;
import org.mule.runtime.api.exception.MuleException;
import org.mule.runtime.api.message.Message;
import org.mule.runtime.core.api.event.CoreEvent;
import org.mule.runtime.core.api.functional.Either;
import org.mule.runtime.core.api.processor.Processor;
import org.mule.runtime.core.api.util.func.CheckedConsumer;
import org.mule.runtime.core.api.util.func.CheckedFunction;
import org.mule.runtime.core.internal.exception.MessagingException;
import org.mule.runtime.core.internal.execution.ModuleFlowProcessingPhaseTemplate;
import org.mule.runtime.core.internal.execution.NotificationFunction;
import org.mule.runtime.module.extension.internal.runtime.source.SourceCompletionHandler;
import org.reactivestreams.Publisher;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

final class ModuleFlowProcessingTemplate
implements ModuleFlowProcessingPhaseTemplate {
    private final Message message;
    private final Processor messageProcessor;
    private final List<NotificationFunction> notificationFunctions;
    private final SourceCompletionHandler completionHandler;

    ModuleFlowProcessingTemplate(Message message, Processor messageProcessor, List<NotificationFunction> notificationFunctions, SourceCompletionHandler completionHandler) {
        this.message = message;
        this.messageProcessor = messageProcessor;
        this.notificationFunctions = notificationFunctions;
        this.completionHandler = completionHandler;
    }

    public CheckedFunction<CoreEvent, Map<String, Object>> getSuccessfulExecutionResponseParametersFunction() {
        return this.completionHandler::createResponseParameters;
    }

    public CheckedFunction<CoreEvent, Map<String, Object>> getFailedExecutionResponseParametersFunction() {
        return this.completionHandler::createFailureResponseParameters;
    }

    public Message getMessage() {
        return this.message;
    }

    public List<NotificationFunction> getNotificationFunctions() {
        return this.notificationFunctions;
    }

    public CoreEvent routeEvent(CoreEvent muleEvent) throws MuleException {
        return this.messageProcessor.process(muleEvent);
    }

    public Publisher<CoreEvent> routeEventAsync(CoreEvent event) {
        return Mono.just((Object)event).transform((Function)this.messageProcessor);
    }

    public Publisher<CoreEvent> routeEventAsync(Publisher<CoreEvent> eventPub) {
        return Flux.from(eventPub).transform((Function)this.messageProcessor);
    }

    public Publisher<Void> sendResponseToClient(CoreEvent response, Map<String, Object> parameters) {
        return this.completionHandler.onCompletion(response, parameters);
    }

    public Publisher<Void> sendFailureResponseToClient(MessagingException messagingException, Map<String, Object> parameters) {
        return this.completionHandler.onFailure(messagingException, parameters);
    }

    public void afterPhaseExecution(Either<MessagingException, CoreEvent> either) {
        either.apply((Consumer)((CheckedConsumer)messagingException -> this.completionHandler.onTerminate((Either<MessagingException, CoreEvent>)Either.left((Object)messagingException))), (Consumer)((CheckedConsumer)event -> this.completionHandler.onTerminate(either)));
    }
}

