/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.extension.internal.runtime.connectivity;

import java.util.function.Consumer;
import javax.inject.Inject;
import org.mule.runtime.api.connection.ConnectionException;
import org.mule.runtime.api.connection.ConnectionHandler;
import org.mule.runtime.api.meta.model.ComponentModel;
import org.mule.runtime.api.tx.TransactionException;
import org.mule.runtime.api.util.Preconditions;
import org.mule.runtime.core.api.util.ExceptionUtils;
import org.mule.runtime.core.api.util.StreamingUtils;
import org.mule.runtime.extension.api.runtime.operation.ExecutionContext;
import org.mule.runtime.extension.api.runtime.operation.Interceptor;
import org.mule.runtime.extension.internal.property.PagedOperationModelProperty;
import org.mule.runtime.module.extension.api.runtime.privileged.ExecutionContextAdapter;
import org.mule.runtime.module.extension.internal.runtime.connectivity.ExtensionConnectionSupplier;

public final class ConnectionInterceptor
implements Interceptor<ComponentModel> {
    private static final String CLOSE_CONNECTION_COMMAND = "closeCommand";
    @Inject
    private ExtensionConnectionSupplier connectionSupplier;

    public void before(ExecutionContext<ComponentModel> executionContext) throws Exception {
        ComponentModel componentModel = executionContext.getComponentModel();
        if (componentModel.getModelProperty(PagedOperationModelProperty.class).isPresent()) {
            return;
        }
        ExecutionContextAdapter context = (ExecutionContextAdapter)executionContext;
        Preconditions.checkArgument((context.getVariable("MULE_CONNECTION_PARAM") == null ? 1 : 0) != 0, (String)"A connection was already set for this operation context");
        context.setVariable("MULE_CONNECTION_PARAM", this.getConnection(context));
        if (!StreamingUtils.supportsStreaming((ComponentModel)componentModel)) {
            this.setCloseCommand(executionContext, () -> this.release(executionContext));
        }
    }

    public Throwable onError(ExecutionContext<ComponentModel> executionContext, Throwable exception) {
        if (ExceptionUtils.extractConnectionException((Throwable)exception).isPresent()) {
            this.setCloseCommand(executionContext, () -> this.withConnection(executionContext, ConnectionHandler::invalidate));
        } else {
            this.setCloseCommand(executionContext, () -> this.release(executionContext));
        }
        return exception;
    }

    public void after(ExecutionContext<ComponentModel> executionContext, Object result) {
        ExecutionContextAdapter context = (ExecutionContextAdapter)executionContext;
        Runnable closeCommand = (Runnable)context.removeVariable(CLOSE_CONNECTION_COMMAND);
        if (closeCommand != null) {
            closeCommand.run();
        }
    }

    private void release(ExecutionContext<ComponentModel> executionContext) {
        this.withConnection(executionContext, ConnectionHandler::release);
    }

    private void withConnection(ExecutionContext<ComponentModel> executionContext, Consumer<ConnectionHandler> consumer) {
        ConnectionHandler handler = (ConnectionHandler)((ExecutionContextAdapter)executionContext).removeVariable("MULE_CONNECTION_PARAM");
        if (handler != null) {
            consumer.accept(handler);
        }
    }

    private void setCloseCommand(ExecutionContext<ComponentModel> executionContext, Runnable command) {
        ExecutionContextAdapter context = (ExecutionContextAdapter)executionContext;
        context.setVariable(CLOSE_CONNECTION_COMMAND, command);
    }

    private ConnectionHandler<?> getConnection(ExecutionContextAdapter<? extends ComponentModel> operationContext) throws ConnectionException, TransactionException {
        return this.connectionSupplier.getConnection(operationContext);
    }
}

