/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.extension.internal.manager;

import com.github.benmanes.caffeine.cache.Caffeine;
import com.github.benmanes.caffeine.cache.LoadingCache;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.mule.runtime.api.artifact.Registry;
import org.mule.runtime.api.exception.MuleRuntimeException;
import org.mule.runtime.api.i18n.I18nMessageFactory;
import org.mule.runtime.api.meta.model.ExtensionModel;
import org.mule.runtime.api.meta.model.config.ConfigurationModel;
import org.mule.runtime.api.util.MultiMap;
import org.mule.runtime.api.util.collection.Collectors;
import org.mule.runtime.core.api.MuleContext;
import org.mule.runtime.core.privileged.registry.LegacyRegistryUtils;
import org.mule.runtime.core.privileged.registry.RegistrationException;
import org.mule.runtime.extension.api.runtime.config.ConfigurationInstance;
import org.mule.runtime.extension.api.runtime.config.ConfigurationProvider;
import org.mule.runtime.extension.api.runtime.config.ExpirableConfigurationProvider;
import org.mule.runtime.module.extension.internal.manager.ExtensionEntityKey;

final class ExtensionRegistry {
    private final LoadingCache<ExtensionModel, MultiMap<ConfigurationModel, ConfigurationProvider>> providersByExtension;
    private final Map<ExtensionEntityKey, ExtensionModel> extensions = new ConcurrentHashMap<ExtensionEntityKey, ExtensionModel>();
    private final Registry registry;

    ExtensionRegistry(Registry registry) {
        this.registry = registry;
        this.providersByExtension = Caffeine.newBuilder().build(extensionKey -> {
            List providers = (List)registry.lookupAllByType(ConfigurationProvider.class).stream().filter(provider -> provider.getExtensionModel() == extensionKey).collect(Collectors.toImmutableList());
            MultiMap multimap = new MultiMap();
            providers.forEach(p -> multimap.put((Object)p.getConfigurationModel(), p));
            return multimap;
        });
    }

    void registerExtension(String name, ExtensionModel extensionModel) {
        this.extensions.put(new ExtensionEntityKey(name), extensionModel);
    }

    Set<ExtensionModel> getExtensions() {
        return new HashSet<ExtensionModel>(this.extensions.values());
    }

    Optional<ExtensionModel> getExtension(String extensionName) {
        return Optional.ofNullable(this.extensions.get(new ExtensionEntityKey(extensionName)));
    }

    boolean containsExtension(String name) {
        return this.extensions.containsKey(new ExtensionEntityKey(name));
    }

    Collection<ConfigurationProvider> getConfigurationProviders(ExtensionModel extensionModel) {
        MultiMap providers = (MultiMap)this.providersByExtension.get((Object)extensionModel);
        return providers.keySet().stream().flatMap(k -> providers.getAll(k).stream()).toList();
    }

    Optional<ConfigurationProvider> getConfigurationProvider(String key) {
        return this.registry.lookupByName(key).filter(cp -> cp instanceof ConfigurationProvider).map(cp -> (ConfigurationProvider)cp);
    }

    void registerConfigurationProvider(ConfigurationProvider configurationProvider, MuleContext muleContext) {
        Objects.requireNonNull(configurationProvider, "Cannot register a null configurationProvider");
        try {
            LegacyRegistryUtils.registerObject((MuleContext)muleContext, (String)configurationProvider.getName(), (Object)configurationProvider);
        }
        catch (RegistrationException e) {
            throw new MuleRuntimeException(I18nMessageFactory.createStaticMessage((String)String.format("Found exception while registering configuration provider '%s'", configurationProvider.getName())), (Throwable)e);
        }
        this.providersByExtension.invalidate((Object)configurationProvider.getExtensionModel());
    }

    void unregisterConfigurationProvider(ConfigurationProvider configurationProvider, MuleContext muleContext) {
        Objects.requireNonNull(configurationProvider, "Cannot unregister a null configurationProvider");
        try {
            LegacyRegistryUtils.unregisterObject((MuleContext)muleContext, (String)configurationProvider.getName());
        }
        catch (RegistrationException e) {
            throw new MuleRuntimeException(I18nMessageFactory.createStaticMessage((String)String.format("Found exception while unregistering configuration provider '%s'", configurationProvider.getName())), (Throwable)e);
        }
        this.providersByExtension.invalidate((Object)configurationProvider.getExtensionModel());
    }

    MultiMap<String, ConfigurationInstance> getExpiredConfigs() {
        MultiMap expired = new MultiMap();
        for (ExtensionModel extensionModel : this.extensions.values()) {
            this.getConfigurationProviders(extensionModel).stream().filter(ExpirableConfigurationProvider.class::isInstance).map(ExpirableConfigurationProvider.class::cast).forEach(provider -> expired.put((Object)provider.getName(), (Collection)provider.getExpired()));
        }
        return expired.toImmutableMultiMap();
    }
}

