/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.extension.internal.loader.parser.java.utils;

import jakarta.inject.Inject;
import java.lang.annotation.Annotation;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.mule.runtime.api.meta.MuleVersion;
import org.mule.runtime.api.meta.model.declaration.fluent.HasMinMuleVersionDeclarer;
import org.mule.runtime.api.meta.model.declaration.fluent.WithMinMuleVersionDeclaration;
import org.mule.runtime.extension.api.annotation.Configurations;
import org.mule.runtime.extension.api.annotation.param.Config;
import org.mule.runtime.extension.api.annotation.param.Connection;
import org.mule.runtime.extension.api.annotation.param.ParameterGroup;
import org.mule.runtime.extension.api.loader.parser.MinMuleVersionParser;
import org.mule.runtime.extension.api.runtime.streaming.PagingProvider;
import org.mule.runtime.module.extension.api.loader.java.type.ExtensionParameter;
import org.mule.runtime.module.extension.api.loader.java.type.MethodElement;
import org.mule.runtime.module.extension.api.loader.java.type.OperationContainerElement;
import org.mule.runtime.module.extension.api.loader.java.type.SourceElement;
import org.mule.runtime.module.extension.api.loader.java.type.Type;
import org.mule.runtime.module.extension.api.loader.java.type.TypeGeneric;
import org.mule.runtime.module.extension.api.loader.java.type.WithAnnotations;
import org.mule.runtime.module.extension.internal.loader.parser.java.utils.ResolvedMinMuleVersion;
import org.mule.sdk.api.annotation.DoNotEnforceMinMuleVersion;
import org.mule.sdk.api.annotation.Extension;
import org.mule.sdk.api.annotation.MinMuleVersion;
import org.mule.sdk.api.annotation.param.Parameter;
import org.mule.sdk.api.connectivity.ConnectionProvider;
import org.mule.sdk.api.runtime.operation.Result;
import org.mule.sdk.api.runtime.source.Source;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class MinMuleVersionUtils {
    private static final Logger LOGGER = LoggerFactory.getLogger(MinMuleVersionUtils.class);
    private static final MuleVersion SDK_EXTENSION_ANNOTATION_MIN_MULE_VERSION = new MuleVersion(Extension.class.getAnnotation(MinMuleVersion.class).value());

    private MinMuleVersionUtils() {
    }

    public static ResolvedMinMuleVersion resolveExtensionMinMuleVersion(Type extension) {
        Optional<MuleVersion> classLevelMMV;
        if (MinMuleVersionUtils.belongsToJavaPackages(extension.getTypeName())) {
            return MinMuleVersionUtils.resolveToDefaultMMV("Java type", extension.getTypeName());
        }
        ResolvedMinMuleVersion extensionMMV = extension.isAnnotatedWith(Extension.class) ? new ResolvedMinMuleVersion(extension.getName(), SDK_EXTENSION_ANNOTATION_MIN_MULE_VERSION, "Extension " + extension.getName() + " has min mule version " + String.valueOf(SDK_EXTENSION_ANNOTATION_MIN_MULE_VERSION) + " because it if annotated with the new sdk api @Extension.") : MinMuleVersionUtils.resolveToDefaultMMV("Extension", extension.getName());
        Optional<ResolvedMinMuleVersion> superExtensionMMV = extension.getSuperType().map(MinMuleVersionUtils::resolveExtensionMinMuleVersion);
        superExtensionMMV.ifPresent(resolvedMMV -> extensionMMV.updateIfHigherMMV((ResolvedMinMuleVersion)resolvedMMV, MinMuleVersionUtils.getReasonSuperClass("Extension", extension.getName(), resolvedMMV)));
        if (!extension.isAnnotatedWith(Configurations.class) && !extension.isAnnotatedWith(org.mule.sdk.api.annotation.Configurations.class)) {
            Optional<ResolvedMinMuleVersion> fieldMMV = extension.getFields().stream().map(f -> MinMuleVersionUtils.calculateFieldMinMuleVersion(f, new HashSet<String>())).reduce(MinMuleVersionUtils::max);
            fieldMMV.ifPresent(resolvedMMV -> extensionMMV.updateIfHigherMMV((ResolvedMinMuleVersion)resolvedMMV, MinMuleVersionUtils.getReasonField("Extension", extension.getName(), resolvedMMV)));
            Optional<ResolvedMinMuleVersion> methodMMV = extension.getEnclosingMethods().map(MinMuleVersionUtils::calculateMethodMinMuleVersion).reduce(MinMuleVersionUtils::max);
            methodMMV.ifPresent(resolvedMMV -> extensionMMV.updateIfHigherMMV((ResolvedMinMuleVersion)resolvedMMV, MinMuleVersionUtils.getReasonMethod("Extension", extension.getName(), resolvedMMV)));
        }
        if ((classLevelMMV = MinMuleVersionUtils.getMinMuleVersionFromAnnotations(extension)).isPresent()) {
            if (classLevelMMV.get().priorTo(extensionMMV.getMinMuleVersion())) {
                return new ResolvedMinMuleVersion(extension.getName(), extensionMMV.getMinMuleVersion(), MinMuleVersionUtils.getReasonOverride(extensionMMV.getMinMuleVersion().toString(), "extension class", classLevelMMV.get().toString(), extensionMMV.getReason()));
            }
            return new ResolvedMinMuleVersion(extension.getName(), classLevelMMV.get(), MinMuleVersionUtils.getReasonClassLevelMMV("Extension", extension.getName(), classLevelMMV.get()));
        }
        return extensionMMV;
    }

    public static ResolvedMinMuleVersion resolveConfigurationMinMuleVersion(Type config, MuleVersion propagatedMinMuleVersion) {
        if (MinMuleVersionUtils.belongsToJavaPackages(config.getTypeName())) {
            return MinMuleVersionUtils.resolveToDefaultMMV("Java type", config.getTypeName());
        }
        ResolvedMinMuleVersion configMMV = MinMuleVersionUtils.max(MinMuleVersionUtils.resolveToDefaultMMV("Configuration", config.getName()), new ResolvedMinMuleVersion(config.getName(), propagatedMinMuleVersion, "Configuration " + config.getName() + " has min mule version " + String.valueOf(propagatedMinMuleVersion) + " because it was propagated from the annotation (either @Configurations or @Config) used to reference this configuration."));
        Optional<Type> superType = config.getSuperType();
        if (superType.isPresent()) {
            ResolvedMinMuleVersion superConfigMMV = MinMuleVersionUtils.resolveConfigurationMinMuleVersion(superType.get(), propagatedMinMuleVersion);
            configMMV.updateIfHigherMMV(superConfigMMV, MinMuleVersionUtils.getReasonSuperClass("Configuration", config.getName(), superConfigMMV));
        }
        Optional<ResolvedMinMuleVersion> annotationMMV = config.getAnnotations().map(MinMuleVersionUtils::getEnforcedMinMuleVersion).reduce(MinMuleVersionUtils::max);
        annotationMMV.ifPresent(resolvedMMV -> configMMV.updateIfHigherMMV((ResolvedMinMuleVersion)resolvedMMV, MinMuleVersionUtils.getReasonAnnotated("Configuration", config.getName(), resolvedMMV)));
        Optional<ResolvedMinMuleVersion> fieldMMV = config.getFields().stream().map(f -> MinMuleVersionUtils.calculateFieldMinMuleVersion(f, new HashSet<String>())).reduce(MinMuleVersionUtils::max);
        fieldMMV.ifPresent(resolvedMMV -> configMMV.updateIfHigherMMV((ResolvedMinMuleVersion)resolvedMMV, MinMuleVersionUtils.getReasonField("Configuration", config.getName(), resolvedMMV)));
        Optional<ResolvedMinMuleVersion> methodMMV = config.getEnclosingMethods().map(MinMuleVersionUtils::calculateMethodMinMuleVersion).reduce(MinMuleVersionUtils::max);
        methodMMV.ifPresent(resolvedMMV -> configMMV.updateIfHigherMMV((ResolvedMinMuleVersion)resolvedMMV, MinMuleVersionUtils.getReasonMethod("Configuration", config.getName(), resolvedMMV)));
        Optional<MuleVersion> classLevelMMV = MinMuleVersionUtils.getMinMuleVersionFromAnnotations(config);
        if (classLevelMMV.isPresent()) {
            if (classLevelMMV.get().priorTo(configMMV.getMinMuleVersion())) {
                return new ResolvedMinMuleVersion(config.getName(), configMMV.getMinMuleVersion(), MinMuleVersionUtils.getReasonOverride(configMMV.getMinMuleVersion().toString(), "configuration class", classLevelMMV.get().toString(), configMMV.getReason()));
            }
            return new ResolvedMinMuleVersion(config.getName(), classLevelMMV.get(), MinMuleVersionUtils.getReasonClassLevelMMV("Configuration", config.getName(), classLevelMMV.get()));
        }
        return configMMV;
    }

    public static ResolvedMinMuleVersion resolveFunctionMinMuleVersion(MethodElement<?> function, MuleVersion propagatedMinMuleVersion) {
        ResolvedMinMuleVersion resolvedMMV = MinMuleVersionUtils.max(MinMuleVersionUtils.resolveToDefaultMMV("Function", function.getName()), new ResolvedMinMuleVersion(function.getName(), propagatedMinMuleVersion, "Function " + function.getName() + " has min mule version " + String.valueOf(propagatedMinMuleVersion) + " because it was propagated from the @Functions annotation at the extension class used to add the function."));
        resolvedMMV = MinMuleVersionUtils.max(resolvedMMV, MinMuleVersionUtils.calculateMethodMinMuleVersion(function));
        return resolvedMMV;
    }

    public static ResolvedMinMuleVersion resolveOperationMinMuleVersion(MethodElement<?> operation, OperationContainerElement operationContainer, MuleVersion propagatedMinMuleVersion) {
        ResolvedMinMuleVersion operationMMV = MinMuleVersionUtils.resolveToDefaultMMV("Operation", operation.getName());
        operationMMV = MinMuleVersionUtils.max(operationMMV, new ResolvedMinMuleVersion(operation.getName(), propagatedMinMuleVersion, "Operation " + operation.getName() + " has min mule version " + String.valueOf(propagatedMinMuleVersion) + " because it was propagated from the @Operations annotation at the extension class used to add the operation's container " + operationContainer.getName() + "."));
        Optional<ResolvedMinMuleVersion> parameterMMV = operationContainer.getParameters().stream().map(MinMuleVersionUtils::calculateMethodParameterMinMuleVersion).reduce(MinMuleVersionUtils::max);
        if (parameterMMV.isPresent()) {
            operationMMV.updateIfHigherMMV(parameterMMV.get(), MinMuleVersionUtils.getReasonParameter("Operation", operation.getName(), parameterMMV.get()));
        }
        operationMMV = MinMuleVersionUtils.max(operationMMV, MinMuleVersionUtils.calculateMethodMinMuleVersion(operation));
        return operationMMV;
    }

    public static ResolvedMinMuleVersion resolveConnectionProviderMinMuleVersion(Type connectionProvider) {
        if (MinMuleVersionUtils.belongsToJavaPackages(connectionProvider.getTypeName())) {
            return MinMuleVersionUtils.resolveToDefaultMMV("Java type", connectionProvider.getTypeName());
        }
        ResolvedMinMuleVersion connectionProviderMMV = MinMuleVersionUtils.resolveToDefaultMMV("Connection Provider", connectionProvider.getName());
        Optional<Type> superType = connectionProvider.getSuperType();
        if (superType.isPresent() && (superType.get().isAssignableTo(org.mule.runtime.api.connection.ConnectionProvider.class) || superType.get().isAssignableTo(ConnectionProvider.class))) {
            ResolvedMinMuleVersion superTypeMMV = MinMuleVersionUtils.resolveConnectionProviderMinMuleVersion(superType.get());
            connectionProviderMMV.updateIfHigherMMV(superTypeMMV, MinMuleVersionUtils.getReasonSuperClass("Connection Provider", connectionProvider.getName(), superTypeMMV));
        }
        Optional<ResolvedMinMuleVersion> interfaceMMV = connectionProvider.getImplementingInterfaces().map(MinMuleVersionUtils::calculateInterfaceMinMuleVersion).reduce(MinMuleVersionUtils::max);
        interfaceMMV.ifPresent(resolvedMMV -> connectionProviderMMV.updateIfHigherMMV((ResolvedMinMuleVersion)resolvedMMV, MinMuleVersionUtils.getReasonInterface("Connection Provider", connectionProvider.getName(), resolvedMMV)));
        Optional<ResolvedMinMuleVersion> annotationMMV = connectionProvider.getAnnotations().map(MinMuleVersionUtils::getEnforcedMinMuleVersion).reduce(MinMuleVersionUtils::max);
        annotationMMV.ifPresent(resolvedMMV -> connectionProviderMMV.updateIfHigherMMV((ResolvedMinMuleVersion)resolvedMMV, MinMuleVersionUtils.getReasonAnnotated("Connection Provider", connectionProvider.getName(), resolvedMMV)));
        Optional<ResolvedMinMuleVersion> fieldMMV = connectionProvider.getFields().stream().map(f -> MinMuleVersionUtils.calculateFieldMinMuleVersion(f, new HashSet<String>())).reduce(MinMuleVersionUtils::max);
        fieldMMV.ifPresent(resolvedMMV -> connectionProviderMMV.updateIfHigherMMV((ResolvedMinMuleVersion)resolvedMMV, MinMuleVersionUtils.getReasonField("Connection Provider", connectionProvider.getName(), resolvedMMV)));
        Optional<MuleVersion> classLevelMMV = MinMuleVersionUtils.getMinMuleVersionFromAnnotations(connectionProvider);
        if (classLevelMMV.isPresent()) {
            if (classLevelMMV.get().priorTo(connectionProviderMMV.getMinMuleVersion())) {
                return new ResolvedMinMuleVersion(connectionProvider.getName(), connectionProviderMMV.getMinMuleVersion(), MinMuleVersionUtils.getReasonOverride(connectionProviderMMV.getMinMuleVersion().toString(), "connection provider class", classLevelMMV.get().toString(), connectionProviderMMV.getReason()));
            }
            return new ResolvedMinMuleVersion(connectionProvider.getName(), classLevelMMV.get(), MinMuleVersionUtils.getReasonClassLevelMMV("Connection Provider", connectionProvider.getName(), classLevelMMV.get()));
        }
        return connectionProviderMMV;
    }

    public static ResolvedMinMuleVersion resolveSourceMinMuleVersion(SourceElement source) {
        ResolvedMinMuleVersion genericsMMV = MinMuleVersionUtils.calculateSourceGenericsMinMuleVersion(source.getSuperClassGenerics());
        ResolvedMinMuleVersion sourceMMV = MinMuleVersionUtils.calculateSourceMinMuleVersion(source);
        sourceMMV.updateIfHigherMMV(genericsMMV, "Source " + source.getName() + " has min mule version " + String.valueOf(genericsMMV.getMinMuleVersion()) + " because it has a generic of type " + genericsMMV.getName() + ".");
        return sourceMMV;
    }

    private static ResolvedMinMuleVersion calculateSourceMinMuleVersion(Type source) {
        if (MinMuleVersionUtils.belongsToJavaPackages(source.getTypeName())) {
            return MinMuleVersionUtils.resolveToDefaultMMV("Java type", source.getTypeName());
        }
        ResolvedMinMuleVersion sourceMMV = MinMuleVersionUtils.resolveToDefaultMMV("Source", source.getName());
        Optional<Type> superType = source.getSuperType();
        if (superType.isPresent()) {
            ResolvedMinMuleVersion superTypeMMV = superType.get().isSameType(org.mule.runtime.extension.api.runtime.source.Source.class) || superType.get().isSameType(Source.class) ? MinMuleVersionUtils.getEnforcedMinMuleVersion(superType.get()) : MinMuleVersionUtils.calculateSourceMinMuleVersion(superType.get());
            sourceMMV.updateIfHigherMMV(superTypeMMV, MinMuleVersionUtils.getReasonSuperClass("Source", source.getName(), superTypeMMV));
        }
        Optional<ResolvedMinMuleVersion> interfaceMMV = source.getImplementingInterfaces().map(MinMuleVersionUtils::calculateInterfaceMinMuleVersion).reduce(MinMuleVersionUtils::max);
        interfaceMMV.ifPresent(resolvedMMV -> sourceMMV.updateIfHigherMMV((ResolvedMinMuleVersion)resolvedMMV, MinMuleVersionUtils.getReasonInterface("Source", source.getName(), resolvedMMV)));
        Optional<ResolvedMinMuleVersion> annotationMMV = source.getAnnotations().map(MinMuleVersionUtils::getEnforcedMinMuleVersion).reduce(MinMuleVersionUtils::max);
        annotationMMV.ifPresent(resolvedMMV -> sourceMMV.updateIfHigherMMV((ResolvedMinMuleVersion)resolvedMMV, MinMuleVersionUtils.getReasonAnnotated("Source", source.getName(), resolvedMMV)));
        Optional<ResolvedMinMuleVersion> fieldMMV = source.getFields().stream().map(f -> MinMuleVersionUtils.calculateFieldMinMuleVersion(f, new HashSet<String>())).reduce(MinMuleVersionUtils::max);
        fieldMMV.ifPresent(resolvedMMV -> sourceMMV.updateIfHigherMMV((ResolvedMinMuleVersion)resolvedMMV, MinMuleVersionUtils.getReasonField("Source", source.getName(), resolvedMMV)));
        Optional<ResolvedMinMuleVersion> methodMMV = source.getEnclosingMethods().map(MinMuleVersionUtils::calculateMethodMinMuleVersion).reduce(MinMuleVersionUtils::max);
        methodMMV.ifPresent(resolvedMMV -> sourceMMV.updateIfHigherMMV((ResolvedMinMuleVersion)resolvedMMV, MinMuleVersionUtils.getReasonMethod("Source", source.getName(), resolvedMMV)));
        Optional<MuleVersion> classLevelMMV = MinMuleVersionUtils.getMinMuleVersionFromAnnotations(source);
        if (classLevelMMV.isPresent()) {
            if (classLevelMMV.get().priorTo(sourceMMV.getMinMuleVersion())) {
                return new ResolvedMinMuleVersion(source.getName(), sourceMMV.getMinMuleVersion(), MinMuleVersionUtils.getReasonOverride(sourceMMV.getMinMuleVersion().toString(), "source class", classLevelMMV.get().toString(), sourceMMV.getReason()));
            }
            return new ResolvedMinMuleVersion(source.getName(), classLevelMMV.get(), MinMuleVersionUtils.getReasonClassLevelMMV("Source", source.getName(), classLevelMMV.get()));
        }
        return sourceMMV;
    }

    public static <A extends Annotation> MuleVersion getContainerAnnotationMinMuleVersion(Type containerElement, Class<A> annotationClass, Function<A, Class[]> mapper, Type element) {
        List sdkConfigurations = containerElement.getValueFromAnnotation(annotationClass).map(vf -> vf.getClassArrayValue(mapper)).orElse(Collections.emptyList());
        if (sdkConfigurations.stream().anyMatch(element::isSameType)) {
            return new MuleVersion(annotationClass.getAnnotation(MinMuleVersion.class).value());
        }
        return ResolvedMinMuleVersion.FIRST_MULE_VERSION;
    }

    private static ResolvedMinMuleVersion calculateMethodMinMuleVersion(MethodElement<?> method) {
        ResolvedMinMuleVersion methodMMV = MinMuleVersionUtils.resolveToDefaultMMV("Method", method.getName());
        Optional<ResolvedMinMuleVersion> annotationMMV = method.getAnnotations().map(MinMuleVersionUtils::getEnforcedMinMuleVersion).reduce(MinMuleVersionUtils::max);
        annotationMMV.ifPresent(resolvedMMV -> methodMMV.updateIfHigherMMV((ResolvedMinMuleVersion)resolvedMMV, MinMuleVersionUtils.getReasonAnnotated("Method", method.getName(), resolvedMMV)));
        Optional<ResolvedMinMuleVersion> parameterMMV = method.getParameters().stream().map(MinMuleVersionUtils::calculateMethodParameterMinMuleVersion).reduce(MinMuleVersionUtils::max);
        parameterMMV.ifPresent(resolvedMMV -> methodMMV.updateIfHigherMMV((ResolvedMinMuleVersion)resolvedMMV, MinMuleVersionUtils.getReasonParameter("Method", method.getName(), resolvedMMV)));
        ResolvedMinMuleVersion outputMMV = MinMuleVersionUtils.calculateOutputMinMuleVersion(method.getReturnType());
        methodMMV.updateIfHigherMMV(outputMMV, "Method " + method.getName() + " has min mule version " + String.valueOf(outputMMV.getMinMuleVersion()) + " because of its output type " + outputMMV.getName() + ".");
        Optional<MuleVersion> operationLevelMMV = MinMuleVersionUtils.getMinMuleVersionFromAnnotations(method);
        if (operationLevelMMV.isPresent()) {
            if (operationLevelMMV.get().priorTo(methodMMV.getMinMuleVersion())) {
                return new ResolvedMinMuleVersion(method.getName(), methodMMV.getMinMuleVersion(), MinMuleVersionUtils.getReasonOverride(methodMMV.getMinMuleVersion().toString(), "method", operationLevelMMV.get().toString(), methodMMV.getReason()));
            }
            return new ResolvedMinMuleVersion(method.getName(), operationLevelMMV.get(), "Method " + method.getName() + " has min mule version " + String.valueOf(operationLevelMMV.get()) + " because it is the one set at the method level through the @MinMuleVersion annotation.");
        }
        return methodMMV;
    }

    private static ResolvedMinMuleVersion calculateInterfaceMinMuleVersion(Type interfaceType) {
        ResolvedMinMuleVersion interfaceMMV = MinMuleVersionUtils.getEnforcedMinMuleVersion(interfaceType);
        if (MinMuleVersionUtils.belongsToSdkPackages(interfaceType.getTypeName())) {
            return interfaceMMV;
        }
        Optional<ResolvedMinMuleVersion> superInterface = interfaceType.getImplementingInterfaces().map(MinMuleVersionUtils::calculateInterfaceMinMuleVersion).reduce(MinMuleVersionUtils::max);
        superInterface.ifPresent(resolvedMMV -> interfaceMMV.updateIfHigherMMV((ResolvedMinMuleVersion)resolvedMMV, MinMuleVersionUtils.getReasonInterface("Interface", interfaceType.getName(), resolvedMMV)));
        return interfaceMMV;
    }

    private static ResolvedMinMuleVersion calculateSourceGenericsMinMuleVersion(List<Type> sourceGenerics) {
        Type outputType = sourceGenerics.get(0);
        Type attributesType = sourceGenerics.get(1);
        return MinMuleVersionUtils.max(MinMuleVersionUtils.getEnforcedMinMuleVersion(attributesType), MinMuleVersionUtils.calculateOutputMinMuleVersion(outputType));
    }

    private static ResolvedMinMuleVersion calculateOutputMinMuleVersion(Type outputType) {
        ResolvedMinMuleVersion resolvedMMV = MinMuleVersionUtils.resolveToDefaultMMV("Output type", outputType.getName());
        if (outputType.isArray()) {
            resolvedMMV = MinMuleVersionUtils.max(resolvedMMV, MinMuleVersionUtils.calculateOutputMinMuleVersion(outputType.getArrayComponentType().get()));
        } else if (outputType.isAssignableTo(Iterable.class) || outputType.isAssignableTo(Iterator.class)) {
            for (TypeGeneric typeGeneric : outputType.getGenerics()) {
                resolvedMMV = MinMuleVersionUtils.max(resolvedMMV, MinMuleVersionUtils.calculateOutputMinMuleVersion(typeGeneric.getConcreteType()));
            }
        } else if (outputType.isSameType(org.mule.runtime.extension.api.runtime.operation.Result.class) || outputType.isSameType(Result.class)) {
            resolvedMMV = MinMuleVersionUtils.max(resolvedMMV, MinMuleVersionUtils.getEnforcedMinMuleVersion(outputType));
            for (TypeGeneric MMVTypeGeneric : outputType.getGenerics()) {
                resolvedMMV = MinMuleVersionUtils.max(resolvedMMV, MinMuleVersionUtils.getEnforcedMinMuleVersion(MMVTypeGeneric.getConcreteType()));
            }
        } else if (outputType.isSameType(PagingProvider.class) || outputType.isSameType(org.mule.sdk.api.runtime.streaming.PagingProvider.class)) {
            resolvedMMV = MinMuleVersionUtils.max(resolvedMMV, MinMuleVersionUtils.getEnforcedMinMuleVersion(outputType));
            resolvedMMV = MinMuleVersionUtils.max(resolvedMMV, MinMuleVersionUtils.getEnforcedMinMuleVersion(outputType.getGenerics().get(1).getConcreteType()));
        } else {
            resolvedMMV = MinMuleVersionUtils.getEnforcedMinMuleVersion(outputType);
        }
        return resolvedMMV;
    }

    private static ResolvedMinMuleVersion calculateFieldMinMuleVersion(ExtensionParameter field, Set<String> seenTypesForRecursionControl) {
        Type parameterType = field.getType();
        if (seenTypesForRecursionControl.contains(parameterType.getTypeName())) {
            ResolvedMinMuleVersion recursiveFieldMMV = MinMuleVersionUtils.resolveToDefaultMMV("Field", field.getName());
            Optional<ResolvedMinMuleVersion> annotationMMV = field.getAnnotations().map(MinMuleVersionUtils::getEnforcedMinMuleVersion).reduce(MinMuleVersionUtils::max);
            annotationMMV.ifPresent(resolvedMMV -> recursiveFieldMMV.updateIfHigherMMV((ResolvedMinMuleVersion)resolvedMMV, MinMuleVersionUtils.getReasonAnnotated("Field", field.getName(), resolvedMMV)));
            return recursiveFieldMMV;
        }
        seenTypesForRecursionControl.add(parameterType.getTypeName());
        ResolvedMinMuleVersion fieldMinMuleVersion = MinMuleVersionUtils.getMinMuleVersionFromAnnotations(field).map(mmv -> new ResolvedMinMuleVersion(field.getName(), (MuleVersion)mmv, "Field " + field.getName() + " has min mule version " + String.valueOf(mmv) + " because it is annotated with @MinMuleVersion.")).orElse(MinMuleVersionUtils.resolveToDefaultMMV("Field", field.getName()));
        if (MinMuleVersionUtils.belongsToSdkPackages(parameterType.getTypeName())) {
            ResolvedMinMuleVersion typeMMV = MinMuleVersionUtils.getEnforcedMinMuleVersion(parameterType);
            fieldMinMuleVersion.updateIfHigherMMV(typeMMV, MinMuleVersionUtils.getReasonType("Field", field.getName(), typeMMV));
        }
        for (Type annotation : field.getAnnotations().collect(Collectors.toList())) {
            MinMuleVersionUtils.calculateFieldAnnotationMinMuleVersion(field, seenTypesForRecursionControl, parameterType, fieldMinMuleVersion, annotation);
        }
        return fieldMinMuleVersion;
    }

    private static void calculateFieldAnnotationMinMuleVersion(ExtensionParameter field, Set<String> seenTypesForRecursionControl, Type parameterType, ResolvedMinMuleVersion fieldMinMuleVersion, Type annotation) {
        if ((annotation.isSameType(Inject.class) || annotation.isSameType(javax.inject.Inject.class)) && !parameterType.isSameType(Optional.class)) {
            ResolvedMinMuleVersion typeMMV = MinMuleVersionUtils.getEnforcedMinMuleVersion(parameterType);
            fieldMinMuleVersion.updateIfHigherMMV(typeMMV, MinMuleVersionUtils.getReasonType("Field", field.getName(), typeMMV));
        }
        if (MinMuleVersionUtils.isParameterOrParameterGroup(annotation)) {
            ResolvedMinMuleVersion parameterContainerMMV = MinMuleVersionUtils.calculateParameterTypeMinMuleVersion(parameterType, seenTypesForRecursionControl);
            fieldMinMuleVersion.updateIfHigherMMV(parameterContainerMMV, MinMuleVersionUtils.getReasonFieldType(field.getName(), parameterContainerMMV.getMinMuleVersion().toString(), "parameter", parameterContainerMMV.getName()));
        }
        if ((annotation.isSameType(Connection.class) || annotation.isSameType(org.mule.sdk.api.annotation.param.Connection.class)) && (parameterType.isAssignableTo(org.mule.runtime.api.connection.ConnectionProvider.class) || parameterType.isAssignableTo(ConnectionProvider.class))) {
            ResolvedMinMuleVersion connectionProviderMMV = MinMuleVersionUtils.resolveConnectionProviderMinMuleVersion(parameterType);
            fieldMinMuleVersion.updateIfHigherMMV(connectionProviderMMV, MinMuleVersionUtils.getReasonFieldType(field.getName(), connectionProviderMMV.getMinMuleVersion().toString(), "connection provider", connectionProviderMMV.getName()));
        }
        if (annotation.isSameType(Config.class) || annotation.isSameType(org.mule.sdk.api.annotation.param.Config.class)) {
            ResolvedMinMuleVersion configurationMMV = MinMuleVersionUtils.resolveConfigurationMinMuleVersion(parameterType, MinMuleVersionUtils.getEnforcedMinMuleVersion(annotation).getMinMuleVersion());
            fieldMinMuleVersion.updateIfHigherMMV(configurationMMV, MinMuleVersionUtils.getReasonFieldType(field.getName(), configurationMMV.getMinMuleVersion().toString(), "configuration", configurationMMV.getName()));
        }
        ResolvedMinMuleVersion annotationMMV = MinMuleVersionUtils.getEnforcedMinMuleVersion(annotation);
        fieldMinMuleVersion.updateIfHigherMMV(annotationMMV, MinMuleVersionUtils.getReasonAnnotated("Field", field.getName(), annotationMMV));
    }

    private static ResolvedMinMuleVersion calculateMethodParameterMinMuleVersion(ExtensionParameter methodParameter) {
        ResolvedMinMuleVersion methodParameterMMV = MinMuleVersionUtils.resolveToDefaultMMV("Parameter", methodParameter.getName());
        Optional<ResolvedMinMuleVersion> configAnnotationMMV = methodParameter.getAnnotations().filter(a -> a.isAssignableTo(Config.class) || a.isAssignableTo(org.mule.sdk.api.annotation.param.Config.class)).findFirst().map(MinMuleVersionUtils::getEnforcedMinMuleVersion);
        if (configAnnotationMMV.isPresent()) {
            ResolvedMinMuleVersion configMMV = MinMuleVersionUtils.resolveConfigurationMinMuleVersion(methodParameter.getType(), configAnnotationMMV.get().getMinMuleVersion());
            methodParameterMMV.updateIfHigherMMV(configMMV, "Parameter " + methodParameter.getName() + " has min mule version " + String.valueOf(configMMV.getMinMuleVersion()) + " because it references a config of type " + configMMV.getName() + ".");
        }
        Optional<ResolvedMinMuleVersion> annotationMMV = methodParameter.getAnnotations().map(MinMuleVersionUtils::getEnforcedMinMuleVersion).reduce(MinMuleVersionUtils::max);
        annotationMMV.ifPresent(resolvedMMV -> methodParameterMMV.updateIfHigherMMV((ResolvedMinMuleVersion)resolvedMMV, MinMuleVersionUtils.getReasonAnnotated("Parameter", methodParameter.getName(), resolvedMMV)));
        ResolvedMinMuleVersion parameterTypeMMV = MinMuleVersionUtils.belongsToSdkPackages(methodParameter.getType().getTypeName()) ? MinMuleVersionUtils.getEnforcedMinMuleVersion(methodParameter.getType()) : (methodParameter.getAnnotations().noneMatch(a -> a.isSameType(Connection.class) || a.isSameType(org.mule.sdk.api.annotation.param.Connection.class)) ? MinMuleVersionUtils.calculateParameterTypeMinMuleVersion(methodParameter.getType(), new HashSet<String>()) : MinMuleVersionUtils.resolveToDefaultMMV("Type", methodParameter.getType().getName()));
        methodParameterMMV.updateIfHigherMMV(parameterTypeMMV, MinMuleVersionUtils.getReasonType("Parameter", methodParameter.getName(), parameterTypeMMV));
        return methodParameterMMV;
    }

    private static ResolvedMinMuleVersion calculateParameterTypeMinMuleVersion(Type parameterType, Set<String> seenTypesForRecursionControl) {
        Optional<MuleVersion> minMuleVersionAnnotation = MinMuleVersionUtils.getMinMuleVersionFromAnnotations(parameterType);
        if (minMuleVersionAnnotation.isPresent()) {
            String reason = "Type " + parameterType.getName() + " has min mule version " + String.valueOf(minMuleVersionAnnotation.get()) + " because it is annotated with @MinMuleVersion.";
            return new ResolvedMinMuleVersion(parameterType.getName(), minMuleVersionAnnotation.get(), reason);
        }
        ResolvedMinMuleVersion parameterMMV = MinMuleVersionUtils.resolveToDefaultMMV("Type", parameterType.getName());
        Optional<Object> fieldMMV = Optional.empty();
        try {
            fieldMMV = parameterType.getFields().stream().filter(MinMuleVersionUtils::isAnnotatedWithParameterOrParameterGroup).map(f -> MinMuleVersionUtils.calculateFieldMinMuleVersion(f, seenTypesForRecursionControl)).reduce(MinMuleVersionUtils::max);
        }
        catch (Throwable t) {
            if (MinMuleVersionUtils.isLinkageError(t)) {
                LOGGER.warn(String.format("Skipping MMV calculation for fields of type '%s', at least one of the fields' types couldn't be loaded", parameterType.getName()));
            }
            throw t;
        }
        fieldMMV.ifPresent(resolvedMMV -> parameterMMV.updateIfHigherMMV((ResolvedMinMuleVersion)resolvedMMV, MinMuleVersionUtils.getReasonField("Type", parameterType.getName(), resolvedMMV)));
        Optional<ResolvedMinMuleVersion> annotationMMV = parameterType.getAnnotations().map(MinMuleVersionUtils::getEnforcedMinMuleVersion).reduce(MinMuleVersionUtils::max);
        annotationMMV.ifPresent(resolvedMMV -> parameterMMV.updateIfHigherMMV((ResolvedMinMuleVersion)resolvedMMV, MinMuleVersionUtils.getReasonAnnotated("Type", parameterType.getName(), resolvedMMV)));
        return parameterMMV;
    }

    public static void declarerWithMmv(HasMinMuleVersionDeclarer<?> declarer, MinMuleVersionParser resolvedMMV) {
        declarer.withMinMuleVersion(resolvedMMV.getMinMuleVersion());
        LOGGER.debug(resolvedMMV.getReason());
    }

    public static void declarationWithMmv(WithMinMuleVersionDeclaration declaration, MinMuleVersionParser resolvedMMV) {
        declaration.withMinMuleVersion(resolvedMMV.getMinMuleVersion());
        LOGGER.debug(resolvedMMV.getReason());
    }

    private static boolean isLinkageError(Throwable t) {
        HashSet<Throwable> seen = new HashSet<Throwable>();
        while (t != null && seen.add(t)) {
            if (t instanceof LinkageError) {
                return true;
            }
            t = t.getCause();
        }
        return false;
    }

    private static ResolvedMinMuleVersion getEnforcedMinMuleVersion(Type type) {
        if (type.isAnnotatedWith(DoNotEnforceMinMuleVersion.class)) {
            return new ResolvedMinMuleVersion(type.getName(), ResolvedMinMuleVersion.FIRST_MULE_VERSION, type.getName() + " has the default base min mule version " + String.valueOf(ResolvedMinMuleVersion.FIRST_MULE_VERSION) + " because it is annotated with @DoNotEnforceMinMuleVersion.");
        }
        Optional<MuleVersion> mmv = MinMuleVersionUtils.getMinMuleVersionFromAnnotations(type);
        return mmv.map(muleVersion -> new ResolvedMinMuleVersion(type.getName(), (MuleVersion)muleVersion, type.getName() + " was introduced in Mule " + String.valueOf(muleVersion) + ".")).orElseGet(() -> MinMuleVersionUtils.resolveToDefaultMMV("Type", type.getName()));
    }

    private static Optional<MuleVersion> getMinMuleVersionFromAnnotations(WithAnnotations type) {
        return type.getValueFromAnnotation(MinMuleVersion.class).map(fetcher -> new MuleVersion(fetcher.getStringValue(MinMuleVersion::value)));
    }

    private static ResolvedMinMuleVersion max(ResolvedMinMuleVersion currentMax, ResolvedMinMuleVersion candidate) {
        if (currentMax.getMinMuleVersion().atLeast(candidate.getMinMuleVersion())) {
            return currentMax;
        }
        return candidate;
    }

    private static ResolvedMinMuleVersion resolveToDefaultMMV(String componentDescription, String componentName) {
        return new ResolvedMinMuleVersion(componentName, ResolvedMinMuleVersion.FIRST_MULE_VERSION, componentDescription + " " + componentName + " has min mule version " + String.valueOf(ResolvedMinMuleVersion.FIRST_MULE_VERSION) + " because it is the default value.");
    }

    private static boolean isParameterOrParameterGroup(Type annotation) {
        return annotation.isSameType(org.mule.runtime.extension.api.annotation.param.Parameter.class) || annotation.isSameType(Parameter.class) || annotation.isSameType(ParameterGroup.class) || annotation.isSameType(org.mule.sdk.api.annotation.param.ParameterGroup.class);
    }

    private static boolean isAnnotatedWithParameterOrParameterGroup(WithAnnotations type) {
        return type.isAnnotatedWith(org.mule.runtime.extension.api.annotation.param.Parameter.class) || type.isAnnotatedWith(Parameter.class) || type.isAnnotatedWith(ParameterGroup.class) || type.isAnnotatedWith(org.mule.sdk.api.annotation.param.ParameterGroup.class);
    }

    private static boolean belongsToSdkPackages(String fullyQualifiedName) {
        return MinMuleVersionUtils.belongsToExtensionsApiPackages(fullyQualifiedName) || MinMuleVersionUtils.belongsToSdkApiPackages(fullyQualifiedName);
    }

    private static boolean belongsToExtensionsApiPackages(String fullyQualifiedName) {
        return fullyQualifiedName.startsWith("org.mule.runtime.extension.api");
    }

    private static boolean belongsToSdkApiPackages(String fullyQualifiedName) {
        return fullyQualifiedName.startsWith("org.mule.sdk.api");
    }

    private static boolean belongsToJavaPackages(String fullyQualifiedName) {
        return fullyQualifiedName.startsWith("java.");
    }

    private static String getReasonAnnotated(String component, String name, ResolvedMinMuleVersion annotationMMV) {
        return component + " " + name + " has min mule version " + String.valueOf(annotationMMV.getMinMuleVersion()) + " because it is annotated with " + annotationMMV.getName() + ".";
    }

    private static String getReasonSuperClass(String component, String name, ResolvedMinMuleVersion superClassMMV) {
        return component + " " + name + " has min mule version " + String.valueOf(superClassMMV.getMinMuleVersion()) + " because of its super class " + superClassMMV.getName() + ".";
    }

    private static String getReasonField(String component, String name, ResolvedMinMuleVersion fieldMMV) {
        return component + " " + name + " has min mule version " + String.valueOf(fieldMMV.getMinMuleVersion()) + " because of its field " + fieldMMV.getName() + ".";
    }

    private static String getReasonFieldType(String fieldName, String mmv, String componentType, String type) {
        return "Field " + fieldName + " has min mule version " + mmv + " because it is a " + componentType + " of type " + type + ".";
    }

    private static String getReasonInterface(String component, String name, ResolvedMinMuleVersion interfaceMMV) {
        return component + " " + name + " has min mule version " + String.valueOf(interfaceMMV.getMinMuleVersion()) + " because it implements interface " + interfaceMMV.getName() + ".";
    }

    private static String getReasonParameter(String component, String name, ResolvedMinMuleVersion parameterMMV) {
        return component + " " + name + " has min mule version " + String.valueOf(parameterMMV.getMinMuleVersion()) + " because of its parameter " + parameterMMV.getName() + ".";
    }

    private static String getReasonType(String component, String name, ResolvedMinMuleVersion typeMMV) {
        return component + " " + name + " has min mule version " + String.valueOf(typeMMV.getMinMuleVersion()) + " because it is of type " + typeMMV.getName() + ".";
    }

    private static String getReasonMethod(String component, String name, ResolvedMinMuleVersion methodMMV) {
        return component + " " + name + " has min mule version " + String.valueOf(methodMMV.getMinMuleVersion()) + " because of its method " + methodMMV.getName() + ".";
    }

    private static String getReasonClassLevelMMV(String component, String name, MuleVersion mmv) {
        return component + " " + name + " has min mule version " + String.valueOf(mmv) + " because it is the one set at the class level through the @MinMuleVersion annotation.";
    }

    private static String getReasonOverride(String resolvedMMV, String componentType, String classLevelMMV, String reason) {
        return "Calculated Min Mule Version is " + resolvedMMV + " which is greater than the one set at the " + componentType + " level " + classLevelMMV + ". Overriding it. " + reason;
    }
}

