/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.extension.internal.loader.parser.java;

import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.mule.runtime.api.meta.ExpressionSupport;
import org.mule.runtime.api.meta.NamedObject;
import org.mule.runtime.api.meta.model.ComponentVisibility;
import org.mule.runtime.api.meta.model.ModelProperty;
import org.mule.runtime.api.meta.model.deprecated.DeprecationModel;
import org.mule.runtime.api.meta.model.display.DisplayModel;
import org.mule.runtime.api.meta.model.notification.NotificationModel;
import org.mule.runtime.api.meta.model.operation.ExecutionType;
import org.mule.runtime.api.meta.model.stereotype.StereotypeModel;
import org.mule.runtime.extension.api.exception.IllegalOperationModelDefinitionException;
import org.mule.runtime.extension.api.loader.ExtensionLoadingContext;
import org.mule.runtime.extension.api.loader.parser.AttributesResolverModelParser;
import org.mule.runtime.extension.api.loader.parser.ErrorModelParser;
import org.mule.runtime.extension.api.loader.parser.MediaTypeParser;
import org.mule.runtime.extension.api.loader.parser.MinMuleVersionParser;
import org.mule.runtime.extension.api.loader.parser.NestedChainModelParser;
import org.mule.runtime.extension.api.loader.parser.NestedRouteModelParser;
import org.mule.runtime.extension.api.loader.parser.OperationModelParser;
import org.mule.runtime.extension.api.loader.parser.ParameterGroupModelParser;
import org.mule.runtime.extension.api.loader.parser.ParameterModelParser;
import org.mule.runtime.extension.api.loader.parser.StereotypeModelFactory;
import org.mule.runtime.extension.api.loader.parser.metadata.InputResolverModelParser;
import org.mule.runtime.extension.api.loader.parser.metadata.MetadataKeyModelParser;
import org.mule.runtime.extension.api.loader.parser.metadata.OutputResolverModelParser;
import org.mule.runtime.extension.api.loader.parser.metadata.RoutesChainInputTypesResolverModelParser;
import org.mule.runtime.extension.api.loader.parser.metadata.ScopeChainInputTypeResolverModelParser;
import org.mule.runtime.extension.api.runtime.exception.SdkExceptionHandlerFactory;
import org.mule.runtime.extension.api.runtime.operation.CompletableComponentExecutorFactory;
import org.mule.runtime.extension.api.runtime.process.CompletionCallback;
import org.mule.runtime.extension.api.runtime.process.RouterCompletionCallback;
import org.mule.runtime.extension.api.runtime.route.Chain;
import org.mule.runtime.extension.api.runtime.route.Route;
import org.mule.runtime.extension.privileged.semantic.SemanticTermsHelper;
import org.mule.runtime.module.extension.api.loader.java.type.ExtensionElement;
import org.mule.runtime.module.extension.api.loader.java.type.ExtensionParameter;
import org.mule.runtime.module.extension.api.loader.java.type.OperationContainerElement;
import org.mule.runtime.module.extension.api.loader.java.type.OperationElement;
import org.mule.runtime.module.extension.api.loader.java.type.Type;
import org.mule.runtime.module.extension.api.loader.java.type.TypeGeneric;
import org.mule.runtime.module.extension.internal.loader.java.property.FieldOperationParameterModelProperty;
import org.mule.runtime.module.extension.internal.loader.java.property.ImplementingMethodModelProperty;
import org.mule.runtime.module.extension.internal.loader.java.type.property.ExtensionOperationDescriptorModelProperty;
import org.mule.runtime.module.extension.internal.loader.parser.DefaultOutputModelParser;
import org.mule.runtime.module.extension.internal.loader.parser.ParameterModelParserDecorator;
import org.mule.runtime.module.extension.internal.loader.parser.java.AbstractJavaExecutableComponentModelParser;
import org.mule.runtime.module.extension.internal.loader.parser.java.JavaExtensionModelParser;
import org.mule.runtime.module.extension.internal.loader.parser.java.JavaExtensionModelParserUtils;
import org.mule.runtime.module.extension.internal.loader.parser.java.JavaNestedChainModelParser;
import org.mule.runtime.module.extension.internal.loader.parser.java.JavaNestedRouteModelParser;
import org.mule.runtime.module.extension.internal.loader.parser.java.ParameterDeclarationContext;
import org.mule.runtime.module.extension.internal.loader.parser.java.connection.JavaConnectionProviderModelParserUtils;
import org.mule.runtime.module.extension.internal.loader.parser.java.error.JavaErrorModelParserUtils;
import org.mule.runtime.module.extension.internal.loader.parser.java.metadata.JavaRoutesChainInputTypesResolverModelParser;
import org.mule.runtime.module.extension.internal.loader.parser.java.metadata.JavaScopeChainInputTypeResolverModelParser;
import org.mule.runtime.module.extension.internal.loader.parser.java.notification.NotificationModelParserUtils;
import org.mule.runtime.module.extension.internal.loader.parser.java.semantics.SemanticTermsParserUtils;
import org.mule.runtime.module.extension.internal.loader.parser.java.stereotypes.JavaStereotypeModelParserUtils;
import org.mule.runtime.module.extension.internal.loader.parser.java.type.CustomStaticTypeUtils;
import org.mule.runtime.module.extension.internal.loader.parser.java.utils.MinMuleVersionUtils;
import org.mule.runtime.module.extension.internal.loader.utils.JavaInputResolverModelParserUtils;
import org.mule.runtime.module.extension.internal.loader.utils.JavaMetadataKeyIdModelParserUtils;
import org.mule.runtime.module.extension.internal.loader.utils.JavaModelLoaderUtils;
import org.mule.runtime.module.extension.internal.loader.utils.JavaOutputResolverModelParserUtils;
import org.mule.runtime.module.extension.internal.runtime.execution.CompletableOperationExecutorFactory;
import org.mule.runtime.module.extension.internal.util.IntrospectionUtils;
import org.mule.sdk.api.annotation.Operations;
import org.mule.sdk.api.runtime.process.VoidCompletionCallback;

public class JavaOperationModelParser
extends AbstractJavaExecutableComponentModelParser
implements OperationModelParser {
    private static final List<Class<?>> ROUTER_CALLBACK_PARAMETER_TYPES = Arrays.asList(RouterCompletionCallback.class, org.mule.sdk.api.runtime.process.RouterCompletionCallback.class, org.mule.runtime.extension.api.runtime.process.VoidCompletionCallback.class, VoidCompletionCallback.class, CompletionCallback.class, org.mule.sdk.api.runtime.process.CompletionCallback.class);
    private final JavaExtensionModelParser extensionModelParser;
    private final OperationElement operationElement;
    private final OperationContainerElement operationContainer;
    private final OperationContainerElement enclosingType;
    private final Optional<ExtensionParameter> configParameter;
    private final Optional<ExtensionParameter> connectionParameter;
    private ExtensionParameter nestedChain;
    private boolean blocking = false;
    private boolean scope = false;
    private boolean router = false;
    private boolean hasDeprecatedRouterCompletion = false;
    private boolean autoPaging = false;
    private List<ExtensionParameter> routes = Collections.emptyList();
    private Optional<MetadataKeyModelParser> metadataKeyModelParser;

    public JavaOperationModelParser(JavaExtensionModelParser extensionModelParser, ExtensionElement extensionElement, OperationContainerElement operationContainer, OperationElement operationElement, ExtensionLoadingContext loadingContext) {
        super(extensionElement, loadingContext);
        this.extensionModelParser = extensionModelParser;
        this.operationElement = operationElement;
        this.configParameter = JavaExtensionModelParserUtils.getConfigParameter(operationElement);
        if (!this.isIgnored()) {
            this.operationContainer = (OperationContainerElement)operationElement.getEnclosingType();
            this.enclosingType = operationContainer != null ? operationContainer : this.operationContainer;
            this.checkOperationIsNotAnExtension();
            this.connectionParameter = JavaExtensionModelParserUtils.getConnectionParameter(operationElement);
            this.parseStructure();
            this.collectAdditionalModelProperties();
        } else {
            this.operationContainer = null;
            this.enclosingType = null;
            this.connectionParameter = null;
        }
    }

    private void parseStructure() {
        List<ExtensionParameter> callbackParameters = JavaExtensionModelParserUtils.getCompletionCallbackParameters(this.operationElement);
        this.blocking = callbackParameters.isEmpty();
        this.connected = this.connectionParameter.isPresent();
        this.nestedChain = this.fetchNestedChain();
        this.scope = this.nestedChain != null;
        this.routes = JavaModelLoaderUtils.getRoutes(this.operationElement);
        boolean bl = this.router = !this.routes.isEmpty();
        if (this.scope && this.router) {
            throw new IllegalOperationModelDefinitionException(String.format("Operation '%s' is both a Scope and a Router, which is invalid", this.getName()));
        }
        this.parseComponentConnectivity(this.operationElement);
        if (this.blocking) {
            this.parseBlockingOperation();
        } else {
            this.parseNonBlockingOperation(callbackParameters);
        }
        if (!this.autoPaging) {
            this.parseComponentByteStreaming(this.operationElement);
        }
        if (this.scope) {
            this.validateScope();
        }
        if (this.router) {
            this.parseRouter();
        }
    }

    private ExtensionParameter fetchNestedChain() {
        List chains = this.operationElement.getParameters().stream().filter(JavaExtensionModelParserUtils::isProcessorChain).collect(Collectors.toList());
        if (chains.size() > 1) {
            throw new IllegalOperationModelDefinitionException(String.format("Scope '%s' declares too many parameters of type '%s', only one input of this kind is supported.Offending parameters are: %s", this.getName(), Chain.class.getSimpleName(), chains.stream().map(NamedObject::getName).collect(Collectors.toList())));
        }
        return chains.isEmpty() ? null : (ExtensionParameter)chains.get(0);
    }

    private void validateScope() {
        if (this.blocking) {
            throw new IllegalOperationModelDefinitionException(String.format("Scope '%s' does not declare a '%s' parameter. One is required for all operations that receive and execute a Chain of other components", this.getName(), CompletionCallback.class.getSimpleName()));
        }
        if (this.hasConfig()) {
            throw new IllegalOperationModelDefinitionException(String.format("Scope '%s' requires a config, but that is not allowed, remove such parameter", this.getName()));
        }
        if (this.isConnected()) {
            throw new IllegalOperationModelDefinitionException(String.format("Scope '%s' requires a connection, but that is not allowed, remove such parameter", this.getName()));
        }
    }

    private void parseRouter() {
        List callbackParameters = this.operationElement.getParameters().stream().filter(this::isRouterCallback).collect(Collectors.toList());
        if (callbackParameters.isEmpty()) {
            throw new IllegalOperationModelDefinitionException(String.format("Router '%s' does not declare a parameter with one of the types '%s'. One is required.", this.getName(), ROUTER_CALLBACK_PARAMETER_TYPES));
        }
        if (callbackParameters.size() > 1) {
            throw new IllegalOperationModelDefinitionException(String.format("Router '%s' defines more than one CompletionCallback parameters. Only one is allowed", this.getName()));
        }
        if (this.routes.isEmpty()) {
            throw new IllegalOperationModelDefinitionException(String.format("Router '%s' does not declare a '%s' parameter. One is required.", this.getName(), Route.class.getSimpleName()));
        }
        if (!IntrospectionUtils.isVoid(this.operationElement)) {
            throw new IllegalOperationModelDefinitionException(String.format("Router '%s' is not declared in a void method.", this.getName()));
        }
        this.hasDeprecatedRouterCompletion = this.operationElement.getParameters().stream().anyMatch(this::parameterOfRouterCompletionCallbackType);
    }

    private boolean isRouterCallback(ExtensionParameter p) {
        return ROUTER_CALLBACK_PARAMETER_TYPES.stream().anyMatch(type -> p.getType().isSameType((Class<?>)type));
    }

    private void parseBlockingOperation() {
        Optional<OutputResolverModelParser> outputResolverModelParser = this.getOutputResolverModelParser();
        boolean isDynamicResolver = outputResolverModelParser.isPresent() && outputResolverModelParser.get().hasOutputResolver();
        this.outputType = new DefaultOutputModelParser(CustomStaticTypeUtils.getOperationOutputType(this.operationElement), isDynamicResolver);
        Optional<AttributesResolverModelParser> attributesResolverModelParser = this.getAttributesResolverModelParser();
        isDynamicResolver = attributesResolverModelParser.isPresent() && attributesResolverModelParser.get().hasAttributesResolver();
        this.outputAttributesType = new DefaultOutputModelParser(CustomStaticTypeUtils.getOperationAttributesType(this.operationElement), isDynamicResolver);
        this.autoPaging = JavaExtensionModelParserUtils.isAutoPaging(this.operationElement);
        if (this.autoPaging) {
            this.parseAutoPaging();
        }
    }

    private void parseAutoPaging() {
        this.supportsStreaming = true;
        this.connected = true;
        this.parsePagingTx();
    }

    private void parsePagingTx() {
        Type returnTypeElement = this.operationElement.getReturnType();
        List<TypeGeneric> generics = returnTypeElement.getGenerics();
        this.transactional = !generics.isEmpty() ? JavaConnectionProviderModelParserUtils.isTransactional(generics.get(0).getConcreteType()) : false;
    }

    private void parseNonBlockingOperation(List<ExtensionParameter> callbackParameters) {
        if (callbackParameters.size() > 1) {
            throw new IllegalOperationModelDefinitionException(String.format("Operation '%s' defines more than one %s parameters. Only one is allowed", this.getName(), CompletionCallback.class.getSimpleName()));
        }
        if (!IntrospectionUtils.isVoid(this.operationElement)) {
            throw new IllegalOperationModelDefinitionException(String.format("Operation '%s' has a parameter of type %s but is not void. Non-blocking operations have to be declared as void and the return type provided through the callback", this.getName(), CompletionCallback.class.getSimpleName()));
        }
        Optional<OutputResolverModelParser> outputResolverModelParser = this.getOutputResolverModelParser();
        boolean isDynamicResolver = outputResolverModelParser.isPresent() && outputResolverModelParser.get().hasOutputResolver();
        this.outputType = new DefaultOutputModelParser(CustomStaticTypeUtils.getOperationOutputType(this.operationElement), isDynamicResolver);
        Optional<AttributesResolverModelParser> attributesResolverModelParser = this.getAttributesResolverModelParser();
        isDynamicResolver = attributesResolverModelParser.isPresent() && attributesResolverModelParser.get().hasAttributesResolver();
        this.outputAttributesType = new DefaultOutputModelParser(CustomStaticTypeUtils.getOperationAttributesType(this.operationElement), isDynamicResolver);
    }

    @Override
    public String getName() {
        return this.operationElement.getAlias();
    }

    public String getDescription() {
        return this.operationElement.getDescription();
    }

    public List<ParameterGroupModelParser> getParameterGroupModelParsers() {
        List<ExtensionParameter> methodParameters = this.isRouter() ? this.operationElement.getParameters().stream().filter(p -> !JavaModelLoaderUtils.isRoute(p) && !this.isRouterCallback((ExtensionParameter)p)).collect(Collectors.toList()) : this.operationElement.getParameters();
        ParameterDeclarationContext context = ParameterDeclarationContext.forOperation(this.getName(), this.loadingContext, this.hasKeyResolverAvailable());
        List<ParameterGroupModelParser> parameterGroupModelParsers = JavaExtensionModelParserUtils.getParameterGroupParsers(methodParameters, context);
        parameterGroupModelParsers.addAll(JavaExtensionModelParserUtils.getParameterGroupParsers(this.operationContainer.getParameters(), context, p -> new ParameterModelParserDecorator((ParameterModelParser)p){

            @Override
            public ExpressionSupport getExpressionSupport() {
                return ExpressionSupport.NOT_SUPPORTED;
            }

            @Override
            public List<ModelProperty> getAdditionalModelProperties() {
                List modelProperties = this.decoratee.getAdditionalModelProperties();
                modelProperties.add(new FieldOperationParameterModelProperty());
                return modelProperties;
            }
        }));
        return parameterGroupModelParsers;
    }

    public List<NestedRouteModelParser> getNestedRouteParsers() {
        return this.routes.stream().map(route -> new JavaNestedRouteModelParser((ExtensionParameter)route, this.loadingContext)).collect(Collectors.toList());
    }

    public Optional<NestedChainModelParser> getNestedChainParser() {
        return this.nestedChain != null ? Optional.of(new JavaNestedChainModelParser(this.nestedChain)) : Optional.empty();
    }

    public Optional<CompletableComponentExecutorFactory<?>> getExecutor() {
        return this.operationElement.getMethod().map(method -> new CompletableOperationExecutorFactory(this.enclosingType.getDeclaringClass().get(), (Method)method));
    }

    public boolean isIgnored() {
        return IntrospectionUtils.isIgnored(this.operationElement, this.loadingContext);
    }

    public boolean isScope() {
        return this.scope;
    }

    public boolean isRouter() {
        return this.router;
    }

    public boolean isAutoPaging() {
        return this.autoPaging;
    }

    public boolean hasStreamingConfiguration() {
        return this.supportsStreaming();
    }

    public boolean hasTransactionalAction() {
        return this.isTransactional();
    }

    public boolean hasReconnectionStrategy() {
        return this.isConnected();
    }

    public boolean propagatesConnectivityError() {
        return this.isConnected();
    }

    public Optional<ExecutionType> getExecutionType() {
        return JavaExtensionModelParserUtils.getExecutionType(this.operationElement);
    }

    public Optional<MediaTypeParser> getMediaType() {
        return JavaExtensionModelParserUtils.getMediaType(this.operationElement, "Operation", this.getName());
    }

    public Optional<SdkExceptionHandlerFactory> getExceptionHandlerFactory() {
        return JavaErrorModelParserUtils.getExceptionHandlerFactory(this.operationElement, "Operation", this.getName());
    }

    public Optional<MinMuleVersionParser> getResolvedMinMuleVersion() {
        return Optional.of(MinMuleVersionUtils.resolveOperationMinMuleVersion(this.operationElement, this.operationContainer, MinMuleVersionUtils.getContainerAnnotationMinMuleVersion(this.extensionElement, Operations.class, Operations::value, this.operationContainer)));
    }

    public boolean isBlocking() {
        return this.blocking;
    }

    public boolean hasConfig() {
        return this.configParameter.isPresent();
    }

    public List<ErrorModelParser> getErrorModelParsers() {
        return JavaErrorModelParserUtils.parseOperationErrorModels(this.extensionModelParser, this.extensionElement, this.operationElement);
    }

    public Optional<OutputResolverModelParser> getOutputResolverModelParser() {
        Optional<OutputResolverModelParser> outputResolverModelParser = JavaOutputResolverModelParserUtils.parseOutputResolverModelParser(this.operationElement);
        if (outputResolverModelParser.isPresent()) {
            return outputResolverModelParser;
        }
        if (this.getInputResolverModelParsers().isEmpty()) {
            return JavaOutputResolverModelParserUtils.parseOutputResolverModelParser(this.extensionElement, this.operationContainer);
        }
        return Optional.empty();
    }

    public Optional<AttributesResolverModelParser> getAttributesResolverModelParser() {
        return JavaOutputResolverModelParserUtils.parseAttributesResolverModelParser(this.operationElement);
    }

    public List<InputResolverModelParser> getInputResolverModelParsers() {
        return JavaInputResolverModelParserUtils.parseInputResolversModelParser(this.getParameterGroupModelParsers());
    }

    public Optional<MetadataKeyModelParser> getMetadataKeyModelParser() {
        return JavaMetadataKeyIdModelParserUtils.getKeyIdResolverModelParser(this, this.operationElement.getEnclosingType(), this.extensionElement);
    }

    public Optional<ScopeChainInputTypeResolverModelParser> getScopeChainInputTypeResolverModelParser() {
        if (this.isScope()) {
            return Optional.of(new JavaScopeChainInputTypeResolverModelParser(this.nestedChain));
        }
        return Optional.empty();
    }

    public Optional<RoutesChainInputTypesResolverModelParser> getRoutesChainInputTypesResolverModelParser() {
        if (this.isRouter()) {
            return Optional.of(new JavaRoutesChainInputTypesResolverModelParser(this.routes));
        }
        return Optional.empty();
    }

    private boolean hasKeyResolverAvailable() {
        return JavaMetadataKeyIdModelParserUtils.parseKeyIdResolverModelParser(this.enclosingType, this.operationElement, "operation", this.getName(), this.extensionElement.getName()).map(metadataKey -> metadataKey.hasKeyIdResolver()).orElse(false);
    }

    public Set<String> getSemanticTerms() {
        LinkedHashSet<String> terms = new LinkedHashSet<String>();
        terms.addAll(SemanticTermsHelper.getAllTermsFromAnnotations(this.operationElement::isAnnotatedWith));
        SemanticTermsParserUtils.addCustomTerms(this.operationElement, terms);
        return terms;
    }

    public Stream<NotificationModel> getEmittedNotificationsStream(Function<String, Optional<NotificationModel>> notificationMapper) {
        List<String> notifications = NotificationModelParserUtils.getEmittedNotifications(this.operationElement, this.getComponentTypeName(), this.getName());
        if (notifications.isEmpty()) {
            notifications = NotificationModelParserUtils.getEmittedNotifications(this.operationContainer, this.getComponentTypeName(), this.getName());
        }
        return notifications.stream().map(notificationMapper).filter(Optional::isPresent).map(Optional::get);
    }

    private void checkOperationIsNotAnExtension() {
        if (this.operationContainer.isAssignableFrom(this.extensionElement) || this.extensionElement.isAssignableFrom(this.operationContainer)) {
            throw new IllegalOperationModelDefinitionException(String.format("Operation class '%s' cannot be the same class (nor a derivative) of the extension class '%s", this.operationContainer.getName(), this.extensionElement.getName()));
        }
    }

    private void collectAdditionalModelProperties() {
        this.additionalModelProperties.add(new ExtensionOperationDescriptorModelProperty(this.operationElement, this.hasDeprecatedRouterCompletion));
        this.operationElement.getMethod().ifPresent(method -> this.additionalModelProperties.add(new ImplementingMethodModelProperty((Method)method)));
    }

    private boolean parameterOfRouterCompletionCallbackType(ExtensionParameter param) {
        return param.getType().isSameType(RouterCompletionCallback.class) || param.getType().isSameType(org.mule.sdk.api.runtime.process.RouterCompletionCallback.class);
    }

    @Override
    protected String getComponentTypeName() {
        if (this.isScope()) {
            return "Scope";
        }
        if (this.isRouter()) {
            return "Router";
        }
        return "Operation";
    }

    public Optional<DeprecationModel> getDeprecationModel() {
        return JavaExtensionModelParserUtils.getDeprecationModel(this.operationElement);
    }

    public Optional<DisplayModel> getDisplayModel() {
        return JavaExtensionModelParserUtils.getDisplayModel(this.operationElement, "operation", this.operationElement.getName());
    }

    public ComponentVisibility getComponentVisibility() {
        return ComponentVisibility.PUBLIC;
    }

    public Optional<StereotypeModel> getStereotype(StereotypeModelFactory factory) {
        Optional<StereotypeModel> stereotype = JavaStereotypeModelParserUtils.resolveStereotype(this.operationElement, "Operation", this.getName(), factory);
        if (!stereotype.isPresent()) {
            stereotype = JavaStereotypeModelParserUtils.resolveStereotype(this.operationContainer, "Operation", this.getName(), factory);
        }
        return stereotype;
    }

    public boolean equals(Object o) {
        if (o instanceof JavaOperationModelParser) {
            return this.operationElement.equals(((JavaOperationModelParser)o).operationElement);
        }
        return false;
    }

    public int hashCode() {
        return Objects.hash(this.operationElement);
    }
}

