/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.extension.internal.runtime.client;

import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import javax.inject.Inject;
import org.mule.runtime.api.artifact.Registry;
import org.mule.runtime.api.exception.MuleException;
import org.mule.runtime.api.exception.MuleRuntimeException;
import org.mule.runtime.api.i18n.I18nMessageFactory;
import org.mule.runtime.api.lifecycle.InitialisationException;
import org.mule.runtime.api.message.Message;
import org.mule.runtime.api.meta.model.ExtensionModel;
import org.mule.runtime.api.meta.model.operation.OperationModel;
import org.mule.runtime.api.meta.model.util.IdempotentExtensionWalker;
import org.mule.runtime.api.util.Reference;
import org.mule.runtime.core.api.MuleContext;
import org.mule.runtime.core.api.event.CoreEvent;
import org.mule.runtime.core.api.extension.ExtensionManager;
import org.mule.runtime.core.api.lifecycle.LifecycleUtils;
import org.mule.runtime.core.api.processor.ReactiveProcessor;
import org.mule.runtime.core.api.rx.Exceptions;
import org.mule.runtime.core.internal.policy.PolicyManager;
import org.mule.runtime.core.privileged.processor.MessageProcessors;
import org.mule.runtime.core.privileged.util.TemplateParser;
import org.mule.runtime.extension.api.client.ExtensionsClient;
import org.mule.runtime.extension.api.client.OperationParameters;
import org.mule.runtime.extension.api.runtime.config.ConfigurationProvider;
import org.mule.runtime.extension.api.runtime.operation.Result;
import org.mule.runtime.extension.internal.client.ComplexParameter;
import org.mule.runtime.module.extension.api.util.MuleExtensionUtils;
import org.mule.runtime.module.extension.internal.runtime.objectbuilder.DefaultObjectBuilder;
import org.mule.runtime.module.extension.internal.runtime.operation.OperationMessageProcessor;
import org.mule.runtime.module.extension.internal.runtime.operation.OperationMessageProcessorBuilder;
import org.mule.runtime.module.extension.internal.runtime.resolver.ExpressionValueResolver;
import org.mule.runtime.module.extension.internal.runtime.resolver.StaticValueResolver;
import org.mule.runtime.module.extension.internal.runtime.resolver.ValueResolver;
import org.mule.runtime.module.extension.internal.runtime.resolver.ValueResolvingContext;
import org.mule.runtime.module.extension.internal.util.ReflectionCache;
import org.reactivestreams.Publisher;
import reactor.core.publisher.Mono;

public final class DefaultExtensionsClient
implements ExtensionsClient {
    private final TemplateParser parser = TemplateParser.createMuleStyleParser();
    @Inject
    private MuleContext muleContext;
    @Inject
    private Registry registry;
    @Inject
    private PolicyManager policyManager;
    @Inject
    private ExtensionManager extensionManager;
    @Inject
    private ReflectionCache reflectionCache;
    private final CoreEvent event;

    public DefaultExtensionsClient(MuleContext muleContext, CoreEvent event, Registry registry, PolicyManager policyManager) {
        this.muleContext = muleContext;
        this.event = event;
        this.extensionManager = muleContext.getExtensionManager();
        this.registry = registry;
        this.policyManager = policyManager;
    }

    public DefaultExtensionsClient() {
        this.event = null;
    }

    public <T, A> CompletableFuture<Result<T, A>> executeAsync(String extension, String operation, OperationParameters parameters) {
        OperationMessageProcessor processor = this.createProcessor(extension, operation, parameters);
        Mono resultMono = this.process(processor).map(event -> Result.builder((Message)event.getMessage()).build()).onErrorMap(Exceptions::unwrap).doAfterTerminate(() -> this.disposeProcessor(processor));
        return resultMono.toFuture();
    }

    private Mono<CoreEvent> process(OperationMessageProcessor omp) {
        if (this.event != null) {
            return Mono.from((Publisher)MessageProcessors.processWithChildContext((CoreEvent)this.event, (ReactiveProcessor)omp, Optional.empty()));
        }
        return Mono.from(omp.apply((Publisher<CoreEvent>)Mono.just((Object)MuleExtensionUtils.getInitialiserEvent(this.muleContext))));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T, A> Result<T, A> execute(String extension, String operation, OperationParameters params) throws MuleException {
        OperationMessageProcessor processor = this.createProcessor(extension, operation, params);
        try {
            CoreEvent process = processor.process(this.getEvent());
            Result result = Result.builder((Message)process.getMessage()).build();
            return result;
        }
        finally {
            this.disposeProcessor(processor);
        }
    }

    private OperationMessageProcessor createProcessor(String extensionName, String operationName, OperationParameters parameters) {
        ExtensionModel extension = this.findExtension(extensionName);
        OperationModel operation = this.findOperation(extension, operationName);
        ConfigurationProvider config = parameters.getConfigName().map(this::findConfiguration).orElse(null);
        Map<String, ValueResolver> resolvedParams = this.resolveParameters(parameters.get(), this.getEvent());
        try {
            OperationMessageProcessor processor = (OperationMessageProcessor)((Object)new OperationMessageProcessorBuilder(extension, operation, this.policyManager, this.muleContext, this.registry).setConfigurationProvider(config).setParameters(resolvedParams).build());
            LifecycleUtils.initialiseIfNeeded((Object)((Object)processor), (MuleContext)this.muleContext);
            processor.start();
            return processor;
        }
        catch (Exception e) {
            throw new MuleRuntimeException(I18nMessageFactory.createStaticMessage((String)"Could not create Operation Message Processor"), (Throwable)e);
        }
    }

    private Map<String, ValueResolver> resolveParameters(Map<String, Object> parameters, CoreEvent event) {
        LinkedHashMap<String, ValueResolver> values = new LinkedHashMap<String, ValueResolver>();
        parameters.forEach((name, value) -> {
            if (value instanceof ComplexParameter) {
                ComplexParameter complex = (ComplexParameter)value;
                DefaultObjectBuilder builder = new DefaultObjectBuilder(complex.getType(), this.reflectionCache);
                this.resolveParameters(complex.getParameters(), event).forEach((propertyName, valueResolver) -> {
                    try {
                        LifecycleUtils.initialiseIfNeeded((Object)valueResolver, (boolean)true, (MuleContext)this.muleContext);
                        builder.addPropertyResolver((String)propertyName, (ValueResolver<Object>)valueResolver);
                    }
                    catch (InitialisationException e) {
                        throw new MuleRuntimeException((Throwable)e);
                    }
                });
                try {
                    values.put((String)name, new StaticValueResolver(builder.build(ValueResolvingContext.from(event))));
                }
                catch (MuleException e) {
                    throw new MuleRuntimeException(I18nMessageFactory.createStaticMessage((String)String.format("Could not construct parameter [%s]", name)), (Throwable)e);
                }
            } else if (value instanceof String && this.parser.isContainsTemplate((String)value)) {
                values.put((String)name, new ExpressionValueResolver((String)value));
            } else {
                values.put((String)name, new StaticValueResolver<Object>(value));
            }
        });
        return values;
    }

    private OperationModel findOperation(ExtensionModel extensionModel, final String operationName) {
        final Reference operation = new Reference();
        IdempotentExtensionWalker walker = new IdempotentExtensionWalker(){

            protected void onOperation(OperationModel operationModel) {
                if (operationName.equals(operationModel.getName())) {
                    operation.set((Object)operationModel);
                    this.stop();
                }
            }
        };
        walker.walk(extensionModel);
        if (operation.get() == null) {
            throw new MuleRuntimeException(I18nMessageFactory.createStaticMessage((String)("No Operation [" + operationName + "] Found")));
        }
        return (OperationModel)operation.get();
    }

    private ConfigurationProvider findConfiguration(String configName) {
        return (ConfigurationProvider)this.extensionManager.getConfigurationProvider(configName).orElseThrow(() -> new MuleRuntimeException(I18nMessageFactory.createStaticMessage((String)("No configuration [" + configName + "] found"))));
    }

    private ExtensionModel findExtension(String extensionName) {
        return (ExtensionModel)this.extensionManager.getExtension(extensionName).orElseThrow(() -> new MuleRuntimeException(I18nMessageFactory.createStaticMessage((String)("No Extension [" + extensionName + "] Found"))));
    }

    private void disposeProcessor(OperationMessageProcessor processor) {
        try {
            processor.stop();
            processor.dispose();
        }
        catch (MuleException e) {
            throw new MuleRuntimeException(I18nMessageFactory.createStaticMessage((String)"Error while disposing the executing operation"), (Throwable)e);
        }
    }

    private CoreEvent getEvent() {
        return this.event == null ? MuleExtensionUtils.getInitialiserEvent() : this.event;
    }
}

