/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.extension.internal.runtime.source;

import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.mule.runtime.api.component.Component;
import org.mule.runtime.api.connection.ConnectionException;
import org.mule.runtime.api.connection.ConnectionHandler;
import org.mule.runtime.api.event.Event;
import org.mule.runtime.api.i18n.I18nMessage;
import org.mule.runtime.api.i18n.I18nMessageFactory;
import org.mule.runtime.api.metadata.TypedValue;
import org.mule.runtime.api.notification.Notification;
import org.mule.runtime.api.tx.TransactionException;
import org.mule.runtime.api.util.Preconditions;
import org.mule.runtime.core.internal.execution.NotificationFunction;
import org.mule.runtime.extension.api.connectivity.TransactionalConnection;
import org.mule.runtime.extension.api.notification.NotificationActionDefinition;
import org.mule.runtime.extension.api.runtime.source.SourceCallback;
import org.mule.runtime.extension.api.runtime.source.SourceCallbackContext;
import org.mule.runtime.extension.api.tx.TransactionHandle;
import org.mule.runtime.module.extension.internal.runtime.notification.DefaultExtensionNotification;
import org.mule.runtime.module.extension.internal.runtime.source.ExtensionNotificationFunction;
import org.mule.runtime.module.extension.internal.runtime.source.SourceCallbackAdapter;
import org.mule.runtime.module.extension.internal.runtime.source.SourceCallbackContextAdapter;
import org.mule.runtime.module.extension.internal.runtime.transaction.DefaultTransactionHandle;
import org.mule.runtime.module.extension.internal.runtime.transaction.NullTransactionHandle;

class DefaultSourceCallbackContext
implements SourceCallbackContextAdapter {
    private static final TransactionHandle NULL_TRANSACTION_HANDLE = new NullTransactionHandle();
    private static final TransactionHandle DEFAULT_TRANSACTION_HANDLE = new DefaultTransactionHandle();
    private final SourceCallbackAdapter sourceCallback;
    private final Map<String, Object> variables = new HashMap<String, Object>();
    private String correlationId;
    private Object connection = null;
    private TransactionHandle transactionHandle = NULL_TRANSACTION_HANDLE;
    private boolean dispatched = false;
    private List<NotificationFunction> notificationFunctions = new LinkedList<NotificationFunction>();

    DefaultSourceCallbackContext(SourceCallbackAdapter sourceCallback) {
        this.sourceCallback = sourceCallback;
    }

    public TransactionHandle bindConnection(Object connection) throws ConnectionException, TransactionException {
        Preconditions.checkArgument((connection != null ? 1 : 0) != 0, (String)"Cannot bind a null connection");
        if (this.connection != null) {
            throw new IllegalArgumentException("Connection can only be set once per " + SourceCallbackContext.class.getSimpleName());
        }
        this.connection = connection;
        if (this.sourceCallback.getTransactionConfig().isTransacted() && connection instanceof TransactionalConnection) {
            ConnectionHandler<Object> connectionHandler = this.sourceCallback.getSourceConnectionManager().getConnectionHandler(connection).orElseThrow(() -> new TransactionException(this.createWrongConnectionMessage(connection)));
            this.sourceCallback.getTransactionSourceBinder().bindToTransaction(this.sourceCallback.getTransactionConfig(), this.sourceCallback.getConfigurationInstance(), connectionHandler);
            this.transactionHandle = DEFAULT_TRANSACTION_HANDLE;
        }
        return this.transactionHandle;
    }

    public <T> T getConnection() {
        if (this.connection == null) {
            throw new IllegalArgumentException("No connection has been bound");
        }
        return (T)this.connection;
    }

    @Override
    public void dispatched() {
        this.dispatched = true;
    }

    @Override
    public void releaseConnection() {
        if (this.connection != null) {
            this.sourceCallback.getSourceConnectionManager().release(this.connection);
            this.connection = null;
        }
    }

    public TransactionHandle getTransactionHandle() {
        return this.transactionHandle;
    }

    public boolean hasVariable(String variableName) {
        return this.variables.containsKey(variableName);
    }

    public <T> Optional<T> getVariable(String variableName) {
        return Optional.ofNullable(this.variables.get(variableName));
    }

    public void addVariable(String variableName, Object value) {
        this.variables.put(variableName, value);
    }

    public void setCorrelationId(String correlationId) {
        Preconditions.checkState((!this.dispatched ? 1 : 0) != 0, (String)"Cannot set the correlationId at this moment. This context was already used to dispatch a message");
        this.correlationId = correlationId;
    }

    public Optional<String> getCorrelationId() {
        return Optional.ofNullable(this.correlationId);
    }

    public <T, A> SourceCallback<T, A> getSourceCallback() {
        return this.sourceCallback;
    }

    public void fireOnHandle(final NotificationActionDefinition<?> action, final TypedValue<?> data) {
        this.notificationFunctions.add(new ExtensionNotificationFunction(){

            @Override
            public String getActionName() {
                return ((Enum)action).name();
            }

            public Notification apply(Event event, Component component) {
                return new DefaultExtensionNotification(event, component, action, data);
            }
        });
    }

    @Override
    public List<NotificationFunction> getNotificationsFunctions() {
        return this.notificationFunctions;
    }

    private I18nMessage createWrongConnectionMessage(Object connection) {
        return I18nMessageFactory.createStaticMessage((String)String.format("Internal Error. The transacted source [%s] from the Extension [%s] tried to bind an connection of type [%s] which is not a connection created by this extension. ", this.sourceCallback.getOwningSourceName(), this.sourceCallback.getOwningExtensionName(), connection.getClass().getName()));
    }
}

