/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.extension.internal.metadata;

import java.lang.reflect.Field;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.mule.metadata.api.model.BooleanType;
import org.mule.metadata.api.model.MetadataType;
import org.mule.metadata.api.model.ObjectType;
import org.mule.metadata.api.model.StringType;
import org.mule.metadata.api.visitor.MetadataTypeVisitor;
import org.mule.metadata.java.api.utils.JavaTypeUtils;
import org.mule.runtime.api.meta.model.ComponentModel;
import org.mule.runtime.api.meta.model.parameter.ParameterModel;
import org.mule.runtime.api.metadata.MetadataKey;
import org.mule.runtime.api.metadata.MetadataKeyBuilder;
import org.mule.runtime.api.metadata.MetadataResolvingException;
import org.mule.runtime.api.metadata.resolving.FailureCode;
import org.mule.runtime.api.util.Preconditions;
import org.mule.runtime.api.util.Reference;
import org.mule.runtime.extension.api.dsql.DsqlParser;
import org.mule.runtime.extension.api.dsql.DsqlQuery;
import org.mule.runtime.extension.api.metadata.NullMetadataKey;
import org.mule.runtime.extension.api.property.MetadataKeyIdModelProperty;
import org.mule.runtime.extension.api.property.MetadataKeyPartModelProperty;
import org.mule.runtime.module.extension.internal.loader.java.property.DeclaringMemberModelProperty;
import org.mule.runtime.module.extension.internal.loader.java.property.QueryParameterModelProperty;
import org.mule.runtime.module.extension.internal.runtime.objectbuilder.DefaultObjectBuilder;
import org.mule.runtime.module.extension.internal.runtime.resolver.StaticValueResolver;
import org.mule.runtime.module.extension.internal.util.IntrospectionUtils;
import org.mule.runtime.module.extension.internal.util.ReflectionCache;

final class MetadataKeyIdObjectResolver {
    private static final DsqlParser dsqlParser = DsqlParser.getInstance();
    private final ComponentModel component;
    private final List<ParameterModel> keyParts;

    public MetadataKeyIdObjectResolver(ComponentModel component) {
        Preconditions.checkArgument((component != null ? 1 : 0) != 0, (String)"The ComponentModel cannot be null");
        this.component = component;
        this.keyParts = this.getMetadataKeyParts(component);
    }

    public Object resolve(final MetadataKey key) throws MetadataResolvingException {
        if (this.isKeyLess()) {
            return "";
        }
        MetadataKeyIdModelProperty keyIdModelProperty = this.findMetadataKeyIdModelProperty(this.component);
        MetadataType type = keyIdModelProperty.getType();
        KeyMetadataTypeVisitor visitor = new KeyMetadataTypeVisitor(key.getId(), JavaTypeUtils.getType((MetadataType)type)){

            @Override
            protected Map<Field, String> getFieldValuesMap() throws MetadataResolvingException {
                return MetadataKeyIdObjectResolver.this.keyToFieldValueMap(key);
            }
        };
        type.accept((MetadataTypeVisitor)visitor);
        return visitor.getResultId();
    }

    public Object resolve() throws MetadataResolvingException {
        if (this.isKeyLess()) {
            return "";
        }
        if (!this.keyParts.stream().allMatch(p -> p.getDefaultValue() != null)) {
            throw new IllegalArgumentException("Could not build metadata key from an object that does not have a default value for all it's components.");
        }
        String id = this.keyParts.get(0).getDefaultValue().toString();
        MetadataKeyIdModelProperty keyIdModelProperty = this.findMetadataKeyIdModelProperty(this.component);
        MetadataType type = keyIdModelProperty.getType();
        KeyMetadataTypeVisitor visitor = new KeyMetadataTypeVisitor(id, JavaTypeUtils.getType((MetadataType)type)){

            @Override
            protected Map<Field, String> getFieldValuesMap() {
                return MetadataKeyIdObjectResolver.this.keyParts.stream().filter(p -> p.getModelProperty(DeclaringMemberModelProperty.class).isPresent()).collect(Collectors.toMap(p -> ((DeclaringMemberModelProperty)p.getModelProperty(DeclaringMemberModelProperty.class).get()).getDeclaringField(), p -> p.getDefaultValue().toString()));
            }
        };
        type.accept((MetadataTypeVisitor)visitor);
        return visitor.getResultId();
    }

    private MetadataKeyBuilder getKeyFromField(Object resolvedKey, DeclaringMemberModelProperty declaringMemberModelProperty, ReflectionCache reflectionCache) throws Exception {
        return MetadataKeyBuilder.newKey((String)String.valueOf(IntrospectionUtils.getFieldValue(resolvedKey, declaringMemberModelProperty.getDeclaringField().getName(), reflectionCache)));
    }

    MetadataKey reconstructKeyFromType(Object resolvedKey, ReflectionCache reflectionCache) throws MetadataResolvingException {
        if (this.isKeyLess() || resolvedKey == null) {
            return new NullMetadataKey();
        }
        if (this.keyParts.size() == 1) {
            return MetadataKeyBuilder.newKey((String)String.valueOf(resolvedKey)).build();
        }
        MetadataKeyBuilder rootBuilder = null;
        MetadataKeyBuilder childBuilder = null;
        for (ParameterModel p : this.keyParts) {
            try {
                if (!p.getModelProperty(DeclaringMemberModelProperty.class).isPresent()) continue;
                MetadataKeyBuilder fieldBuilder = this.getKeyFromField(resolvedKey, (DeclaringMemberModelProperty)p.getModelProperty(DeclaringMemberModelProperty.class).get(), reflectionCache);
                if (rootBuilder == null) {
                    childBuilder = rootBuilder = fieldBuilder;
                    continue;
                }
                childBuilder.withChild(fieldBuilder);
                childBuilder = fieldBuilder;
            }
            catch (Exception e) {
                throw new MetadataResolvingException("Could not construct Metadata Key part for parameter " + p.getName(), FailureCode.INVALID_METADATA_KEY, (Throwable)e);
            }
        }
        return rootBuilder != null ? rootBuilder.build() : new NullMetadataKey();
    }

    private MetadataKeyIdModelProperty findMetadataKeyIdModelProperty(ComponentModel component) throws MetadataResolvingException {
        return (MetadataKeyIdModelProperty)component.getModelProperty(MetadataKeyIdModelProperty.class).orElseThrow(() -> this.buildException(String.format("Component '%s' doesn't have a MetadataKeyId parameter associated", component.getName())));
    }

    private Object instantiateFromFieldValue(Class<?> metadataKeyType, Map<Field, String> fieldValueMap) throws MetadataResolvingException {
        try {
            DefaultObjectBuilder objectBuilder = new DefaultObjectBuilder(metadataKeyType);
            fieldValueMap.forEach((f, v) -> objectBuilder.addPropertyResolver(f.getName(), new StaticValueResolver<String>((String)v)));
            return objectBuilder.build(null);
        }
        catch (Exception e) {
            throw this.buildException(String.format("MetadataKey object of type '%s' from the component '%s' could not be instantiated", metadataKeyType.getSimpleName(), this.component.getName()), e);
        }
    }

    private Map<Field, String> keyToFieldValueMap(MetadataKey key) throws MetadataResolvingException {
        Map fieldParts = this.keyParts.stream().filter(p -> p.getModelProperty(DeclaringMemberModelProperty.class).isPresent()).map(p -> ((DeclaringMemberModelProperty)p.getModelProperty(DeclaringMemberModelProperty.class).get()).getDeclaringField()).collect(Collectors.toMap(Field::getName, Function.identity()));
        Map<String, String> currentParts = this.getCurrentParts(key);
        List missingParts = fieldParts.keySet().stream().filter(partName -> !currentParts.containsKey(partName)).collect(Collectors.toList());
        if (!missingParts.isEmpty()) {
            throw this.buildException(String.format("The given MetadataKey does not provide all the required levels. Missing levels: %s", missingParts));
        }
        return currentParts.entrySet().stream().filter(keyEntry -> fieldParts.containsKey(keyEntry.getKey())).collect(Collectors.toMap(keyEntry -> (Field)fieldParts.get(keyEntry.getKey()), Map.Entry::getValue));
    }

    private Map<String, String> getCurrentParts(MetadataKey key) throws MetadataResolvingException {
        HashMap<String, String> keyParts = new HashMap<String, String>();
        keyParts.put(key.getPartName(), key.getId());
        while (!key.getChilds().isEmpty()) {
            if (key.getChilds().size() > 1) {
                List keyNames = key.getChilds().stream().map(MetadataKey::getId).collect(Collectors.toList());
                throw this.buildException(String.format("MetadataKey used for Metadata resolution must only have one child per level. Key '%s' has %s as children.", key.getId(), keyNames));
            }
            key = (MetadataKey)key.getChilds().iterator().next();
            keyParts.put(key.getPartName(), key.getId());
        }
        return keyParts;
    }

    private MetadataResolvingException buildException(String message) {
        return this.buildException(message, null);
    }

    private MetadataResolvingException buildException(String message, Exception cause) {
        return cause == null ? new MetadataResolvingException(message, FailureCode.INVALID_METADATA_KEY) : new MetadataResolvingException(message, FailureCode.INVALID_METADATA_KEY, (Throwable)cause);
    }

    private Optional<QueryParameterModelProperty> getQueryModelProperty() {
        return this.component.getAllParameterModels().stream().filter(p -> p.getModelProperty(QueryParameterModelProperty.class).isPresent()).map(p -> (QueryParameterModelProperty)p.getModelProperty(QueryParameterModelProperty.class).get()).findAny();
    }

    public boolean isKeyLess() {
        return this.keyParts.isEmpty();
    }

    private List<ParameterModel> getMetadataKeyParts(ComponentModel componentModel) {
        return componentModel.getAllParameterModels().stream().filter(p -> p.getModelProperty(MetadataKeyPartModelProperty.class).isPresent()).sorted((p1, p2) -> {
            Optional mk1 = p1.getModelProperty(MetadataKeyPartModelProperty.class);
            Optional mk2 = p2.getModelProperty(MetadataKeyPartModelProperty.class);
            return ((MetadataKeyPartModelProperty)mk1.get()).getOrder() - ((MetadataKeyPartModelProperty)mk2.get()).getOrder();
        }).collect(Collectors.toList());
    }

    private abstract class KeyMetadataTypeVisitor
    extends MetadataTypeVisitor {
        private final Reference<Object> keyValueHolder = new Reference();
        private final Reference<MetadataResolvingException> exceptionValueHolder = new Reference();
        private String id;
        private Class metadataKeyType;

        public KeyMetadataTypeVisitor(String id, Class metadataKeyType) {
            this.id = id;
            this.metadataKeyType = metadataKeyType;
        }

        protected void defaultVisit(MetadataType metadataType) {
            this.exceptionValueHolder.set((Object)MetadataKeyIdObjectResolver.this.buildException(String.format("'%s' type is invalid for MetadataKeyId parameters, use String type instead. Affecting component: '%s'", this.metadataKeyType.getSimpleName(), MetadataKeyIdObjectResolver.this.component.getName())));
        }

        public void visitBoolean(BooleanType booleanType) {
            this.keyValueHolder.set((Object)Boolean.valueOf(this.id));
        }

        public void visitString(StringType stringType) {
            if (this.metadataKeyType.isEnum()) {
                this.keyValueHolder.set(Enum.valueOf(this.metadataKeyType, this.id));
            } else if (MetadataKeyIdObjectResolver.this.getQueryModelProperty().isPresent() && DsqlParser.isDsqlQuery((String)this.id)) {
                DsqlQuery dsqlQuery = dsqlParser.parse(this.id);
                this.keyValueHolder.set((Object)dsqlQuery);
            } else {
                this.keyValueHolder.set((Object)this.id);
            }
        }

        public void visitObject(ObjectType objectType) {
            try {
                this.keyValueHolder.set(MetadataKeyIdObjectResolver.this.instantiateFromFieldValue(this.metadataKeyType, this.getFieldValuesMap()));
            }
            catch (MetadataResolvingException e) {
                this.exceptionValueHolder.set((Object)e);
            }
        }

        protected abstract Map<Field, String> getFieldValuesMap() throws MetadataResolvingException;

        public Object getResultId() throws MetadataResolvingException {
            if (this.exceptionValueHolder.get() != null) {
                throw (MetadataResolvingException)((Object)this.exceptionValueHolder.get());
            }
            return this.keyValueHolder.get();
        }
    }
}

