/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.extension.internal.manager;

import java.util.Optional;
import java.util.Set;
import org.mule.runtime.api.component.ComponentIdentifier;
import org.mule.runtime.api.connection.ConnectionException;
import org.mule.runtime.api.exception.ErrorTypeRepository;
import org.mule.runtime.api.exception.MuleRuntimeException;
import org.mule.runtime.api.i18n.I18nMessageFactory;
import org.mule.runtime.api.message.ErrorType;
import org.mule.runtime.api.meta.NamedObject;
import org.mule.runtime.api.meta.model.ComponentModel;
import org.mule.runtime.api.meta.model.ExtensionModel;
import org.mule.runtime.api.meta.model.construct.ConstructModel;
import org.mule.runtime.api.meta.model.error.ErrorModel;
import org.mule.runtime.api.meta.model.error.ErrorModelBuilder;
import org.mule.runtime.api.meta.model.operation.OperationModel;
import org.mule.runtime.api.meta.model.util.IdempotentExtensionWalker;
import org.mule.runtime.core.api.exception.Errors;
import org.mule.runtime.core.api.exception.ExceptionMapper;
import org.mule.runtime.core.api.retry.policy.RetryPolicyExhaustedException;
import org.mule.runtime.core.privileged.exception.ErrorTypeLocator;
import org.mule.runtime.extension.api.dsl.syntax.resolver.DslSyntaxResolver;
import org.mule.runtime.extension.api.dsl.syntax.resolver.ImportTypesStrategy;
import org.mule.runtime.extension.api.dsl.syntax.resolver.SingleExtensionImportTypesStrategy;
import org.mule.runtime.module.extension.internal.util.MuleExtensionUtils;

class ExtensionErrorsRegistrant {
    public static final String MULE = Errors.CORE_NAMESPACE_NAME;
    private final ErrorTypeRepository errorTypeRepository;
    private final ErrorTypeLocator errorTypeLocator;

    ExtensionErrorsRegistrant(ErrorTypeRepository errorTypeRepository, ErrorTypeLocator errorTypeLocator) {
        this.errorTypeRepository = errorTypeRepository;
        this.errorTypeLocator = errorTypeLocator;
    }

    void registerErrors(final ExtensionModel extensionModel) {
        final Set errorTypes = extensionModel.getErrorModels();
        final String extensionNamespace = extensionModel.getXmlDslModel().getPrefix();
        String errorExtensionNamespace = MuleExtensionUtils.getExtensionsNamespace(extensionModel);
        final DslSyntaxResolver syntaxResolver = DslSyntaxResolver.getDefault((ExtensionModel)extensionModel, (ImportTypesStrategy)new SingleExtensionImportTypesStrategy());
        final ErrorModel connectivityErrorModel = ErrorModelBuilder.newError((String)"CONNECTIVITY", (String)errorExtensionNamespace).withParent(ErrorModelBuilder.newError((String)"CONNECTIVITY", (String)MULE).build()).build();
        final ErrorModel retryExhaustedError = ErrorModelBuilder.newError((String)"RETRY_EXHAUSTED", (String)errorExtensionNamespace).withParent(ErrorModelBuilder.newError((String)"RETRY_EXHAUSTED", (String)MULE).build()).build();
        errorTypes.forEach(errorModel -> this.getErrorType((ErrorModel)errorModel, extensionModel));
        IdempotentExtensionWalker extensionWalker = new IdempotentExtensionWalker(){

            protected void onOperation(OperationModel model) {
                this.registerErrors((ComponentModel)model);
            }

            protected void onConstruct(ConstructModel model) {
                this.registerErrors((ComponentModel)model);
            }

            private void registerErrors(ComponentModel model) {
                if (!errorTypes.isEmpty()) {
                    ExceptionMapper.Builder builder = ExceptionMapper.builder();
                    builder.addExceptionMapping(ConnectionException.class, ExtensionErrorsRegistrant.this.getErrorType(connectivityErrorModel, extensionModel));
                    builder.addExceptionMapping(RetryPolicyExhaustedException.class, ExtensionErrorsRegistrant.this.getErrorType(retryExhaustedError, extensionModel));
                    String elementName = syntaxResolver.resolve((NamedObject)model).getElementName();
                    ExtensionErrorsRegistrant.this.errorTypeLocator.addComponentExceptionMapper(ExtensionErrorsRegistrant.createIdentifier(elementName, extensionNamespace), builder.build());
                }
            }
        };
        extensionWalker.walk(extensionModel);
    }

    private ErrorType getErrorType(ErrorModel errorModel, ExtensionModel extensionModel) {
        ComponentIdentifier identifier = ExtensionErrorsRegistrant.createIdentifier(errorModel.getType(), errorModel.getNamespace());
        Optional optionalError = this.errorTypeRepository.getErrorType(identifier);
        return optionalError.orElseGet(() -> this.createErrorType(errorModel, identifier, extensionModel));
    }

    private ErrorType createErrorType(ErrorModel errorModel, ComponentIdentifier identifier, ExtensionModel extensionModel) {
        if (identifier.getNamespace().equals(MULE)) {
            throw new MuleRuntimeException(I18nMessageFactory.createStaticMessage((String)String.format("The extension [%s] tried to register the [%s] error with [%s] namespace, which is not allowed.", extensionModel.getName(), identifier, MULE)));
        }
        ErrorType errorType = errorModel.getParent().isPresent() ? this.errorTypeRepository.addErrorType(identifier, this.getErrorType((ErrorModel)errorModel.getParent().get(), extensionModel)) : this.errorTypeRepository.addErrorType(identifier, null);
        return errorType;
    }

    private static ComponentIdentifier createIdentifier(String name, String namespace) {
        return ComponentIdentifier.builder().name(name).namespace(namespace).build();
    }
}

