/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.extension.internal.loader.java;

import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.mule.metadata.api.builder.BaseTypeBuilder;
import org.mule.metadata.api.model.AnyType;
import org.mule.metadata.api.model.MetadataFormat;
import org.mule.metadata.api.model.MetadataType;
import org.mule.metadata.java.api.JavaTypeLoader;
import org.mule.runtime.api.meta.model.ModelProperty;
import org.mule.runtime.api.meta.model.declaration.fluent.ComponentDeclarer;
import org.mule.runtime.api.meta.model.declaration.fluent.Declarer;
import org.mule.runtime.api.meta.model.declaration.fluent.ExecutableComponentDeclarer;
import org.mule.runtime.api.meta.model.declaration.fluent.ExtensionDeclarer;
import org.mule.runtime.api.meta.model.declaration.fluent.HasModelProperties;
import org.mule.runtime.api.meta.model.declaration.fluent.HasOperationDeclarer;
import org.mule.runtime.api.meta.model.declaration.fluent.NamedDeclaration;
import org.mule.runtime.api.meta.model.declaration.fluent.OperationDeclarer;
import org.mule.runtime.api.util.Preconditions;
import org.mule.runtime.extension.api.annotation.execution.Execution;
import org.mule.runtime.extension.api.connectivity.TransactionalConnection;
import org.mule.runtime.extension.api.exception.IllegalOperationModelDefinitionException;
import org.mule.runtime.extension.api.runtime.process.CompletionCallback;
import org.mule.runtime.extension.internal.property.PagedOperationModelProperty;
import org.mule.runtime.module.extension.api.loader.java.property.ComponentExecutorModelProperty;
import org.mule.runtime.module.extension.api.loader.java.type.ExtensionParameter;
import org.mule.runtime.module.extension.api.loader.java.type.MethodElement;
import org.mule.runtime.module.extension.api.loader.java.type.OperationContainerElement;
import org.mule.runtime.module.extension.api.loader.java.type.OperationElement;
import org.mule.runtime.module.extension.api.loader.java.type.Type;
import org.mule.runtime.module.extension.api.loader.java.type.TypeGeneric;
import org.mule.runtime.module.extension.api.loader.java.type.WithOperationContainers;
import org.mule.runtime.module.extension.internal.loader.java.AbstractModelLoaderDelegate;
import org.mule.runtime.module.extension.internal.loader.java.DefaultJavaModelLoaderDelegate;
import org.mule.runtime.module.extension.internal.loader.java.RouterModelLoaderDelegate;
import org.mule.runtime.module.extension.internal.loader.java.ScopeModelLoaderDelegate;
import org.mule.runtime.module.extension.internal.loader.java.property.ImplementingMethodModelProperty;
import org.mule.runtime.module.extension.internal.loader.java.type.property.ExtensionOperationDescriptorModelProperty;
import org.mule.runtime.module.extension.internal.loader.utils.ModelLoaderUtils;
import org.mule.runtime.module.extension.internal.loader.utils.ParameterDeclarationContext;
import org.mule.runtime.module.extension.internal.runtime.execution.ReflectiveOperationExecutorFactory;
import org.mule.runtime.module.extension.internal.util.IntrospectionUtils;

final class OperationModelLoaderDelegate
extends AbstractModelLoaderDelegate {
    private static final String OPERATION = "Operation";
    private static final AnyType ANY_TYPE = BaseTypeBuilder.create((MetadataFormat)JavaTypeLoader.JAVA).anyType().build();
    private final Map<MethodElement, OperationDeclarer> operationDeclarers = new HashMap<MethodElement, OperationDeclarer>();
    private final ScopeModelLoaderDelegate scopesDelegate;
    private final RouterModelLoaderDelegate routersDelegate;

    OperationModelLoaderDelegate(DefaultJavaModelLoaderDelegate delegate) {
        super(delegate);
        this.scopesDelegate = new ScopeModelLoaderDelegate(delegate);
        this.routersDelegate = new RouterModelLoaderDelegate(delegate);
    }

    void declareOperations(ExtensionDeclarer extensionDeclarer, HasOperationDeclarer declarer, WithOperationContainers operationContainers) {
        operationContainers.getOperationContainers().forEach(operationContainer -> this.declareOperations(extensionDeclarer, declarer, (OperationContainerElement)operationContainer));
    }

    void declareOperations(ExtensionDeclarer extensionDeclarer, HasOperationDeclarer declarer, OperationContainerElement operationsContainer) {
        this.declareOperations(extensionDeclarer, declarer, operationsContainer, operationsContainer.getOperations(), true);
    }

    void declareOperations(ExtensionDeclarer extensionDeclarer, HasOperationDeclarer ownerDeclarer, OperationContainerElement methodOwnerClass, List<OperationElement> operations, boolean supportsConfig) {
        for (OperationElement operationMethod : operations) {
            OperationContainerElement methodOwner = (OperationContainerElement)operationMethod.getEnclosingType();
            OperationContainerElement enclosingType = methodOwnerClass != null ? methodOwnerClass : methodOwner;
            this.checkOperationIsNotAnExtension(methodOwner);
            Optional<ExtensionParameter> configParameter = this.loader.getConfigParameter(operationMethod);
            Optional<ExtensionParameter> connectionParameter = this.loader.getConnectionParameter(operationMethod);
            if (ModelLoaderUtils.isScope(operationMethod)) {
                this.scopesDelegate.declareScope(extensionDeclarer, ownerDeclarer, enclosingType, operationMethod, configParameter, connectionParameter);
                continue;
            }
            if (ModelLoaderUtils.isRouter(operationMethod)) {
                this.routersDelegate.declareRouter(extensionDeclarer, ownerDeclarer, enclosingType, operationMethod, configParameter, connectionParameter);
                continue;
            }
            OperationModelLoaderDelegate.checkDefinition(!this.loader.isInvalidConfigSupport(supportsConfig, configParameter, connectionParameter), String.format("Operation '%s' is defined at the extension level but it requires a config. Remove such parameter or move the operation to the proper config", "TODO"));
            HasOperationDeclarer actualDeclarer = this.selectDeclarer(extensionDeclarer, (Declarer)ownerDeclarer, operationMethod, configParameter, connectionParameter);
            if (this.operationDeclarers.containsKey(operationMethod)) {
                actualDeclarer.withOperation(this.operationDeclarers.get(operationMethod));
                continue;
            }
            OperationDeclarer operationDeclarer = actualDeclarer.withOperation(operationMethod.getAlias());
            operationDeclarer.withModelProperty((ModelProperty)new ExtensionOperationDescriptorModelProperty(operationMethod));
            Optional<Method> method = operationMethod.getMethod();
            Optional<Class<?>> declaringClass = enclosingType.getDeclaringClass();
            if (method.isPresent() && declaringClass.isPresent()) {
                ((OperationDeclarer)operationDeclarer.withModelProperty((ModelProperty)new ImplementingMethodModelProperty(method.get()))).withModelProperty((ModelProperty)new ComponentExecutorModelProperty(new ReflectiveOperationExecutorFactory(declaringClass.get(), method.get())));
            }
            this.loader.addExceptionEnricher(operationMethod, (HasModelProperties)operationDeclarer);
            List<ExtensionParameter> fieldParameters = methodOwner.getParameters();
            this.processComponentConnectivity((ExecutableComponentDeclarer)operationDeclarer, operationMethod, operationMethod);
            if (ModelLoaderUtils.isNonBlocking(operationMethod)) {
                OperationModelLoaderDelegate.processNonBlockingOperation(operationDeclarer, operationMethod, true);
            } else {
                this.processBlockingOperation(supportsConfig, operationMethod, operationDeclarer);
            }
            this.addExecutionType(operationDeclarer, operationMethod);
            ParameterDeclarationContext declarationContext = new ParameterDeclarationContext(OPERATION, (NamedDeclaration)operationDeclarer.getDeclaration());
            this.processMimeType((HasModelProperties)operationDeclarer, operationMethod);
            this.declareParameters((ComponentDeclarer)operationDeclarer, operationMethod.getParameters(), fieldParameters, declarationContext);
            this.operationDeclarers.put(operationMethod, operationDeclarer);
        }
    }

    private void processBlockingOperation(boolean supportsConfig, MethodElement operationMethod, OperationDeclarer operation) {
        operation.blocking(true);
        operation.withOutputAttributes().ofType(operationMethod.getAttributesMetadataType());
        MetadataType outputType = operationMethod.getReturnMetadataType();
        if (ModelLoaderUtils.isAutoPaging(operationMethod)) {
            ((OperationDeclarer)operation.supportsStreaming(true)).withOutput().ofType(outputType);
            this.addPagedOperationModelProperty(operationMethod, operation, supportsConfig);
            this.processPagingTx(operation, operationMethod);
        } else {
            operation.withOutput().ofType(outputType);
            ModelLoaderUtils.handleByteStreaming(operationMethod, (ExecutableComponentDeclarer)operation, outputType);
        }
    }

    private HasOperationDeclarer selectDeclarer(ExtensionDeclarer extensionDeclarer, Declarer declarer, MethodElement operationMethod, Optional<ExtensionParameter> configParameter, Optional<ExtensionParameter> connectionParameter) {
        if (ModelLoaderUtils.isAutoPaging(operationMethod)) {
            return (HasOperationDeclarer)declarer;
        }
        return (HasOperationDeclarer)this.loader.selectDeclarerBasedOnConfig(extensionDeclarer, declarer, configParameter, connectionParameter);
    }

    static void processNonBlockingOperation(OperationDeclarer operation, MethodElement operationMethod, boolean allowStreaming) {
        List callbackParameters = operationMethod.getParameters().stream().filter(p -> p.getType().isSameType(CompletionCallback.class)).collect(Collectors.toList());
        OperationModelLoaderDelegate.checkDefinition(!callbackParameters.isEmpty(), String.format("Operation '%s' does not declare a '%s' parameter. One is required for a non-blocking operation", operationMethod.getAlias(), CompletionCallback.class.getSimpleName()));
        OperationModelLoaderDelegate.checkDefinition(callbackParameters.size() <= 1, String.format("Operation '%s' defines more than one %s parameters. Only one is allowed", operationMethod.getAlias(), CompletionCallback.class.getSimpleName()));
        OperationModelLoaderDelegate.checkDefinition(IntrospectionUtils.isVoid(operationMethod), String.format("Operation '%s' has a parameter of type %s but is not void. Non-blocking operations have to be declared as void and the return type provided through the callback", operationMethod.getAlias(), CompletionCallback.class.getSimpleName()));
        ExtensionParameter callbackParameter = (ExtensionParameter)callbackParameters.get(0);
        List genericTypes = callbackParameter.getType().getGenerics().stream().map(generic -> generic.getConcreteType().asMetadataType()).collect(Collectors.toList());
        if (genericTypes.isEmpty()) {
            genericTypes.add(ANY_TYPE);
            genericTypes.add(ANY_TYPE);
        }
        operation.withOutput().ofType((MetadataType)genericTypes.get(0));
        operation.withOutputAttributes().ofType((MetadataType)genericTypes.get(1));
        operation.blocking(false);
        if (allowStreaming) {
            ModelLoaderUtils.handleByteStreaming(operationMethod, (ExecutableComponentDeclarer)operation, (MetadataType)genericTypes.get(0));
        } else {
            operation.supportsStreaming(false);
        }
    }

    private void addExecutionType(OperationDeclarer operationDeclarer, MethodElement operationMethod) {
        operationMethod.getAnnotation(Execution.class).ifPresent(a -> operationDeclarer.withExecutionType(a.value()));
    }

    private void checkOperationIsNotAnExtension(OperationContainerElement operationType) {
        if (operationType.isAssignableFrom(this.getExtensionElement()) || this.getExtensionElement().isAssignableFrom(operationType)) {
            throw new IllegalOperationModelDefinitionException(String.format("Operation class '%s' cannot be the same class (nor a derivative) of the extension class '%s", operationType.getName(), this.getExtensionElement().getName()));
        }
    }

    private void addPagedOperationModelProperty(MethodElement operationMethod, OperationDeclarer operation, boolean supportsConfig) {
        OperationModelLoaderDelegate.checkDefinition(supportsConfig, String.format("Paged operation '%s' is defined at the extension level but it requires a config, since connections are required for paging", operationMethod.getName()));
        operation.withModelProperty((ModelProperty)new PagedOperationModelProperty());
        operation.requiresConnection(true);
    }

    private void processPagingTx(OperationDeclarer operation, MethodElement method) {
        Preconditions.checkArgument((method != null ? 1 : 0) != 0, (String)"Can't introspect a null method");
        Type returnTypeElement = method.getReturnType();
        List<TypeGeneric> generics = returnTypeElement.getGenerics();
        if (!generics.isEmpty()) {
            operation.transactional(generics.get(0).getConcreteType().isAssignableTo(TransactionalConnection.class));
        } else {
            operation.transactional(false);
        }
    }

    static void checkDefinition(boolean condition, String message) {
        if (!condition) {
            throw new IllegalOperationModelDefinitionException(message);
        }
    }
}

