/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.extension.internal.runtime.objectbuilder;

import java.lang.reflect.Field;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.mule.runtime.api.exception.MuleException;
import org.mule.runtime.api.util.Preconditions;
import org.mule.runtime.module.extension.internal.runtime.objectbuilder.ObjectBuilder;
import org.mule.runtime.module.extension.internal.runtime.objectbuilder.ObjectBuilderUtils;
import org.mule.runtime.module.extension.internal.runtime.resolver.ResolverUtils;
import org.mule.runtime.module.extension.internal.runtime.resolver.ValueResolver;
import org.mule.runtime.module.extension.internal.runtime.resolver.ValueResolvingContext;
import org.mule.runtime.module.extension.internal.util.IntrospectionUtils;
import org.mule.runtime.module.extension.internal.util.MuleExtensionUtils;
import org.springframework.util.ReflectionUtils;

public class DefaultObjectBuilder<T>
implements ObjectBuilder<T> {
    protected final Class<T> prototypeClass;
    protected final Map<Field, ValueResolver<Object>> resolvers = new HashMap<Field, ValueResolver<Object>>();
    private String name = null;
    private String encoding = null;

    public DefaultObjectBuilder(Class<T> prototypeClass) {
        IntrospectionUtils.checkInstantiable(prototypeClass);
        this.prototypeClass = prototypeClass;
    }

    public ObjectBuilder<T> addPropertyResolver(String propertyName, ValueResolver<? extends Object> resolver) {
        Preconditions.checkArgument((!StringUtils.isBlank((CharSequence)propertyName) ? 1 : 0) != 0, (String)"property name cannot be blank");
        Preconditions.checkArgument((resolver != null ? 1 : 0) != 0, (String)"resolver cannot be null");
        Field field = IntrospectionUtils.getField(this.prototypeClass, propertyName).orElseThrow(() -> new IllegalArgumentException(String.format("Class '%s' does not contain property '%s'", this.prototypeClass.getName(), propertyName)));
        field.setAccessible(true);
        this.resolvers.put(field, resolver);
        return this;
    }

    @Override
    public boolean isDynamic() {
        return MuleExtensionUtils.hasAnyDynamic(this.resolvers.values());
    }

    @Override
    public T build(ValueResolvingContext context) throws MuleException {
        T object = ObjectBuilderUtils.createInstance(this.prototypeClass);
        for (Map.Entry<Field, ValueResolver<Object>> entry : this.resolvers.entrySet()) {
            ReflectionUtils.setField((Field)entry.getKey(), object, (Object)ResolverUtils.resolveValue(entry.getValue(), context));
        }
        IntrospectionUtils.injectFields(object, this.name, this.encoding);
        return object;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setEncoding(String encoding) {
        this.encoding = encoding;
    }
}

