/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.extension.internal.loader.utils;

import java.io.InputStream;
import java.lang.reflect.Method;
import org.mule.metadata.api.model.MetadataType;
import org.mule.runtime.api.meta.model.declaration.fluent.ExecutableComponentDeclarer;
import org.mule.runtime.extension.api.annotation.Streaming;
import org.mule.runtime.extension.api.runtime.process.CompletionCallback;
import org.mule.runtime.extension.api.runtime.route.Chain;
import org.mule.runtime.extension.api.runtime.route.Route;
import org.mule.runtime.extension.api.runtime.streaming.PagingProvider;
import org.mule.runtime.extension.api.util.ExtensionMetadataTypeUtils;
import org.mule.runtime.module.extension.internal.loader.java.type.ExtensionParameter;
import org.mule.runtime.module.extension.internal.loader.java.type.MethodElement;

public final class ModelLoaderUtils {
    private ModelLoaderUtils() {
    }

    public static boolean isScope(MethodElement methodElement) {
        return methodElement.getParameters().stream().anyMatch(ModelLoaderUtils::isProcessorChain);
    }

    public static boolean isRouter(MethodElement methodElement) {
        return methodElement.getParameters().stream().anyMatch(ModelLoaderUtils::isRoute);
    }

    public static boolean isRoute(ExtensionParameter parameter) {
        return Route.class.isAssignableFrom(parameter.getType().getDeclaringClass());
    }

    public static boolean isNonBlocking(MethodElement method) {
        return method.getParameters().stream().anyMatch(p -> CompletionCallback.class.isAssignableFrom(p.getType().getDeclaringClass()));
    }

    public static boolean isAutoPaging(MethodElement operationMethod) {
        return PagingProvider.class.isAssignableFrom(operationMethod.getReturnType());
    }

    public static boolean isProcessorChain(ExtensionParameter parameter) {
        return Chain.class.equals((Object)parameter.getType().getDeclaringClass());
    }

    public static void handleByteStreaming(Method method, ExecutableComponentDeclarer executableComponent, MetadataType outputType) {
        executableComponent.supportsStreaming(ModelLoaderUtils.isInputStream(outputType) || method.getAnnotation(Streaming.class) != null);
    }

    public static boolean isInputStream(MetadataType type) {
        return ModelLoaderUtils.isAssignableFrom(type, InputStream.class);
    }

    private static boolean isAssignableFrom(MetadataType metadataType, Class<?> type) {
        return ExtensionMetadataTypeUtils.getType((MetadataType)metadataType).map(clazz -> type.isAssignableFrom((Class<?>)clazz)).orElse(false);
    }
}

