/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.extension.internal.loader.enricher.stereotypes;

import java.lang.annotation.Annotation;
import java.util.Map;
import org.mule.runtime.api.meta.model.declaration.fluent.WithStereotypesDeclaration;
import org.mule.runtime.api.meta.model.stereotype.StereotypeModel;
import org.mule.runtime.api.meta.model.stereotype.StereotypeModelBuilder;
import org.mule.runtime.core.api.util.ClassUtils;
import org.mule.runtime.core.api.util.StringUtils;
import org.mule.runtime.extension.api.annotation.param.stereotype.Stereotype;
import org.mule.runtime.extension.api.annotation.param.stereotype.Validator;
import org.mule.runtime.extension.api.exception.IllegalModelDefinitionException;
import org.mule.runtime.extension.api.stereotype.MuleStereotypes;
import org.mule.runtime.extension.api.stereotype.StereotypeDefinition;
import org.mule.runtime.module.extension.internal.loader.java.type.WithAnnotations;

abstract class StereotypeResolver<T extends WithAnnotations> {
    protected final T annotatedElement;
    protected final WithStereotypesDeclaration declaration;
    protected final String namespace;
    protected final StereotypeModel fallbackStereotype;
    protected Validator validatorAnnotation;
    protected Stereotype stereotypeAnnotation;
    protected Map<StereotypeDefinition, StereotypeModel> stereotypesCache;

    protected static StereotypeModel createCustomStereotype(Class<? extends StereotypeDefinition> definitionClass, String namespace, Map<StereotypeDefinition, StereotypeModel> stereotypesCache) {
        try {
            return StereotypeResolver.getStereotype((StereotypeDefinition)ClassUtils.instantiateClass(definitionClass, (Object[])new Object[0]), namespace, stereotypesCache);
        }
        catch (Exception e) {
            throw new IllegalModelDefinitionException("Invalid StereotypeDefinition found with name: " + definitionClass.getName(), (Throwable)e);
        }
    }

    protected static StereotypeModel getStereotype(StereotypeDefinition stereotypeDefinition, String namespace, Map<StereotypeDefinition, StereotypeModel> stereotypesCache) {
        return stereotypesCache.computeIfAbsent(stereotypeDefinition, definition -> {
            if (!StereotypeResolver.isValidStereotype(stereotypeDefinition, namespace)) {
                throw new IllegalModelDefinitionException(String.format("Stereotype '%s' defines namespace '%s' which doesn't match extension stereotype '%s'. No extension can define stereotypes on namespaces other than its own", stereotypeDefinition.getName(), stereotypeDefinition.getNamespace(), namespace));
            }
            StereotypeModelBuilder builder = StereotypeModelBuilder.newStereotype((String)stereotypeDefinition.getName(), (String)namespace);
            stereotypeDefinition.getParent().ifPresent(parent -> {
                String parentNamespace = parent.getNamespace();
                if (StringUtils.isBlank((String)parentNamespace)) {
                    parentNamespace = namespace;
                }
                builder.withParent(StereotypeResolver.getStereotype(parent, parentNamespace, stereotypesCache));
            });
            return builder.build();
        });
    }

    private static boolean isValidStereotype(StereotypeDefinition stereotypeDefinition, String namespace) {
        if (StringUtils.isBlank((String)stereotypeDefinition.getNamespace())) {
            return true;
        }
        return namespace.equals(stereotypeDefinition.getNamespace()) || "MULE".equals(stereotypeDefinition.getNamespace());
    }

    protected StereotypeResolver(T annotatedElement, WithStereotypesDeclaration declaration, String namespace, StereotypeModel fallbackStereotype, Map<StereotypeDefinition, StereotypeModel> stereotypesCache) {
        this.annotatedElement = annotatedElement;
        this.declaration = declaration;
        this.namespace = namespace;
        this.stereotypesCache = stereotypesCache;
        this.fallbackStereotype = fallbackStereotype;
        this.stereotypeAnnotation = this.getAnnotation(Stereotype.class);
        this.validatorAnnotation = this.getAnnotation(Validator.class);
        if (this.validatorAnnotation != null && this.stereotypeAnnotation != null) {
            throw new IllegalModelDefinitionException(String.format("%s is annotated with both @%s and @%s. Only one can be provided at the same time for the same component", this.resolveDescription(), Stereotype.class.getSimpleName(), Validator.class.getSimpleName()));
        }
    }

    protected abstract <T extends Annotation> T getAnnotation(Class<T> var1);

    protected abstract String resolveDescription();

    protected void resolveStereotype() {
        if (this.validatorAnnotation != null) {
            this.addValidationStereotype();
        } else if (this.stereotypeAnnotation != null) {
            this.declaration.withStereotype(this.createCustomStereotype());
        } else {
            this.addFallbackStereotype();
        }
    }

    protected void addFallbackStereotype() {
        this.declaration.withStereotype(this.fallbackStereotype);
    }

    protected StereotypeModel createCustomStereotype() {
        return StereotypeResolver.createCustomStereotype(this.stereotypeAnnotation.value(), this.namespace, this.stereotypesCache);
    }

    protected void addValidationStereotype() {
        this.declaration.withStereotype(StereotypeModelBuilder.newStereotype((String)MuleStereotypes.VALIDATOR_DEFINITION.getName(), (String)this.namespace).withParent(MuleStereotypes.VALIDATOR).build());
    }
}

