/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.extension.internal.runtime.source;

import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import javax.transaction.TransactionManager;
import org.mule.runtime.api.connection.ConnectionException;
import org.mule.runtime.api.connection.ConnectionHandler;
import org.mule.runtime.api.tx.TransactionException;
import org.mule.runtime.api.util.Preconditions;
import org.mule.runtime.core.api.MuleContext;
import org.mule.runtime.extension.api.connectivity.TransactionalConnection;
import org.mule.runtime.extension.api.connectivity.XATransactionalConnection;
import org.mule.runtime.extension.api.runtime.source.SourceCallback;
import org.mule.runtime.extension.api.runtime.source.SourceCallbackContext;
import org.mule.runtime.extension.api.tx.TransactionHandle;
import org.mule.runtime.module.extension.internal.runtime.source.SourceCallbackAdapter;
import org.mule.runtime.module.extension.internal.runtime.source.SourceCallbackContextAdapter;
import org.mule.runtime.module.extension.internal.runtime.transaction.DefaultTransactionHandle;
import org.mule.runtime.module.extension.internal.runtime.transaction.NullTransactionHandle;
import org.mule.runtime.module.extension.internal.runtime.transaction.XaTransactionHandle;

class DefaultSourceCallbackContext
implements SourceCallbackContextAdapter {
    private static final TransactionHandle NULL_TRANSACTION_HANDLE = new NullTransactionHandle();
    private final SourceCallbackAdapter sourceCallback;
    private final MuleContext muleContext;
    private final Map<String, Object> variables = new HashMap<String, Object>();
    private Object connection = null;
    private TransactionHandle transactionHandle = NULL_TRANSACTION_HANDLE;

    DefaultSourceCallbackContext(SourceCallbackAdapter sourceCallback, MuleContext muleContext) {
        this.sourceCallback = sourceCallback;
        this.muleContext = muleContext;
    }

    public TransactionHandle bindConnection(Object connection) throws ConnectionException, TransactionException {
        Preconditions.checkArgument((connection != null ? 1 : 0) != 0, (String)"Cannot bind a null connection");
        if (this.connection != null) {
            throw new IllegalArgumentException("Connection can only be set once per " + SourceCallbackContext.class.getSimpleName());
        }
        this.connection = connection;
        if (this.sourceCallback.getTransactionConfig().isTransacted() && connection instanceof TransactionalConnection) {
            TransactionManager transactionManager;
            ConnectionHandler<Object> connectionHandler = this.sourceCallback.getSourceConnectionManager().getConnectionHandler(connection);
            this.sourceCallback.getTransactionSourceBinder().bindToTransaction(this.sourceCallback.getTransactionConfig(), this.sourceCallback.getConfigurationInstance(), connectionHandler);
            this.transactionHandle = connection instanceof XATransactionalConnection ? ((transactionManager = this.muleContext.getTransactionManager()) != null ? new XaTransactionHandle(transactionManager) : new DefaultTransactionHandle((TransactionalConnection)connection)) : new DefaultTransactionHandle((TransactionalConnection)connection);
        }
        return this.transactionHandle;
    }

    public <T> T getConnection() {
        if (this.connection == null) {
            throw new IllegalArgumentException("No connection has been bound");
        }
        return (T)this.connection;
    }

    @Override
    public void releaseConnection() {
        if (this.connection != null) {
            this.sourceCallback.getSourceConnectionManager().release(this.connection);
        }
    }

    public TransactionHandle getTransactionHandle() {
        return this.transactionHandle;
    }

    public boolean hasVariable(String variableName) {
        return this.variables.containsKey(variableName);
    }

    public <T> Optional<T> getVariable(String variableName) {
        return Optional.ofNullable(this.variables.get(variableName));
    }

    public void addVariable(String variableName, Object value) {
        this.variables.put(variableName, value);
    }

    public <T, A> SourceCallback<T, A> getSourceCallback() {
        return this.sourceCallback;
    }
}

