/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.extension.internal.runtime.source;

import com.google.common.base.Predicate;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import javax.inject.Inject;
import org.apache.commons.collections.CollectionUtils;
import org.mule.runtime.api.component.location.ComponentLocation;
import org.mule.runtime.api.connection.ConnectionException;
import org.mule.runtime.api.connection.ConnectionHandler;
import org.mule.runtime.api.exception.MuleException;
import org.mule.runtime.api.exception.MuleRuntimeException;
import org.mule.runtime.api.i18n.I18nMessageFactory;
import org.mule.runtime.api.lifecycle.Initialisable;
import org.mule.runtime.api.lifecycle.InitialisationException;
import org.mule.runtime.api.lifecycle.Startable;
import org.mule.runtime.api.lifecycle.Stoppable;
import org.mule.runtime.api.meta.model.ExtensionModel;
import org.mule.runtime.api.meta.model.source.SourceModel;
import org.mule.runtime.core.api.DefaultMuleException;
import org.mule.runtime.core.api.Event;
import org.mule.runtime.core.api.MuleContext;
import org.mule.runtime.core.api.connector.ConnectionManager;
import org.mule.runtime.core.api.construct.Flow;
import org.mule.runtime.core.api.construct.FlowConstruct;
import org.mule.runtime.core.api.construct.FlowConstructAware;
import org.mule.runtime.core.api.exception.MessagingException;
import org.mule.runtime.core.api.functional.Either;
import org.mule.runtime.core.api.lifecycle.LifecycleUtils;
import org.mule.runtime.core.api.streaming.CursorProviderFactory;
import org.mule.runtime.core.api.streaming.StreamingManager;
import org.mule.runtime.extension.api.annotation.param.Config;
import org.mule.runtime.extension.api.annotation.param.Connection;
import org.mule.runtime.extension.api.exception.IllegalModelDefinitionException;
import org.mule.runtime.extension.api.runtime.ConfigurationInstance;
import org.mule.runtime.extension.api.runtime.FlowInfo;
import org.mule.runtime.extension.api.runtime.source.Source;
import org.mule.runtime.extension.api.runtime.source.SourceCallback;
import org.mule.runtime.extension.api.runtime.source.SourceCallbackContext;
import org.mule.runtime.extension.api.tx.SourceTransactionalAction;
import org.mule.runtime.extension.internal.property.TransactionalActionModelProperty;
import org.mule.runtime.module.extension.internal.loader.java.property.DeclaringMemberModelProperty;
import org.mule.runtime.module.extension.internal.loader.java.property.SourceCallbackModelProperty;
import org.mule.runtime.module.extension.internal.runtime.resolver.ResolverSet;
import org.mule.runtime.module.extension.internal.runtime.resolver.ResolverSetResult;
import org.mule.runtime.module.extension.internal.runtime.resolver.ValueResolver;
import org.mule.runtime.module.extension.internal.runtime.resolver.ValueResolvingContext;
import org.mule.runtime.module.extension.internal.runtime.source.ImmutableFlowInfo;
import org.mule.runtime.module.extension.internal.runtime.source.NullSourceCallbackExecutor;
import org.mule.runtime.module.extension.internal.runtime.source.NullSourceCompletionHandler;
import org.mule.runtime.module.extension.internal.runtime.source.ReflectiveSourceCallbackExecutor;
import org.mule.runtime.module.extension.internal.runtime.source.SourceCallbackExecutor;
import org.mule.runtime.module.extension.internal.runtime.source.SourceCallbackFactory;
import org.mule.runtime.module.extension.internal.runtime.source.SourceCompletionHandler;
import org.mule.runtime.module.extension.internal.runtime.source.SourceCompletionHandlerFactory;
import org.mule.runtime.module.extension.internal.util.FieldSetter;
import org.mule.runtime.module.extension.internal.util.IntrospectionUtils;
import org.mule.runtime.module.extension.internal.util.MuleExtensionUtils;
import org.reactivestreams.Publisher;
import org.reflections.ReflectionUtils;

public final class SourceAdapter
implements Startable,
Stoppable,
Initialisable,
FlowConstructAware {
    private final ExtensionModel extensionModel;
    private final SourceModel sourceModel;
    private final Source source;
    private final Optional<ConfigurationInstance> configurationInstance;
    private final Optional<FieldSetter<Object, Object>> configurationSetter;
    private final Optional<FieldSetter<Object, Object>> connectionSetter;
    private final SourceCallbackFactory sourceCallbackFactory;
    private final CursorProviderFactory cursorProviderFactory;
    private final ResolverSet nonCallbackParameters;
    private final ResolverSet successCallbackParameters;
    private final ResolverSet errorCallbackParameters;
    private ConnectionHandler<Object> connectionHandler;
    private FlowConstruct flowConstruct;
    private ComponentLocation componentLocation;
    @Inject
    private ConnectionManager connectionManager;
    @Inject
    private StreamingManager streamingManager;
    @Inject
    private MuleContext muleContext;

    public SourceAdapter(ExtensionModel extensionModel, SourceModel sourceModel, Source source, Optional<ConfigurationInstance> configurationInstance, CursorProviderFactory cursorProviderFactory, SourceCallbackFactory sourceCallbackFactory, ResolverSet nonCallbackParameters, ResolverSet successCallbackParameters, ResolverSet errorCallbackParameters) {
        this.extensionModel = extensionModel;
        this.sourceModel = sourceModel;
        this.source = source;
        this.cursorProviderFactory = cursorProviderFactory;
        this.configurationInstance = configurationInstance;
        this.sourceCallbackFactory = sourceCallbackFactory;
        this.nonCallbackParameters = nonCallbackParameters;
        this.successCallbackParameters = successCallbackParameters;
        this.errorCallbackParameters = errorCallbackParameters;
        this.configurationSetter = this.fetchField(Config.class);
        this.connectionSetter = this.fetchField(Connection.class);
    }

    private SourceCallback createSourceCallback() {
        return this.sourceCallbackFactory.createSourceCallback(this.createCompletionHandlerFactory());
    }

    private SourceCompletionHandlerFactory createCompletionHandlerFactory() {
        return this.sourceModel.getModelProperty(SourceCallbackModelProperty.class).map(this::doCreateCompletionHandler).orElse(context -> new NullSourceCompletionHandler());
    }

    private SourceCompletionHandlerFactory doCreateCompletionHandler(SourceCallbackModelProperty modelProperty) {
        SourceCallbackExecutor onSuccessExecutor = this.getMethodExecutor(modelProperty.getOnSuccessMethod(), modelProperty);
        SourceCallbackExecutor onErrorExecutor = this.getMethodExecutor(modelProperty.getOnErrorMethod(), modelProperty);
        SourceCallbackExecutor onTerminateExecutor = this.getMethodExecutor(modelProperty.getOnTerminateMethod(), modelProperty);
        return context -> new DefaultSourceCompletionHandler(onSuccessExecutor, onErrorExecutor, onTerminateExecutor, context);
    }

    private SourceCallbackExecutor getMethodExecutor(Optional<Method> method, SourceCallbackModelProperty sourceCallbackModel) {
        return method.map(m -> new ReflectiveSourceCallbackExecutor(this.extensionModel, this.configurationInstance, this.sourceModel, this.source, (Method)m, this.cursorProviderFactory, this.streamingManager, (Flow)this.flowConstruct, this.componentLocation, this.muleContext, sourceCallbackModel)).orElse(new NullSourceCallbackExecutor());
    }

    public void initialise() throws InitialisationException {
        LifecycleUtils.initialiseIfNeeded((Object)this.nonCallbackParameters, (boolean)true, (MuleContext)this.muleContext);
        LifecycleUtils.initialiseIfNeeded((Object)this.errorCallbackParameters, (boolean)true, (MuleContext)this.muleContext);
        LifecycleUtils.initialiseIfNeeded((Object)this.successCallbackParameters, (boolean)true, (MuleContext)this.muleContext);
    }

    public void start() throws MuleException {
        this.injectFlowInfo();
        try {
            this.setConfiguration(this.configurationInstance);
            this.setConnection();
            this.muleContext.getInjector().inject((Object)this.source);
            this.source.onStart(this.createSourceCallback());
        }
        catch (Exception e) {
            throw new DefaultMuleException((Throwable)e);
        }
    }

    private void injectFlowInfo() {
        List<Field> fields = IntrospectionUtils.getFieldsOfType(this.source.getClass(), FlowInfo.class);
        if (fields.isEmpty()) {
            return;
        }
        new FieldSetter<Source, ImmutableFlowInfo>(fields.get(0)).set(this.source, new ImmutableFlowInfo(this.flowConstruct.getName(), ((Flow)this.flowConstruct).getMaxConcurrency()));
    }

    public void stop() throws MuleException {
        try {
            this.source.onStop();
        }
        catch (Exception e) {
            throw new DefaultMuleException((Throwable)e);
        }
        finally {
            this.releaseConnection();
        }
    }

    private void setConfiguration(Optional<ConfigurationInstance> configuration) {
        if (this.configurationSetter.isPresent() && configuration.isPresent()) {
            this.configurationSetter.get().set(this.source, configuration.get().getValue());
        }
    }

    private void setConnection() {
        if (this.connectionSetter.isPresent() && this.configurationInstance.isPresent()) {
            try {
                this.connectionHandler = this.connectionManager.getConnection(this.configurationInstance.get().getValue());
                this.connectionSetter.get().set(this.source, this.connectionHandler.getConnection());
            }
            catch (ConnectionException e) {
                throw new MuleRuntimeException(I18nMessageFactory.createStaticMessage((String)String.format("Could not obtain connection for message source '%s' on flow '%s'", this.getName(), this.flowConstruct.getName())), (Throwable)e);
            }
        }
    }

    Optional<ConfigurationInstance> getConfigurationInstance() {
        return this.configurationInstance;
    }

    Optional<ConnectionHandler> getConnectionHandler() {
        return Optional.ofNullable(this.connectionHandler);
    }

    private void releaseConnection() {
        if (this.connectionHandler != null) {
            try {
                this.connectionHandler.release();
            }
            finally {
                this.connectionHandler = null;
            }
        }
    }

    private <T> Optional<FieldSetter<Object, T>> fetchField(Class<? extends Annotation> annotation) {
        Set fields = ReflectionUtils.getAllFields(this.source.getClass(), (Predicate[])new Predicate[]{ReflectionUtils.withAnnotation(annotation)});
        if (CollectionUtils.isEmpty((Collection)fields)) {
            return Optional.empty();
        }
        if (fields.size() > 1) {
            throw new IllegalModelDefinitionException(String.format("Message Source defined on class '%s' has more than one field annotated with '@%s'. Only one field in the class can bare such annotation", this.source.getClass().getName(), annotation.getSimpleName()));
        }
        return Optional.of(new FieldSetter((Field)fields.iterator().next()));
    }

    public String getName() {
        return IntrospectionUtils.getSourceName(this.source.getClass());
    }

    public Source getDelegate() {
        return this.source;
    }

    public SourceTransactionalAction getTransactionalAction() {
        Object transactionalAction;
        ValueResolver valueResolver = this.nonCallbackParameters.getResolvers().get(this.getTransactionalActionFieldName());
        try {
            transactionalAction = valueResolver.resolve(ValueResolvingContext.from(MuleExtensionUtils.getInitialiserEvent(this.muleContext)));
        }
        catch (MuleException e) {
            throw new MuleRuntimeException(I18nMessageFactory.createStaticMessage((String)"Unable to get the Transactional Action value for Message Source"), (Throwable)e);
        }
        if (!(transactionalAction instanceof SourceTransactionalAction)) {
            throw new IllegalStateException("The resolved value is not a Transactional Action");
        }
        return (SourceTransactionalAction)transactionalAction;
    }

    private String getTransactionalActionFieldName() {
        return this.sourceModel.getAllParameterModels().stream().filter(param -> param.getModelProperty(TransactionalActionModelProperty.class).isPresent()).filter(param -> param.getModelProperty(DeclaringMemberModelProperty.class).isPresent()).map(param -> (DeclaringMemberModelProperty)param.getModelProperty(DeclaringMemberModelProperty.class).get()).findAny().map(modelProperty -> modelProperty.getDeclaringField().getName()).orElse("transactionalAction");
    }

    public void setFlowConstruct(FlowConstruct flowConstruct) {
        this.flowConstruct = flowConstruct;
    }

    public void setComponentLocation(ComponentLocation componentLocation) {
        this.componentLocation = componentLocation;
    }

    public class DefaultSourceCompletionHandler
    implements SourceCompletionHandler {
        private final SourceCallbackExecutor onSuccessExecutor;
        private final SourceCallbackExecutor onErrorExecutor;
        private final SourceCallbackContext context;
        private final SourceCallbackExecutor onTerminateExecutor;

        public DefaultSourceCompletionHandler(SourceCallbackExecutor onSuccessExecutor, SourceCallbackExecutor onErrorExecutor, SourceCallbackExecutor onTerminateExecutor, SourceCallbackContext context) {
            this.onSuccessExecutor = onSuccessExecutor;
            this.onErrorExecutor = onErrorExecutor;
            this.onTerminateExecutor = onTerminateExecutor;
            this.context = context;
        }

        @Override
        public Publisher<Void> onCompletion(Event event, Map<String, Object> parameters) {
            return this.onSuccessExecutor.execute(event, parameters, this.context);
        }

        @Override
        public Publisher<Void> onFailure(MessagingException exception, Map<String, Object> parameters) {
            return this.onErrorExecutor.execute(exception.getEvent(), parameters, this.context);
        }

        @Override
        public void onTerminate(Either<MessagingException, Event> result) throws Exception {
            Event event = result.isRight() ? (Event)result.getRight() : ((MessagingException)result.getLeft()).getEvent();
            this.onTerminateExecutor.execute(event, Collections.emptyMap(), this.context);
        }

        @Override
        public Map<String, Object> createResponseParameters(Event event) throws MessagingException {
            try {
                ResolverSetResult parameters = SourceAdapter.this.successCallbackParameters.resolve(ValueResolvingContext.from(event, SourceAdapter.this.configurationInstance));
                return parameters.asMap();
            }
            catch (Exception e) {
                throw new MessagingException(event, (Throwable)e);
            }
        }

        @Override
        public Map<String, Object> createFailureResponseParameters(Event event) throws MessagingException {
            try {
                ResolverSetResult parameters = SourceAdapter.this.errorCallbackParameters.resolve(ValueResolvingContext.from(event, SourceAdapter.this.configurationInstance));
                return parameters.asMap();
            }
            catch (Exception e) {
                throw new MessagingException(event, (Throwable)e);
            }
        }
    }
}

