/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.extension.internal.runtime.operation;

import java.util.function.Consumer;
import org.mule.runtime.api.message.Message;
import org.mule.runtime.api.meta.model.ExtensionModel;
import org.mule.runtime.api.meta.model.operation.OperationModel;
import org.mule.runtime.api.util.Preconditions;
import org.mule.runtime.core.api.Event;
import org.mule.runtime.core.api.exception.MessagingException;
import org.mule.runtime.extension.api.runtime.operation.FlowListener;
import org.reactivestreams.Publisher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import reactor.core.publisher.Mono;

public class DefaultFlowListener
implements FlowListener {
    private static final Logger LOGGER = LoggerFactory.getLogger(DefaultFlowListener.class);
    private final ExtensionModel extensionModel;
    private final OperationModel operationModel;
    private Consumer<Message> successConsumer;
    private Consumer<Exception> errorConsumer;
    private Runnable onComplete;

    public DefaultFlowListener(ExtensionModel extensionModel, OperationModel operationModel, Event event) {
        this.extensionModel = extensionModel;
        this.operationModel = operationModel;
        Mono.from((Publisher)event.getContext().getResponsePublisher()).doAfterTerminate((responseEvent, t) -> this.onTerminate((Event)responseEvent, (Throwable)t)).subscribe();
    }

    public void onSuccess(Consumer<Message> handler) {
        this.assertNotNull(handler);
        this.successConsumer = handler;
    }

    public void onError(Consumer<Exception> handler) {
        this.assertNotNull(handler);
        this.errorConsumer = handler;
    }

    public void onComplete(Runnable handler) {
        this.assertNotNull(handler);
        this.onComplete = handler;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void onTerminate(Event event, Throwable error) {
        try {
            if (event != null && this.successConsumer != null) {
                try {
                    this.successConsumer.accept(event.getMessage());
                }
                catch (Exception e) {
                    LOGGER.warn("Operation " + this.operationModel.getName() + " from extension " + this.extensionModel.getName() + " threw exception while executing the onSuccess FlowListener", (Throwable)e);
                }
            } else if (error != null && this.errorConsumer != null) {
                Exception exception = error instanceof Exception ? (Exception)error : new MessagingException(event, error);
                try {
                    this.errorConsumer.accept(exception);
                }
                catch (Exception e) {
                    LOGGER.warn("Operation " + this.operationModel.getName() + " from extension " + this.extensionModel.getName() + " threw exception while executing the onError FlowListener", (Throwable)e);
                }
            }
        }
        finally {
            if (this.onComplete != null) {
                try {
                    this.onComplete.run();
                }
                catch (Exception e) {
                    LOGGER.warn("Operation " + this.operationModel.getName() + " from extension " + this.extensionModel.getName() + " threw exception while executing the onComplete FlowListener", (Throwable)e);
                }
            }
        }
    }

    private void assertNotNull(Object handler) {
        Preconditions.checkArgument((handler != null ? 1 : 0) != 0, (String)"Cannot set null handler");
    }
}

